/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.openxml.BlockProperties;
import net.sf.okapi.filters.openxml.Formula;
import net.sf.okapi.filters.openxml.Nameable;
import net.sf.okapi.filters.openxml.ParagraphBlockProperties;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.XMLEvents;

interface MarkupComponent
extends XMLEvents {
    public void apply(FontMappings var1);

    public static boolean isStart(MarkupComponent markupComponent) {
        return markupComponent instanceof Start;
    }

    public static boolean isEnd(MarkupComponent markupComponent) {
        return markupComponent instanceof End;
    }

    public static boolean isSheetViewStart(MarkupComponent markupComponent) {
        return MarkupComponent.isStart(markupComponent) && "sheetView".equals(((Start)markupComponent).getName().getLocalPart());
    }

    public static boolean isAlignmentStart(MarkupComponent markupComponent) {
        return MarkupComponent.isStart(markupComponent) && "alignment".equals(((Start)markupComponent).getName().getLocalPart());
    }

    public static boolean isTableColumnStart(MarkupComponent markupComponent) {
        return MarkupComponent.isStart(markupComponent) && "tableColumn".equals(((Start)markupComponent).getName().getLocalPart());
    }

    public static boolean isDataFieldStart(MarkupComponent markupComponent) {
        return MarkupComponent.isStart(markupComponent) && "dataField".equals(((Start)markupComponent).getName().getLocalPart());
    }

    public static boolean isWorksheetSourceStart(MarkupComponent markupComponent) {
        return MarkupComponent.isStart(markupComponent) && "worksheetSource".equals(((Start)markupComponent).getName().getLocalPart());
    }

    public static boolean isCacheFieldStart(MarkupComponent markupComponent) {
        return MarkupComponent.isStart(markupComponent) && "cacheField".equals(((Start)markupComponent).getName().getLocalPart());
    }

    public static boolean isPresentationStart(MarkupComponent markupComponent) {
        return MarkupComponent.isStart(markupComponent) && "presentation".equals(((Start)markupComponent).getName().getLocalPart());
    }

    public static boolean isTableStart(MarkupComponent markupComponent) {
        return MarkupComponent.isStart(markupComponent) && "tbl".equals(((Start)markupComponent).getName().getLocalPart());
    }

    public static boolean isTextBodyStart(MarkupComponent markupComponent) {
        return MarkupComponent.isStart(markupComponent) && "txBody".equals(((Start)markupComponent).getName().getLocalPart());
    }

    public static boolean isParagraphStart(MarkupComponent markupComponent) {
        return markupComponent instanceof ParagraphStart;
    }

    public static boolean isWordStylesStart(MarkupComponent markupComponent) {
        return MarkupComponent.isStart(markupComponent) && "styles".equals(((Start)markupComponent).getName().getLocalPart());
    }

    public static boolean isWordStylesEnd(MarkupComponent markupComponent) {
        return MarkupComponent.isEnd(markupComponent) && "styles".equals(((End)markupComponent).getName().getLocalPart());
    }

    public static boolean isWordDocumentDefaultsStart(MarkupComponent markupComponent) {
        return MarkupComponent.isStart(markupComponent) && "docDefaults".equals(((Start)markupComponent).getName().getLocalPart());
    }

    public static boolean isWordDocumentDefaultsEnd(MarkupComponent markupComponent) {
        return MarkupComponent.isEnd(markupComponent) && "docDefaults".equals(((End)markupComponent).getName().getLocalPart());
    }

    public static boolean isWordStyleStart(MarkupComponent markupComponent) {
        return MarkupComponent.isStart(markupComponent) && "style".equals(((Start)markupComponent).getName().getLocalPart());
    }

    public static boolean isWordStyleEnd(MarkupComponent markupComponent) {
        return MarkupComponent.isEnd(markupComponent) && "style".equals(((End)markupComponent).getName().getLocalPart());
    }

    public static boolean isWordParagraphPropertiesDefaultStart(MarkupComponent markupComponent) {
        return markupComponent instanceof ParagraphStart && "pPrDefault".equals(((ParagraphStart)markupComponent).getName().getLocalPart());
    }

    public static boolean isWordRunPropertiesDefaultStart(MarkupComponent markupComponent) {
        return MarkupComponent.isStart(markupComponent) && "rPrDefault".equals(((Start)markupComponent).getName().getLocalPart());
    }

    public static boolean isWordRunPropertiesDefaultEnd(MarkupComponent markupComponent) {
        return MarkupComponent.isEnd(markupComponent) && "rPrDefault".equals(((End)markupComponent).getName().getLocalPart());
    }

    public static boolean isParagraphBlockProperties(MarkupComponent markupComponent) {
        return markupComponent instanceof ParagraphBlockProperties;
    }

    public static boolean isRunProperties(MarkupComponent markupComponent) {
        return markupComponent instanceof RunProperties;
    }

    public static boolean isBlockProperties(MarkupComponent markupComponent) {
        return markupComponent instanceof BlockProperties;
    }

    public static boolean isTableBlockProperties(MarkupComponent markupComponent) {
        return MarkupComponent.isBlockProperties(markupComponent) && "tblPr".equals(((BlockProperties)markupComponent).startElement().getName().getLocalPart());
    }

    public static boolean isFormula(MarkupComponent markupComponent) {
        return markupComponent instanceof Formula;
    }

    public static interface Context {
        public static final String DEFAULT_NAME = "";

        public String name();

        public static class Default
        implements Context {
            private final String name;

            Default(String name) {
                this.name = name;
            }

            @Override
            public String name() {
                return this.name;
            }
        }
    }

    public static final class General
    implements MarkupComponent {
        private static final Set<Character> WHITESPACES = new HashSet<Character>(Arrays.asList(Character.valueOf(' '), Character.valueOf('\t'), Character.valueOf('\r'), Character.valueOf('\n')));
        private List<XMLEvent> events;

        General(List<XMLEvent> events) {
            this.events = events;
        }

        boolean eventsAreWhitespaces() {
            if (this.events.stream().allMatch(e -> 5 == e.getEventType() || 3 == e.getEventType() || e.isCharacters())) {
                return this.events.stream().filter(e -> e.isCharacters()).map(e -> e.asCharacters().getData()).flatMap(s -> s.chars().mapToObj(c -> Character.valueOf((char)c))).allMatch(c -> WHITESPACES.contains(c));
            }
            return false;
        }

        @Override
        public void apply(FontMappings fontMappings) {
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.events;
        }
    }

    public static class EmptyElement
    implements MarkupComponent,
    Nameable {
        private static final int EMPTY_ELEMENT_EVENTS_SIZE = 2;
        private XMLEventFactory eventFactory;
        private StartElement startElement;
        private EndElement endElement;
        private List<Attribute> attributes = new ArrayList<Attribute>();

        EmptyElement(XMLEventFactory eventFactory, StartElement startElement, EndElement endElement) {
            this.eventFactory = eventFactory;
            this.startElement = startElement;
            this.endElement = endElement;
            Iterator<Attribute> iterator = startElement.getAttributes();
            while (iterator.hasNext()) {
                this.attributes.add(iterator.next());
            }
        }

        @Override
        public void apply(FontMappings fontMappings) {
        }

        @Override
        public List<XMLEvent> getEvents() {
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>(2);
            events.add(this.eventFactory.createStartElement(this.startElement.getName(), this.getAttributes().iterator(), this.startElement.getNamespaces()));
            events.add(this.endElement);
            return events;
        }

        @Override
        public QName getName() {
            return this.startElement.getName();
        }

        List<Attribute> getAttributes() {
            return this.attributes;
        }
    }

    public static class End
    implements MarkupComponent,
    Nameable {
        private EndElement endElement;

        End(EndElement endElement) {
            this.endElement = endElement;
        }

        @Override
        public void apply(FontMappings fontMappings) {
        }

        @Override
        public List<XMLEvent> getEvents() {
            return Collections.singletonList(this.endElement);
        }

        @Override
        public QName getName() {
            return this.endElement.getName();
        }

        public String toString() {
            return "</".concat(this.endElement.getName().getPrefix()).concat(":").concat(this.endElement.getName().getLocalPart()).concat(">");
        }
    }

    public static final class ParagraphStart
    implements MarkupComponent,
    Nameable {
        private final Start start;
        private final StyleDefinitions styleDefinitions;

        ParagraphStart(XMLEventFactory eventFactory, StyleDefinitions styleDefinitions, StartElement startElement) {
            this(new Start(eventFactory, startElement), styleDefinitions);
        }

        ParagraphStart(Start start, StyleDefinitions styleDefinitions) {
            this.start = start;
            this.styleDefinitions = styleDefinitions;
        }

        @Override
        public void apply(FontMappings fontMappings) {
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.start.getEvents();
        }

        @Override
        public QName getName() {
            return this.start.getName();
        }

        List<Attribute> getAttributes() {
            return this.start.getAttributes();
        }

        boolean containsAttributeWithAnyOfValues(String name, Set<String> values) {
            return this.start.containsAttributeWithAnyOfValues(name, values);
        }

        StyleDefinitions styleDefinitions() {
            return this.styleDefinitions;
        }

        public String toString() {
            return this.start.toString();
        }
    }

    public static class Start
    implements MarkupComponent,
    Nameable {
        private final XMLEventFactory eventFactory;
        private final StartElement startElement;
        private final List<Attribute> attributes;
        private final Context context;

        Start(XMLEventFactory eventFactory, StartElement startElement) {
            this(eventFactory, startElement, new Context.Default(""));
        }

        Start(XMLEventFactory eventFactory, StartElement startElement, Context context) {
            this(eventFactory, startElement, Start.attributesOf(startElement), context);
        }

        private static List<Attribute> attributesOf(StartElement startElement) {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            Iterator<Attribute> iterator = startElement.getAttributes();
            while (iterator.hasNext()) {
                attributes.add(iterator.next());
            }
            return attributes;
        }

        Start(XMLEventFactory eventFactory, StartElement startElement, List<Attribute> attributes, Context context) {
            this.eventFactory = eventFactory;
            this.startElement = startElement;
            this.attributes = attributes;
            this.context = context;
        }

        @Override
        public void apply(FontMappings fontMappings) {
        }

        @Override
        public List<XMLEvent> getEvents() {
            return Collections.singletonList(this.eventFactory.createStartElement(this.startElement.getName(), this.getAttributes().iterator(), this.startElement.getNamespaces()));
        }

        @Override
        public QName getName() {
            return this.startElement.getName();
        }

        List<Attribute> getAttributes() {
            return this.attributes;
        }

        boolean containsAttributeWithAnyOfValues(String name, Set<String> values) {
            return this.attributes.stream().anyMatch(a -> a.getName().getLocalPart().equals(name) && values.contains(a.getValue()));
        }

        Context context() {
            return this.context;
        }

        public String toString() {
            return "<".concat(this.startElement.getName().getPrefix()).concat(":").concat(this.startElement.getName().getLocalPart()).concat(">");
        }
    }
}

