/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.CellType;
import net.sf.okapi.filters.openxml.DifferentialFormat;
import net.sf.okapi.filters.openxml.ExcelNumber;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

interface CellValue {
    public static final String NAME = "v";

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public void update(Characters var1);

    public void updateFormer(Characters var1);

    public String asFormattedString();

    public int asInteger();

    public int asFormerInteger();

    public Markup asMarkup();

    public static class Default
    implements CellValue {
        private static final String EMPTY = "";
        private final XMLEventFactory eventFactory;
        private final boolean date1904;
        private final CellType type;
        private final DifferentialFormat.Combined combinedFormat;
        private final StartElement startElement;
        private final List<Characters> characters;
        private final List<Characters> formerCharacters;
        private EndElement endElement;

        Default(XMLEventFactory eventFactory, boolean date1904, CellType type, DifferentialFormat.Combined combinedFormat, StartElement startElement) {
            this(eventFactory, date1904, type, combinedFormat, startElement, new ArrayList<Characters>(), new ArrayList<Characters>());
        }

        Default(XMLEventFactory eventFactory, boolean date1904, CellType type, DifferentialFormat.Combined combinedFormat, StartElement startElement, List<Characters> characters, List<Characters> formerCharacters) {
            this.eventFactory = eventFactory;
            this.date1904 = date1904;
            this.type = type;
            this.combinedFormat = combinedFormat;
            this.startElement = startElement;
            this.characters = characters;
            this.formerCharacters = formerCharacters;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = e.asEndElement();
                    break;
                }
                if (!e.isCharacters()) continue;
                this.characters.add(e.asCharacters());
            }
        }

        @Override
        public void update(Characters characters) {
            this.formerCharacters.clear();
            this.formerCharacters.addAll(this.characters);
            this.characters.clear();
            this.characters.add(characters);
        }

        @Override
        public void updateFormer(Characters characters) {
            this.formerCharacters.clear();
            this.formerCharacters.add(characters);
        }

        @Override
        public String asFormattedString() {
            String s = this.characters.stream().map(chars -> chars.getData()).collect(Collectors.joining()).trim();
            switch (this.type) {
                case BOOLEAN: {
                    return XMLEventHelpers.booleanAttributeTrueValues().contains(s) ? XMLEventHelpers.BooleanAttributeValue.TRUE_STRING.toString() : XMLEventHelpers.BooleanAttributeValue.FALSE_STRING.toString();
                }
                case ERROR: {
                    return EMPTY;
                }
                case NUMBER: {
                    return new ExcelNumber.Default(s, this.date1904).formattedWith(this.combinedFormat.numberFormat());
                }
            }
            return s;
        }

        @Override
        public int asInteger() {
            return Default.integerFrom(this.characters.stream().map(chars -> chars.getData()).collect(Collectors.joining()));
        }

        @Override
        public int asFormerInteger() {
            return Default.integerFrom(this.formerCharacters.stream().map(chars -> chars.getData()).collect(Collectors.joining()));
        }

        private static int integerFrom(String value) {
            try {
                return Integer.parseUnsignedInt(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Unexpected string: ".concat(value));
            }
        }

        @Override
        public Markup asMarkup() {
            MarkupBuilder mb = new MarkupBuilder(new Markup.General(new ArrayList<MarkupComponent>()));
            mb.add(this.startElement);
            this.characters.forEach(chars -> mb.add((XMLEvent)chars));
            mb.add(this.endElement());
            return mb.build();
        }

        private EndElement endElement() {
            if (null == this.endElement) {
                this.endElement = this.eventFactory.createEndElement(this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), CellValue.NAME);
            }
            return this.endElement;
        }
    }
}

