/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.Nameable;
import net.sf.okapi.filters.openxml.Property;

interface BlockProperties
extends MarkupComponent,
Nameable {
    public static final String TBL_PR = "tblPr";
    public static final String TR_PR = "trPr";
    public static final String TC_PR = "tcPr";
    public static final String TBL_STYLE_PR = "tblStylePr";
    public static final String BODY_PR = "bodyPr";
    public static final String SMART_TAG_PROPERTIES = "smartTagPr";
    public static final String STRUCTURAL_DOCUMENT_TAG_PROPERTIES = "sdtPr";
    public static final String STRUCTURAL_DOCUMENT_TAG_END_PROPERTIES = "sdtEndPr";

    public StartElement startElement();

    public List<Attribute> attributes();

    public List<Property> properties();

    public EndElement endElement();

    public boolean isEmpty();

    public static final class Default
    implements BlockProperties {
        private final XMLEventFactory eventFactory;
        private final StartElement startElement;
        private final EndElement endElement;
        private final List<Attribute> attributes;
        private final List<Property> properties;

        Default(XMLEventFactory eventFactory, String prefix, String namespaceUri, String name) {
            this(eventFactory, eventFactory.createStartElement(prefix, namespaceUri, name, null, null), eventFactory.createEndElement(prefix, namespaceUri, name, null));
        }

        Default(XMLEventFactory eventFactory, StartElement startElement, EndElement endElement) {
            this(eventFactory, startElement, endElement, new ArrayList<Property>());
        }

        Default(XMLEventFactory eventFactory, StartElement startElement, EndElement endElement, List<Property> properties) {
            this.eventFactory = eventFactory;
            this.startElement = startElement;
            this.endElement = endElement;
            this.attributes = new ArrayList<Attribute>();
            Iterator<Attribute> iterator = startElement.getAttributes();
            while (iterator.hasNext()) {
                this.attributes.add(iterator.next());
            }
            this.properties = new ArrayList<Property>(properties);
        }

        @Override
        public void apply(FontMappings fontMappings) {
        }

        @Override
        public QName getName() {
            return this.startElement.getName();
        }

        @Override
        public List<XMLEvent> getEvents() {
            if (this.isEmpty() && !BlockProperties.BODY_PR.equals(this.startElement.getName().getLocalPart())) {
                return Collections.emptyList();
            }
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
            events.add(this.eventFactory.createStartElement(this.startElement.getName(), this.attributes().iterator(), this.startElement.getNamespaces()));
            for (Property property : this.properties) {
                events.addAll(property.getEvents());
            }
            events.add(this.endElement);
            return events;
        }

        @Override
        public StartElement startElement() {
            return this.startElement;
        }

        @Override
        public List<Attribute> attributes() {
            return this.attributes;
        }

        @Override
        public List<Property> properties() {
            return this.properties;
        }

        @Override
        public EndElement endElement() {
            return this.endElement;
        }

        @Override
        public boolean isEmpty() {
            return this.attributes.isEmpty() && this.properties.isEmpty();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            String prefix = this.startElement.getName().getPrefix();
            if (!prefix.isEmpty()) {
                builder.append(prefix).append(":");
            }
            builder.append(this.startElement.getName().getLocalPart()).append(" ").append("(").append(this.attributes.size()).append(")").append(this.toString(this.attributes)).append(" ").append("(").append(this.properties.size()).append(")").append(this.properties);
            return builder.toString();
        }

        private String toString(List<Attribute> attributes) {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            for (Attribute attribute : attributes) {
                String prefix = attribute.getName().getPrefix();
                if (!prefix.isEmpty()) {
                    builder.append(prefix).append(":");
                }
                builder.append(attribute.getName().getLocalPart()).append("=\"");
                builder.append(attribute.getValue()).append("\"");
            }
            builder.append("]");
            return builder.toString();
        }
    }
}

