/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.filters.idml.Accumulation;
import net.sf.okapi.filters.idml.DocumentPartEventBuilder;
import net.sf.okapi.filters.idml.Markup;
import net.sf.okapi.filters.idml.MarkupRange;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.Story;
import net.sf.okapi.filters.idml.StoryChildElement;
import net.sf.okapi.filters.idml.StoryChildElementsEventsAccumulation;

class StoryEventsAccumulation
implements Accumulation<Event> {
    private final Story story;
    private final Parameters parameters;
    private final XMLEventFactory eventFactory;
    private final IdGenerator documentPartIdGenerator;
    private final IdGenerator textUnitIdGenerator;
    private List<Event> events;

    StoryEventsAccumulation(Story story, Parameters parameters, XMLEventFactory eventFactory, IdGenerator documentPartIdGenerator, IdGenerator textUnitIdGenerator) {
        this.story = story;
        this.parameters = parameters;
        this.eventFactory = eventFactory;
        this.documentPartIdGenerator = documentPartIdGenerator;
        this.textUnitIdGenerator = textUnitIdGenerator;
        this.events = new ArrayList<Event>();
    }

    @Override
    public List<Event> asList() throws XMLStreamException {
        DocumentPartEventBuilder documentPartEventBuilder = new DocumentPartEventBuilder(this.documentPartIdGenerator, new Markup.Default(new LinkedList<MarkupRange>()));
        documentPartEventBuilder.addMarkupRange(Collections.singletonList(this.story.getStartDocumentEvent()));
        documentPartEventBuilder.addMarkupRangeStartElement(this.story.getWrappingStoryStartElement());
        documentPartEventBuilder.addMarkupRangeStartElement(this.story.getStoryStartElement());
        this.events.add(documentPartEventBuilder.build());
        ListIterator<StoryChildElement> storyChildElementIterator = this.story.getChildElements().listIterator();
        List<Event> storyChildElementEvents = new StoryChildElementsEventsAccumulation(this.parameters, this.eventFactory, this.documentPartIdGenerator, this.textUnitIdGenerator, storyChildElementIterator).asList();
        this.events.addAll(storyChildElementEvents);
        documentPartEventBuilder = new DocumentPartEventBuilder(this.documentPartIdGenerator, new Markup.Default(new LinkedList<MarkupRange>()));
        documentPartEventBuilder.addMarkupRangeEndElement(this.story.getStoryEndElement());
        documentPartEventBuilder.addMarkupRangeEndElement(this.story.getWrappingStoryEndElement());
        documentPartEventBuilder.addMarkupRange(Collections.singletonList(this.story.getEndDocumentEvent()));
        this.events.add(documentPartEventBuilder.build());
        return this.events;
    }
}

