/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.StoryChildElement;
import net.sf.okapi.filters.idml.StyleRangeEventsGenerator;
import net.sf.okapi.filters.idml.StyleRanges;

class StoryChildElementsWriter {
    private final StyleRangeEventsGenerator styleRangeEventsGenerator;
    private List<XMLEvent> events;
    private StyleRanges currentStyleRanges;

    StoryChildElementsWriter(StyleRangeEventsGenerator styleRangeEventsGenerator) {
        this.styleRangeEventsGenerator = styleRangeEventsGenerator;
    }

    List<XMLEvent> write(List<StoryChildElement> storyChildElements) {
        this.events = new ArrayList<XMLEvent>();
        for (StoryChildElement storyChildElement : storyChildElements) {
            if (!(storyChildElement instanceof StoryChildElement.StyledTextElement)) {
                this.writeAsNonStyledTextElement(storyChildElement);
                continue;
            }
            this.writeAsStyledTextElement(storyChildElement);
        }
        return this.events;
    }

    private void writeAsNonStyledTextElement(StoryChildElement storyChildElement) {
        if (null != this.currentStyleRanges) {
            this.writeClosingStyleRanges();
        }
        this.events.addAll(storyChildElement.getEvents());
        if (null != this.currentStyleRanges) {
            this.writeOpeningStyleRanges();
        }
    }

    private void writeAsStyledTextElement(StoryChildElement storyChildElement) {
        if (null == this.currentStyleRanges) {
            this.currentStyleRanges = ((StoryChildElement.StyledTextElement)storyChildElement).getStyleRanges();
            this.writeOpeningStyleRanges();
        }
        StyleRanges styleRanges = ((StoryChildElement.StyledTextElement)storyChildElement).getStyleRanges();
        if (!this.currentStyleRanges.getParagraphStyleRange().equals(styleRanges.getParagraphStyleRange())) {
            this.writeClosingStyleRanges();
            this.currentStyleRanges = styleRanges;
            this.writeOpeningStyleRanges();
        } else if (!this.currentStyleRanges.getCharacterStyleRange().equals(styleRanges.getCharacterStyleRange())) {
            this.events.addAll(this.styleRangeEventsGenerator.generateCharacterStyleRangeEnd());
            this.currentStyleRanges = styleRanges;
            this.events.addAll(this.styleRangeEventsGenerator.generateCharacterStyleRangeStart(this.currentStyleRanges));
        }
        this.events.addAll(storyChildElement.getEvents());
    }

    private void writeOpeningStyleRanges() {
        this.events.addAll(this.styleRangeEventsGenerator.generateParagraphStyleRangeStart(this.currentStyleRanges));
        this.events.addAll(this.styleRangeEventsGenerator.generateCharacterStyleRangeStart(this.currentStyleRanges));
    }

    private void writeClosingStyleRanges() {
        this.events.addAll(this.styleRangeEventsGenerator.generateCharacterStyleRangeEnd());
        this.events.addAll(this.styleRangeEventsGenerator.generateParagraphStyleRangeEnd());
    }
}

