/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.kantan;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.kantan.KantanMTv21ConnectorParameters;
import net.sf.okapi.lib.translation.BaseConnector;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KantanMTv21Connector
extends BaseConnector {
    public static final String STATE_OFFLINE = "offline";
    public static final String STATE_RUNNING = "running";
    public static final String STATE_INITIALISING = "initialising";
    public static final String STATE_TERMINATING = "terminating";
    private Logger logger = LoggerFactory.getLogger(KantanMTv21Connector.class);
    private static final String API_SERVER_URL = "https://app.kantanmt.com/api/";
    private static final String CONNECTOR_ERROR = "KantanMT Connector Error: %s";
    private static final int DEFAULT_FUZZY_SCORE = 95;
    private static final int MAX_SEGMENTS = 900;
    private KantanMTv21ConnectorParameters parameters;
    private JSONParser parser;
    private CloseableHttpClient httpClient = null;
    private List<QueryResult> results = new ArrayList<QueryResult>();

    public KantanMTv21Connector() {
        this.parameters = new KantanMTv21ConnectorParameters();
        this.parser = new JSONParser();
        this.httpClient = HttpClientBuilder.create().build();
    }

    @Override
    public String getName() {
        return "KantanMT v2.1";
    }

    @Override
    public String getSettingsDisplay() {
        String engine = this.parameters != null ? this.parameters.getEngine() : "";
        String alias = this.parameters != null ? this.parameters.getAlias() : "";
        StringBuilder sb = new StringBuilder("URL: https://app.kantanmt.com/api/\n");
        if (!Util.isEmpty(engine)) {
            sb.append("Using engine \"" + engine + "\"");
        } else if (!Util.isEmpty(alias)) {
            sb.append("Using alias \"" + alias + "\"");
        } else {
            sb.append("No engine or alias selected");
        }
        return sb.toString();
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                this.logger.warn("Cannot close HttpClient: {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public KantanMTv21ConnectorParameters getParameters() {
        return this.parameters;
    }

    @Override
    protected String toInternalCode(LocaleId locId) {
        return locId.toString().toLowerCase();
    }

    @Override
    public int query(String plainText) {
        return this.query(new TextFragment(plainText));
    }

    @Override
    public int query(TextFragment tf) {
        this.results = this.batchQuery(Collections.singletonList(tf)).get(0);
        if (this.results.size() > 0) {
            this.current = 0;
        }
        return this.results.size();
    }

    @Override
    public boolean hasNext() {
        if (this.results == null) {
            return false;
        }
        if (this.current >= this.results.size()) {
            this.current = -1;
        }
        return this.current > -1;
    }

    @Override
    public QueryResult next() {
        if (this.results == null) {
            return null;
        }
        if (this.current > -1 && this.current < this.results.size()) {
            ++this.current;
            return this.results.get(this.current - 1);
        }
        this.current = -1;
        return null;
    }

    private void checkParameters() {
        if (Util.isEmpty(this.parameters.getApiToken())) {
            throw new OkapiException("You must specify an authorization token to use this connector.");
        }
        if (Util.isEmpty(this.parameters.getEngine()) && Util.isEmpty(this.parameters.getAlias())) {
            throw new OkapiException("You must specify either an engine name or an alias name to use this connector.");
        }
    }

    @Override
    public List<List<QueryResult>> batchQuery(List<TextFragment> fragments) {
        ArrayList<List<QueryResult>> results = new ArrayList<List<QueryResult>>();
        try {
            this.checkParameters();
            HttpPost post = new HttpPost("https://app.kantanmt.com/api/translate");
            post.addHeader("Content-Type", "application/x-www-form-urlencoded");
            ArrayList<RequestInfo> requests = new ArrayList<RequestInfo>();
            for (TextFragment fragment : fragments) {
                requests.add(new RequestInfo(fragment));
            }
            List<UrlEncodedFormEntity> forms = this.fragmentsToPostForms(requests);
            for (UrlEncodedFormEntity form : forms) {
                post.setEntity((HttpEntity)form);
                CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);
                try {
                    StatusLine status = response.getStatusLine();
                    if (status == null) {
                        this.logger.error("Unable to get response status code from Kantan API");
                        throw new OkapiException(String.format(CONNECTOR_ERROR, "unable to get response status code"));
                    }
                    int code = status.getStatusCode();
                    String content = this.readContent((HttpResponse)response);
                    if (content == null || content.length() == 0) {
                        this.logger.error("Unable to get response content from Kantan API. Response code {}", (Object)code);
                        throw new OkapiException(String.format(CONNECTOR_ERROR, "missing response content, status code: " + code));
                    }
                    if (code != 200) {
                        this.logger.error("Error in communication with a remote server, status code => {}, response body => {}", (Object)code, (Object)content);
                        Object e = code == 401 ? "Translation request is not authorized. Please, verify your Kantan profile name and authorization token" : "Remote server responded with " + code + " status code";
                        throw new OkapiException((String)e);
                    }
                    this.processResponse(requests, results, content);
                }
                finally {
                    if (response == null) continue;
                    response.close();
                }
            }
        }
        catch (ParseException e) {
            this.logger.error("Cannot parse json response from KantanMT", (Throwable)e);
            throw new OkapiException("Cannot parse json response from Kantan MT. " + e.getMessage(), e);
        }
        catch (IOException e) {
            this.logger.error("Error in communication with Kantan MT server", (Throwable)e);
            throw new OkapiException("Error in communication with Kantan MT server: " + e.getMessage(), e);
        }
        return results;
    }

    private void processResponse(List<RequestInfo> requests, List<List<QueryResult>> results, String content) throws ParseException {
        JSONObject object = (JSONObject)this.parser.parse(content);
        Map map = (Map)object.get((Object)"response");
        String type = (String)map.get("type");
        if (type.equals("translation")) {
            JSONObject bodyObj = (JSONObject)map.get("body");
            JSONArray translations = (JSONArray)bodyObj.get((Object)"translationData");
            for (Object translation : translations) {
                JSONObject transObj = (JSONObject)translation;
                long id = (Long)transObj.get((Object)"id");
                if (id >= (long)requests.size() || id < 0L) {
                    String m = "source fragment for translation with id '" + id + "' was not found";
                    this.logger.error(m);
                    throw new OkapiException(m);
                }
                RequestInfo request = requests.get((int)id);
                ArrayList<QueryResult> qrList = new ArrayList<QueryResult>();
                this.result = new QueryResult();
                this.result.weight = this.getWeight();
                this.result.origin = this.getName();
                this.result.source = request.originalFragment;
                this.result.matchType = MatchType.MT;
                this.result.setFuzzyScore(95);
                if (!request.originalFragment.hasText(false)) {
                    this.result.target = request.originalFragment.clone();
                } else {
                    String translatedText = (String)transObj.get((Object)"trg");
                    translatedText = translatedText.replaceAll("&amp;", "&");
                    this.result.target = request.generateResult(translatedText);
                }
                qrList.add(this.result);
                results.add(qrList);
            }
        } else {
            if (type.equals("status")) {
                JSONObject bodyObj = (JSONObject)map.get("body");
                String state = (String)bodyObj.get((Object)"state");
                String m = String.format(CONNECTOR_ERROR, "server is in '" + state + "' state");
                throw new OkapiException(m);
            }
            String m = String.format("Server returned JSON response with unprocessible type value '%s'", type);
            this.logger.error(m);
            throw new OkapiException(m);
        }
    }

    private List<UrlEncodedFormEntity> fragmentsToPostForms(List<RequestInfo> requests) {
        ArrayList<UrlEncodedFormEntity> forms = new ArrayList<UrlEncodedFormEntity>();
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        pairs.add(new BasicNameValuePair("auth", this.parameters.getApiToken()));
        if (!Util.isEmpty(this.parameters.getEngine())) {
            pairs.add(new BasicNameValuePair("engine", this.parameters.getEngine()));
        } else {
            pairs.add(new BasicNameValuePair("alias", this.parameters.getAlias()));
            pairs.add(new BasicNameValuePair("src", this.srcCode));
            pairs.add(new BasicNameValuePair("trg", this.trgCode));
        }
        for (int i = 0; i < requests.size(); ++i) {
            RequestInfo request = requests.get(i);
            if (!request.originalFragment.hasText(false)) continue;
            String text = request.preparedText.replaceAll("&", "%26");
            if (pairs.size() >= 900) {
                forms.add(new UrlEncodedFormEntity(pairs, Consts.UTF_8));
                pairs = new ArrayList();
                pairs.add(new BasicNameValuePair("auth", this.parameters.getApiToken()));
            }
            pairs.add(new BasicNameValuePair(Integer.toString(i), text));
        }
        forms.add(new UrlEncodedFormEntity(pairs, Consts.UTF_8));
        return forms;
    }

    private String readContent(HttpResponse response) throws IOException {
        String body = null;
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return "";
        }
        try (InputStream stream = entity.getContent();){
            BufferedReader br = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            body = br.readLine();
        }
        EntityUtils.consume((HttpEntity)entity);
        return body;
    }

    public String getEngines() {
        String string;
        block8: {
            HttpGet httpget = new HttpGet("https://app.kantanmt.com/api/query/" + this.parameters.getApiToken() + "/engines");
            CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)httpget);
            try {
                String json;
                string = json = this.readContent((HttpResponse)resp);
                if (resp == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resp != null) {
                        try {
                            resp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error getting the engines: " + e.getMessage(), e);
                }
            }
            resp.close();
        }
        return string;
    }

    public String getEngineStatus(String engine) {
        String string;
        block8: {
            HttpGet httpget = new HttpGet("https://app.kantanmt.com/api/query/" + this.parameters.getApiToken() + "/status/" + engine);
            CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)httpget);
            try {
                String json = this.readContent((HttpResponse)resp);
                string = this.processGetEngineStatusResponse(json);
                if (resp == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resp != null) {
                        try {
                            resp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error getting engine status: " + e.getMessage(), e);
                }
            }
            resp.close();
        }
        return string;
    }

    public String startEngine(String engine) {
        String string;
        block8: {
            HttpGet httpget = new HttpGet("https://app.kantanmt.com/api/init/" + this.parameters.getApiToken() + "/" + engine);
            CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)httpget);
            try {
                String json = this.readContent((HttpResponse)resp);
                string = this.processStartEngineResponse(json);
                if (resp == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resp != null) {
                        try {
                            resp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error starting engine: " + e.getMessage(), e);
                }
            }
            resp.close();
        }
        return string;
    }

    public String stopEngine(String engine) {
        String string;
        block8: {
            HttpGet httpget = new HttpGet("https://app.kantanmt.com/api/shutdown/" + this.parameters.getApiToken() + "/" + engine);
            CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)httpget);
            try {
                String json = this.readContent((HttpResponse)resp);
                string = this.processStopEngineResponse(json);
                if (resp == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resp != null) {
                        try {
                            resp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error stopping engine: " + e.getMessage(), e);
                }
            }
            resp.close();
        }
        return string;
    }

    private String processGetEngineStatusResponse(String content) throws ParseException {
        JSONObject object = (JSONObject)this.parser.parse(content);
        Map map = (Map)object.get((Object)"response");
        String type = (String)map.get("type");
        JSONObject bodyObj = (JSONObject)map.get("body");
        if (type.equals("status")) {
            return (String)bodyObj.get((Object)"state");
        }
        String m = String.format("Server returned JSON response with unprocessible type value '%s'", type);
        this.logger.error(m);
        throw new OkapiException(m);
    }

    private String processStartEngineResponse(String content) throws ParseException {
        JSONObject object = (JSONObject)this.parser.parse(content);
        Map map = (Map)object.get((Object)"response");
        String type = (String)map.get("type");
        JSONObject bodyObj = (JSONObject)map.get("body");
        if (type.equals("status")) {
            return (String)bodyObj.get((Object)"state");
        }
        if (type.equals("error")) {
            throw new OkapiException("Error starting engine: " + bodyObj.toString());
        }
        String m = String.format("Server returned JSON response with unprocessible type value '%s'", type);
        this.logger.error(m);
        throw new OkapiException(m);
    }

    private String processStopEngineResponse(String content) throws ParseException {
        JSONObject object = (JSONObject)this.parser.parse(content);
        Map map = (Map)object.get((Object)"response");
        String type = (String)map.get("type");
        JSONObject bodyObj = (JSONObject)map.get("body");
        if (type.equals("status")) {
            return (String)bodyObj.get((Object)"state");
        }
        if (type.equals("error")) {
            throw new OkapiException("Error starting engine: " + (String)bodyObj.get((Object)"error"));
        }
        String m = String.format("Server returned JSON response with unprocessible type value '%s'", type);
        this.logger.error(m);
        throw new OkapiException(m);
    }

    protected static class RequestInfo {
        private TextFragment originalFragment;
        private String preparedText;

        RequestInfo(TextFragment fragment) {
            this.originalFragment = fragment;
            this.preparedText = GenericContent.fromFragmentToLetterCoded(this.originalFragment, true);
        }

        String getPreparedText() {
            return this.preparedText;
        }

        TextFragment generateResult(String translated) {
            return GenericContent.fromLetterCodedToFragment(translated, this.originalFragment.clone(), true, true);
        }
    }
}

