/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.ttxsplitter;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stream.StreamSource;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.steps.ttxsplitter.TTXJoinerParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TTXJoiner {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private TTXJoinerParameters params;
    private XMLInputFactory inpFact;
    private XMLOutputFactory outFact;
    private XMLEventFactory evtFact;
    private XMLEventWriter writer;
    private XMLEventReader reader;
    private int outputState;
    private String outputPath;
    private ArrayList<XMLEvent> endEvents;

    public TTXJoiner(TTXJoinerParameters params) {
        this.params = params;
    }

    public void process(List<URI> inputList) {
        try {
            this.inpFact = XMLInputFactory.newInstance();
            this.inpFact.setProperty("javax.xml.stream.isCoalescing", true);
            this.inpFact.setProperty("javax.xml.stream.supportDTD", false);
            this.outFact = XMLOutputFactory.newInstance();
            this.evtFact = XMLEventFactory.newInstance();
            this.endEvents = new ArrayList();
            this.endEvents.add(this.evtFact.createEndElement(new QName("", "Raw"), null));
            this.endEvents.add(this.evtFact.createEndElement(new QName("", "Body"), null));
            this.endEvents.add(this.evtFact.createEndElement(new QName("", "TRADOStag"), null));
            Collections.sort(inputList);
            this.outputState = -1;
            this.outputPath = "";
            for (URI uri : inputList) {
                this.processFile(uri);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new OkapiException("Error while joining files:\n" + e.getLocalizedMessage());
        }
        finally {
            try {
                this.outputState = 2;
                this.closeOutput();
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(URI uri) throws XMLStreamException, IOException {
        try {
            String path = new File(uri).getAbsolutePath();
            String fname = Util.getFilename(path, false);
            int p = fname.lastIndexOf(95);
            if (p == -1) {
                this.logger.warn("File {} will be ignored: No '_' for the part marker.", (Object)fname);
                return;
            }
            String marker = fname.substring(p);
            if (!marker.startsWith("_part")) {
                this.logger.warn("File {} will be ignored: No part marker.", (Object)fname);
                return;
            }
            if (marker.length() != 8) {
                this.logger.warn("File {} will be ignored: Invalid part marker.", (Object)fname);
                return;
            }
            fname = fname.substring(0, p);
            String newPath = Util.getDirectoryName(path) + File.separatorChar + fname + this.params.getSuffix() + Util.getExtension(path);
            if (!newPath.equals(this.outputPath)) {
                if (this.outputState > -1) {
                    this.outputState = 2;
                }
                this.closeOutput();
                this.outputPath = newPath;
                this.startOutput(this.outputPath);
            }
            StreamSource source = new StreamSource(new BufferedInputStream(uri.toURL().openStream()));
            this.reader = this.inpFact.createXMLEventReader(source);
            boolean beforeRaw = true;
            boolean done = false;
            block10: while (this.reader.hasNext() && !done) {
                XMLEvent event = this.reader.nextEvent();
                switch (event.getEventType()) {
                    case 1: {
                        String name = event.asStartElement().getName().getLocalPart();
                        if (!name.equals("Raw")) break;
                        if (this.outputState == 0) {
                            this.writer.add(event);
                        }
                        beforeRaw = false;
                        continue block10;
                    }
                    case 2: {
                        String name = event.asEndElement().getName().getLocalPart();
                        if (!name.equals("Raw")) break;
                        done = true;
                        continue block10;
                    }
                }
                if (this.outputState == 1 && beforeRaw) continue;
                this.writer.add(event);
            }
            if (this.outputState == 0) {
                this.outputState = 1;
            }
        }
        finally {
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    private void closeOutput() throws XMLStreamException {
        if (this.writer != null) {
            if (this.outputState == 2) {
                for (XMLEvent event : this.endEvents) {
                    this.writer.add(event);
                }
            }
            this.writer.close();
            this.writer = null;
        }
    }

    private void startOutput(String outputPath) throws XMLStreamException, IOException {
        if (this.outputState == -1) {
            this.outputState = 0;
        } else if (this.outputState == 0) {
            this.outputState = 1;
        }
        FileOutputStream fos = new FileOutputStream(outputPath);
        this.writer = this.outFact.createXMLEventWriter(fos, "UTF-8");
    }
}

