/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.termextraction;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.ReferenceParameter;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.PathInputPart;
import net.sf.okapi.common.uidescription.SpinInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String OUTPUTPATH = "outputPath";
    private static final String AUTOOPEN = "autoOpen";
    private static final String MINWORDSPERTERM = "minWordsPerTerm";
    private static final String MAXWORDSPERTERM = "maxWordsPerTerm";
    private static final String MINOCCURRENCES = "minOccurrences";
    private static final String STOPWORDSPATH = "stopWordsPath";
    private static final String NOTSTARTWORDSPATH = "notStartWordsPath";
    private static final String NOTENDWORDSPATH = "notEndWordsPath";
    private static final String KEEPCASE = "keepCase";
    private static final String REMOVESUBTERMS = "removeSubTerms";
    private static final String SORTBYOCCURRENCE = "sortByOccurrence";
    private static final String USETERMINOLOGYANNOTATIONS = "useTerminologyAnnotations";
    private static final String USETEXTANALYSISANNOTATIONS = "useTextAnalysisAnnotations";
    private static final String USESTATISTICS = "useStatistics";

    public String getOutputPath() {
        return this.getString(OUTPUTPATH);
    }

    public void setOutputPath(String outputPath) {
        this.setString(OUTPUTPATH, outputPath);
    }

    public int getMinWordsPerTerm() {
        return this.getInteger(MINWORDSPERTERM);
    }

    public void setMinWordsPerTerm(int minWordsPerTerm) {
        this.setInteger(MINWORDSPERTERM, minWordsPerTerm);
    }

    public int getMaxWordsPerTerm() {
        return this.getInteger(MAXWORDSPERTERM);
    }

    public void setMaxWordsPerTerm(int maxWordsPerTerm) {
        this.setInteger(MAXWORDSPERTERM, maxWordsPerTerm);
    }

    public int getMinOccurrences() {
        return this.getInteger(MINOCCURRENCES);
    }

    public void setMinOccurrences(int minOccurrences) {
        this.setInteger(MINOCCURRENCES, minOccurrences);
    }

    @ReferenceParameter
    public String getStopWordsPath() {
        return this.getString(STOPWORDSPATH);
    }

    public void setStopWordsPath(String stopWordsPath) {
        this.setString(STOPWORDSPATH, stopWordsPath);
    }

    @ReferenceParameter
    public String getNotStartWordsPath() {
        return this.getString(NOTSTARTWORDSPATH);
    }

    public void setNotStartWordsPath(String notStartWordsPath) {
        this.setString(NOTSTARTWORDSPATH, notStartWordsPath);
    }

    @ReferenceParameter
    public String getNotEndWordsPath() {
        return this.getString(NOTENDWORDSPATH);
    }

    public void setNotEndWordsPath(String notEndWordsPath) {
        this.setString(NOTENDWORDSPATH, notEndWordsPath);
    }

    public boolean getKeepCase() {
        return this.getBoolean(KEEPCASE);
    }

    public void setKeepCase(boolean keepCase) {
        this.setBoolean(KEEPCASE, keepCase);
    }

    public boolean getRemoveSubTerms() {
        return this.getBoolean(REMOVESUBTERMS);
    }

    public void setRemoveSubTerms(boolean removeSubTerms) {
        this.setBoolean(REMOVESUBTERMS, removeSubTerms);
    }

    public boolean getSortByOccurrence() {
        return this.getBoolean(SORTBYOCCURRENCE);
    }

    public void setSortByOccurrence(boolean sortByOccurrence) {
        this.setBoolean(SORTBYOCCURRENCE, sortByOccurrence);
    }

    public boolean getAutoOpen() {
        return this.getBoolean(AUTOOPEN);
    }

    public void setAutoOpen(boolean autoOpen) {
        this.setBoolean(AUTOOPEN, autoOpen);
    }

    public boolean getUseTextAnalysisAnnotations() {
        return this.getBoolean(USETEXTANALYSISANNOTATIONS);
    }

    public void setUseTextAnalysisAnnotations(boolean useTextAnalysisAnnotations) {
        this.setBoolean(USETEXTANALYSISANNOTATIONS, useTextAnalysisAnnotations);
    }

    public boolean getUseTerminologyAnnotations() {
        return this.getBoolean(USETERMINOLOGYANNOTATIONS);
    }

    public void setUseTerminologyAnnotations(boolean useTerminologyAnnotations) {
        this.setBoolean(USETERMINOLOGYANNOTATIONS, useTerminologyAnnotations);
    }

    public boolean getUseStatistics() {
        return this.getBoolean(USESTATISTICS);
    }

    public void setUseStatistics(boolean useStatistics) {
        this.setBoolean(USESTATISTICS, useStatistics);
    }

    @Override
    public void reset() {
        super.reset();
        this.setOutputPath("${rootDir}/terms.txt");
        this.setAutoOpen(false);
        this.setMinWordsPerTerm(1);
        this.setMaxWordsPerTerm(3);
        this.setMinOccurrences(2);
        this.setStopWordsPath("");
        this.setNotStartWordsPath("");
        this.setNotEndWordsPath("");
        this.setKeepCase(false);
        this.setRemoveSubTerms(false);
        this.setSortByOccurrence(false);
        this.setUseTerminologyAnnotations(true);
        this.setUseTextAnalysisAnnotations(true);
        this.setUseStatistics(true);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(OUTPUTPATH, "Output path", "Full path of the output file");
        desc.add(MINWORDSPERTERM, "Minimum number of words per term", "A term will be made up at least of that many words");
        desc.add(MAXWORDSPERTERM, "Maximum number of words per term", "A term will be made up at the most of that many words");
        desc.add(MINOCCURRENCES, "Minimum number of occurrences per term", "A term will have at least that many occurrences");
        desc.add(STOPWORDSPATH, "Path of the file with stop words (leave empty for default)", "Full path of the file containing stop words");
        desc.add(NOTSTARTWORDSPATH, "Path of the file with not-start words (leave empty for default)", "Full path of the file containing not-start words");
        desc.add(NOTENDWORDSPATH, "Path of the file with not-end words (leave empty for default)", "Full path of the file containing not-end words");
        desc.add(KEEPCASE, "Preserve case differences", null);
        desc.add(REMOVESUBTERMS, "Remove entries that seem to be sub-strings of longer entries", null);
        desc.add(SORTBYOCCURRENCE, "Sort the results by the number of occurrences", null);
        desc.add(SORTBYOCCURRENCE, "Sort the results by the number of occurrences", null);
        desc.add(AUTOOPEN, "Open the result file after completion", null);
        desc.add(USETERMINOLOGYANNOTATIONS, "Use Terminology annotations", null);
        desc.add(USETEXTANALYSISANNOTATIONS, "Use Text Analysis annotations", null);
        desc.add(USESTATISTICS, "Use tokens-grouping statistics", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Term Extraction", true, false);
        PathInputPart pip = desc.addPathInputPart(paramsDesc.get(OUTPUTPATH), "Output File to Generate", true);
        pip.setBrowseFilters("Text Files (*.txt)\tAll Files (*.*)", "*.txt\t*.*");
        desc.addCheckboxPart(paramsDesc.get(AUTOOPEN));
        desc.addCheckboxPart(paramsDesc.get(SORTBYOCCURRENCE));
        desc.addSeparatorPart();
        desc.addCheckboxPart(paramsDesc.get(USETERMINOLOGYANNOTATIONS));
        desc.addCheckboxPart(paramsDesc.get(USETEXTANALYSISANNOTATIONS));
        CheckboxPart cbpUseStats = desc.addCheckboxPart(paramsDesc.get(USESTATISTICS));
        SpinInputPart sip = desc.addSpinInputPart(paramsDesc.get(MINWORDSPERTERM));
        sip.setRange(1, 999);
        sip.setVertical(false);
        sip.setMasterPart(cbpUseStats, true);
        sip = desc.addSpinInputPart(paramsDesc.get(MAXWORDSPERTERM));
        sip.setRange(1, 999);
        sip.setVertical(false);
        sip.setMasterPart(cbpUseStats, true);
        sip = desc.addSpinInputPart(paramsDesc.get(MINOCCURRENCES));
        sip.setRange(1, 999);
        sip.setVertical(false);
        sip.setMasterPart(cbpUseStats, true);
        CheckboxPart cbp = desc.addCheckboxPart(paramsDesc.get(KEEPCASE));
        cbp.setMasterPart(cbpUseStats, true);
        cbp = desc.addCheckboxPart(paramsDesc.get(REMOVESUBTERMS));
        cbp.setMasterPart(cbpUseStats, true);
        pip = desc.addPathInputPart(paramsDesc.get(STOPWORDSPATH), "Stop Words File", false);
        pip.setBrowseFilters("Text Files (*.txt)\tAll Files (*.*)", "*.txt\t*.*");
        pip.setAllowEmpty(true);
        pip.setMasterPart(cbpUseStats, true);
        pip = desc.addPathInputPart(paramsDesc.get(NOTSTARTWORDSPATH), "Not-Start Words File", false);
        pip.setBrowseFilters("Text Files (*.txt)\tAll Files (*.*)", "*.txt\t*.*");
        pip.setAllowEmpty(true);
        pip.setMasterPart(cbpUseStats, true);
        pip = desc.addPathInputPart(paramsDesc.get(NOTENDWORDSPATH), "Not-End Words File", false);
        pip.setBrowseFilters("Text Files (*.txt)\tAll Files (*.*)", "*.txt\t*.*");
        pip.setAllowEmpty(true);
        pip.setMasterPart(cbpUseStats, true);
        return desc;
    }
}

