/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.creation;

import java.io.File;
import java.net.URI;
import java.util.UUID;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.ExecutionContext;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IUserPrompt;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.ZipUtil;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.steps.rainbowkit.common.IMergeable;
import net.sf.okapi.steps.rainbowkit.common.IPackageWriter;
import net.sf.okapi.steps.rainbowkit.creation.Parameters;
import net.sf.okapi.steps.rainbowkit.xliff.XLIFF2Options;
import net.sf.okapi.steps.rainbowkit.xliff.XLIFF2PackageWriter;

@UsingParameters(value=Parameters.class)
public class ExtractionStep
extends BasePipelineStep {
    private IPackageWriter writer;
    private Parameters params = new Parameters();
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private URI inputURI;
    private URI outputURI;
    private String outputEncoding;
    private String filterConfigId;
    private String rootDir;
    private String inputRootDir;
    private String outputRootDir;
    private String resolvedOutputDir;
    private String tempPackageRoot;
    private boolean createTipp;
    private ExecutionContext context;
    private boolean didMerge;

    @Override
    public String getDescription() {
        return "Generates a Rainbow translation kit for a batch of input documents. Expects: filter events. Sends back: filter events or raw document";
    }

    @Override
    public String getName() {
        return "Rainbow Translation Kit Creation";
    }

    @Override
    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.srcLoc = sourceLocale;
    }

    @Override
    public LocaleId getSourceLocale() {
        return this.srcLoc;
    }

    @Override
    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.trgLoc = targetLocale;
    }

    @Override
    public LocaleId getTargetLocale() {
        return this.trgLoc;
    }

    @StepParameterMapping(parameterType=StepParameterType.INPUT_URI)
    public void setInputURI(URI inputURI) {
        this.inputURI = inputURI;
    }

    public URI getInputURI() {
        return this.inputURI;
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    public URI getOutputURI() {
        return this.outputURI;
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_ENCODING)
    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_ID)
    public void setFilterConfigurationId(String filterConfigId) {
        this.filterConfigId = filterConfigId;
    }

    public String getFilterConfigurationId() {
        return this.filterConfigId;
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.INPUT_ROOT_DIRECTORY)
    public void setInputRootDirectory(String inputRootDir) {
        this.inputRootDir = inputRootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_DIRECTORY)
    public void setOutputRootDirectory(String outputRootDir) {
        this.outputRootDir = outputRootDir;
    }

    public String getInputRootDirectory() {
        return this.inputRootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.EXECUTION_CONTEXT)
    public void setContext(ExecutionContext context) {
        this.context = context;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_BATCH: {
                return this.handleStartBatch(event);
            }
            case END_BATCH: {
                return this.handleEndBatch(event);
            }
            case START_DOCUMENT: {
                return this.handleStartDocument(event);
            }
            case RAW_DOCUMENT: {
                return this.handleRawDocument(event);
            }
        }
        return this.writer.handleEvent(event);
    }

    @Override
    protected Event handleStartBatch(Event event) {
        try {
            String writerClass = this.params.getWriterClass();
            this.writer = (IPackageWriter)Class.forName(writerClass).newInstance();
            this.writer.setParameters(this.params);
            this.createTipp = false;
            if (this.writer instanceof XLIFF2PackageWriter) {
                XLIFF2Options opt = new XLIFF2Options();
                if (!Util.isEmpty(this.params.getWriterOptions())) {
                    opt.fromString(this.params.getWriterOptions());
                    this.createTipp = opt.getCreateTipPackage();
                }
            }
            this.resolvedOutputDir = this.params.getPackageDirectory() + File.separator + this.params.getPackageName();
            this.resolvedOutputDir = Util.fillRootDirectoryVariable(this.resolvedOutputDir, this.rootDir);
            this.resolvedOutputDir = Util.fillInputRootDirectoryVariable(this.resolvedOutputDir, this.inputRootDir);
            this.resolvedOutputDir = LocaleId.replaceVariables(this.resolvedOutputDir, this.srcLoc, this.trgLoc);
            this.didMerge = false;
            if (new File(this.resolvedOutputDir).isDirectory()) {
                if (this.shouldMerge()) {
                    ((IMergeable)((Object)this.writer)).prepareForMerge(this.resolvedOutputDir);
                    this.didMerge = true;
                } else {
                    Util.deleteDirectory(this.resolvedOutputDir, false);
                }
            }
            String packageId = UUID.randomUUID().toString();
            String projectId = Util.makeId(this.params.getPackageName() + this.srcLoc.toString() + this.trgLoc.toString());
            this.tempPackageRoot = this.resolvedOutputDir;
            if (this.params.getCreateZip() || this.createTipp) {
                File sysTempDir = new File(System.getProperty("java.io.tmpdir"));
                String dirName = UUID.randomUUID().toString();
                File newTempDir = new File(sysTempDir, dirName);
                newTempDir.mkdirs();
                this.tempPackageRoot = newTempDir.getAbsolutePath();
            }
            this.writer.setBatchInformation(this.resolvedOutputDir, this.srcLoc, this.trgLoc, this.inputRootDir, this.rootDir, packageId, projectId, this.params.getWriterOptions(), this.tempPackageRoot);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new OkapiException("Error creating writer class.", e);
        }
        return this.writer.handleEvent(event);
    }

    @Override
    protected Event handleEndBatch(Event event) {
        event = this.writer.handleEvent(event);
        this.writer.close();
        if (this.didMerge) {
            ((IMergeable)((Object)this.writer)).doPostMerge();
        }
        this.writer = null;
        if (this.createTipp) {
            ZipUtil.zipFiles(this.resolvedOutputDir + ".tipp", this.tempPackageRoot, "manifest.xml", "pobjects.zip");
            Util.deleteDirectory(this.tempPackageRoot, false);
        } else if (this.params.getCreateZip()) {
            ZipUtil.zipDirectory(this.tempPackageRoot, ".rkp", this.resolvedOutputDir);
            Util.deleteDirectory(this.tempPackageRoot, false);
        }
        return event;
    }

    @Override
    protected Event handleRawDocument(Event event) {
        String relativeInput;
        RawDocument rd = event.getRawDocument();
        String tmpIn = rd.getInputURI().getPath();
        String relativeOutput = relativeInput = tmpIn.substring(this.inputRootDir.length() + 1);
        this.writer.setDocumentInformation(relativeInput, "", "", "", relativeOutput, "", null);
        return this.writer.handleEvent(event);
    }

    @Override
    protected Event handleStartDocument(Event event) {
        StartDocument sd = event.getStartDocument();
        IParameters prm = sd.getFilterParameters();
        String paramsData = null;
        if (prm != null) {
            paramsData = prm.toString();
        }
        String relativeInput = new File(this.inputRootDir).toURI().relativize(this.inputURI).getPath();
        String relativeOutput = new File(this.outputRootDir).toURI().relativize(this.outputURI).getPath();
        this.writer.setDocumentInformation(relativeInput, this.filterConfigId, paramsData, sd.getEncoding(), relativeOutput, this.outputEncoding, sd.getFilterWriter().getSkeletonWriter());
        return this.writer.handleEvent(event);
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    protected IPackageWriter getPackageWriter() {
        return this.writer;
    }

    private boolean shouldMerge() {
        if (this.context == null || this.context.getIsNoPrompt()) {
            return false;
        }
        if (this.writer instanceof IMergeable) {
            return this.promptShouldMerge();
        }
        return !this.promptShouldOverwrite();
    }

    private boolean promptShouldMerge() {
        String message = "A directory already exists at the target location. Would you like to merge the new translation kit with the existing directory? Select \"No\" to overwrite the existing directory.";
        return this.getPrompt().promptYesNoCancel(message);
    }

    private boolean promptShouldOverwrite() {
        String message = "A directory already exists at the target location.\nSelect \"OK\" to overwrite it.";
        return this.getPrompt().promptOKCancel(message);
    }

    private IUserPrompt getPrompt() {
        String promptClass = this.context.getIsGui() ? "net.sf.okapi.common.ui.UserPrompt" : "net.sf.okapi.common.UserPrompt";
        try {
            IUserPrompt p = (IUserPrompt)Class.forName(promptClass).newInstance();
            p.initialize(this.context.getUiParent(), this.context.getApplicationName());
            return p;
        }
        catch (Throwable e) {
            throw new InstantiationError("Could not instantiate user prompt.");
        }
    }
}

