/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.leveraging;

import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.query.IQuery;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.translation.ITMQuery;
import net.sf.okapi.lib.translation.QueryManager;
import net.sf.okapi.steps.diffleverage.DiffMatchAnnotation;
import net.sf.okapi.steps.leveraging.Parameters;

public class BatchTmLeveragingStep
extends BasePipelineStep {
    private static final int BATCH_LEVERAGE_MAX = 30;
    private final List<Event> batchedEvents;
    private int tuEventCount;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private Parameters params = new Parameters();
    private IQuery connector;
    private String rootDir;

    public BatchTmLeveragingStep() {
        this.batchedEvents = new LinkedList<Event>();
    }

    @Override
    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @Override
    public LocaleId getSourceLocale() {
        return this.sourceLocale;
    }

    @Override
    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @Override
    public LocaleId getTargetLocale() {
        return this.targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    public String getRootDirectory() {
        return this.rootDir;
    }

    @Override
    public String getName() {
        return "Simple Batch Leveraging Step (Beta)";
    }

    @Override
    public String getDescription() {
        return "Simple and fast batch leveraging step that delegates to connectors";
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case TEXT_UNIT: {
                ITextUnit tu = event.getTextUnit();
                this.batchedEvents.add(event);
                if (!this.canLeverageTu(tu)) {
                    return Event.createNoopEvent();
                }
                this.handleTextUnit(event);
                break;
            }
            case START_BATCH_ITEM: {
                return this.handleStartBatchItem(event);
            }
            case END_BATCH_ITEM: {
                return this.handleEndBatchItem(event);
            }
            case START_BATCH: {
                return this.handleStartBatch(event);
            }
            case END_BATCH: {
                return this.handleEndBatch(event);
            }
            case END_DOCUMENT: {
                return this.handleEndDocument(event);
            }
            case START_DOCUMENT: {
                return this.handleStartDocument(event);
            }
            default: {
                this.batchedEvents.add(event);
            }
        }
        return Event.createNoopEvent();
    }

    @Override
    protected Event handleTextUnit(Event event) {
        ++this.tuEventCount;
        if (this.tuEventCount >= 30) {
            this.tuEventCount = 0;
            this.batchLeverage();
            MultiEvent me = new MultiEvent();
            for (Event e : this.batchedEvents) {
                me.addEvent(e);
            }
            this.batchedEvents.clear();
            return new Event(EventType.MULTI_EVENT, me);
        }
        return Event.createNoopEvent();
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.tuEventCount = 0;
        try {
            this.connector = (IQuery)Class.forName(this.params.getResourceClassName()).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new OkapiException("Error creating connector.", e);
        }
        IParameters connectorParams = this.connector.getParameters();
        if (connectorParams != null) {
            connectorParams.fromString(this.params.getResourceParameters());
        }
        this.connector.setRootDirectory(this.rootDir);
        this.connector.setParameters(connectorParams);
        this.connector.open();
        if (this.sourceLocale != null && this.targetLocale != null) {
            this.connector.setLanguages(this.sourceLocale, this.targetLocale);
        }
        if (this.connector instanceof ITMQuery) {
            ((ITMQuery)this.connector).setThreshold(this.params.getThreshold());
            ((ITMQuery)this.connector).setMaximumHits(5);
        }
        return event;
    }

    @Override
    protected Event handleEndDocument(Event event) {
        this.tuEventCount = 0;
        if (!this.batchedEvents.isEmpty()) {
            this.batchLeverage();
            MultiEvent me = new MultiEvent();
            for (Event e : this.batchedEvents) {
                me.addEvent(e);
            }
            this.batchedEvents.clear();
            me.addEvent(event);
            return new Event(EventType.MULTI_EVENT, me);
        }
        return event;
    }

    private boolean canLeverageTu(ITextUnit tu) {
        if (!tu.isTranslatable()) {
            return false;
        }
        boolean approved = false;
        Property prop = tu.getTargetProperty(this.targetLocale, "approved");
        if (prop != null && "yes".equals(prop.getValue())) {
            approved = true;
        }
        if (!tu.getSource().hasText()) {
            return false;
        }
        if (approved) {
            return false;
        }
        return !this.wasDiffLeveraged(tu);
    }

    private void batchLeverage() {
        LinkedList<ITextUnit> tus = new LinkedList<ITextUnit>();
        for (Event e : this.batchedEvents) {
            ITextUnit tu;
            if (e.getEventType() != EventType.TEXT_UNIT || !this.canLeverageTu(tu = e.getTextUnit())) continue;
            tus.add(e.getTextUnit());
        }
        if (tus.isEmpty()) {
            return;
        }
        this.connector.batchLeverage(tus);
        if (this.params.getFillTarget()) {
            for (ITextUnit tu : tus) {
                AltTranslation at;
                AltTranslationsAnnotation ata;
                TextContainer tc = tu.getTarget(this.targetLocale);
                if (tc == null) continue;
                ISegments srcSegs = tu.getSource().getSegments();
                ISegments trgSegs = tc.getSegments();
                if (this.params.getCopySourceOnNoText()) {
                    for (Object srcSeg : srcSegs) {
                        Segment trgSeg;
                        if (((Segment)srcSeg).text.hasText(false) || (trgSeg = trgSegs.get(((Segment)srcSeg).id)) == null) continue;
                        trgSeg.text = ((Segment)srcSeg).text.clone();
                    }
                }
                if (tu.getSource().hasBeenSegmented()) {
                    for (Segment srcSeg : srcSegs) {
                        TextFragment tf;
                        AltTranslation at2;
                        Segment trgSeg = trgSegs.get(srcSeg.id);
                        ata = trgSeg.getAnnotation(AltTranslationsAnnotation.class);
                        if (ata == null || (at2 = ata.getFirst()).getCombinedScore() < this.params.getFillTargetThreshold() || !QueryManager.canLeverage(srcSeg, trgSeg, this.params.getFillIfTargetIsEmpty(), this.params.getFillIfTargetIsSameAsSource())) continue;
                        trgSeg.text = tf = new TextFragment(at2.getTarget().getCodedText(), at2.getTarget().getFirstContent().getClonedCodes());
                    }
                    continue;
                }
                ata = tu.getTarget(this.targetLocale).getAnnotation(AltTranslationsAnnotation.class);
                if (ata == null || (at = ata.getFirst()).getCombinedScore() < this.params.getFillTargetThreshold() || !QueryManager.canLeverage(tu.getSource(), tc, this.params.getFillIfTargetIsEmpty(), this.params.getFillIfTargetIsSameAsSource())) continue;
                tu.setTargetContent(this.targetLocale, at.getTarget().getFirstContent());
            }
        }
    }

    private boolean wasDiffLeveraged(ITextUnit tu) {
        if (tu.getTarget(this.targetLocale) == null) {
            return false;
        }
        return tu.getTarget(this.targetLocale).getAnnotation(DiffMatchAnnotation.class) != null;
    }
}

