/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.reader;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

class AllowedModules {
    private final List<String> attributes = new ArrayList<String>();
    private final List<ElementInfo> elements = new ArrayList<ElementInfo>();

    public void addAttribute(String qString) {
        this.attributes.add(qString);
    }

    public void addElement(String qString, boolean zeroOrMore) {
        this.elements.add(new ElementInfo(qString, zeroOrMore));
    }

    public int isAllowedAttribute(QName qName) {
        return this.attributes.contains(qName.toString()) ? 0 : 2;
    }

    public int isAllowedElement(QName qName) {
        for (ElementInfo info : this.elements) {
            if (!info.qString.equals(qName.toString())) continue;
            ++info.count;
            if (info.count > 1 && !info.zeroOrMore) {
                return 3;
            }
            return 0;
        }
        return 2;
    }

    public void reset() {
        for (ElementInfo info : this.elements) {
            info.count = 0;
        }
    }

    private static class ElementInfo {
        String qString;
        boolean zeroOrMore;
        int count;

        ElementInfo(String qString, boolean zeroOrMore) {
            this.qString = qString;
            this.zeroOrMore = zeroOrMore;
        }
    }
}

