/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.terminology.simpletb;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String GLOSSARYPATH = "glossaryPath";
    private static final String SOURCELOCALE = "sourceLocale";
    private static final String TARGETLOCALE = "targetLocale";

    public String getGlossaryPath() {
        return this.getString(GLOSSARYPATH);
    }

    public void setGlossaryPath(String glossaryPath) {
        this.setString(GLOSSARYPATH, glossaryPath);
    }

    public LocaleId getSourceLocale() {
        return LocaleId.fromString(this.getString(SOURCELOCALE));
    }

    public void setSourceLocale(LocaleId locId) {
        this.setString(SOURCELOCALE, locId.toString());
    }

    public LocaleId getTargetLocale() {
        return LocaleId.fromString(this.getString(TARGETLOCALE));
    }

    public void setTargetLocale(LocaleId locId) {
        this.setString(TARGETLOCALE, locId.toString());
    }

    @Override
    public void reset() {
        super.reset();
        this.setGlossaryPath("");
        this.setSourceLocale(LocaleId.ENGLISH);
        this.setTargetLocale(LocaleId.FRENCH);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(GLOSSARYPATH, "TBX document", "Full path of the TBX document");
        desc.add(SOURCELOCALE, "Source locale", "Locale identifier for the source");
        desc.add(TARGETLOCALE, "Target locale", "Locale identifier for the target");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("SimpleTB Connector Settings", true, false);
        desc.addPathInputPart(paramsDesc.get(GLOSSARYPATH), "TBX File", false);
        desc.addTextInputPart(paramsDesc.get(SOURCELOCALE));
        desc.addTextInputPart(paramsDesc.get(TARGETLOCALE));
        return desc;
    }
}

