/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;

public class XliffXtmFilterExtension {
    public static final String XTM_NAMESPACE_URI = "urn:xliff-xtm-extensions";
    public static final String XTM_POPULATE_TRG_WITH_SRC = "populate-target-with-source";
    public static final String SQ_XTM_ALPHANUMERIC = "x-alphanumeric";
    public static final String SQ_XTM_NUMERIC = "x-numeric";
    public static final String SQ_XTM_PUNCTUATION = "x-punctuation";
    public static final String SQ_XTM_MEASUREMENT = "x-measurement";
    public static final String SQ_XTM_MANUAL_NOTRANS = "x-manual-notrans";
    public static final String SQ_XTM_FUZZY_FORWARD = "x-fuzzy-forward";
    public static final String PROP_XTM_PERCENT = "xtm_percent";
    public static final String PROP_XTM_LOCKED = "xtm_locked";

    public static void consolidateProperties(ITextUnit tu, LocaleId trgLocId) {
        TextContainer tc = tu.getTarget(trgLocId);
        if (tc == null) {
            return;
        }
        AltTranslation bestAlt = null;
        AltTranslation bestRef = null;
        Segment trgSeg = tc.getFirstSegment();
        Property prop = tc.getProperty("state-qualifier");
        if (prop != null) {
            switch (prop.getValue()) {
                case "exact-match": 
                case "fuzzy-match": 
                case "leveraged-tm": 
                case "leveraged-inherited": 
                case "x-fuzzy-forward": {
                    AltTranslationsAnnotation ata = tc.getAnnotation(AltTranslationsAnnotation.class);
                    if (ata == null) {
                        return;
                    }
                    int bestValue = -1;
                    int bestValueRef = -1;
                    for (AltTranslation alt : ata) {
                        if ("leveraged-inherited".equals(alt.getExType()) && alt.getCombinedScore() > bestValueRef) {
                            bestValueRef = alt.getCombinedScore();
                            bestRef = alt;
                        }
                        if (alt.getCombinedScore() <= bestValue) continue;
                        bestValue = alt.getCombinedScore();
                        bestAlt = alt;
                    }
                    if (bestRef != null) {
                        trgSeg.setProperty(new Property(PROP_XTM_PERCENT, "" + bestRef.getCombinedScore()));
                        break;
                    }
                    if (bestAlt == null) break;
                    trgSeg.setProperty(new Property(PROP_XTM_PERCENT, "" + bestAlt.getCombinedScore()));
                    break;
                }
                case "x-alphanumeric": 
                case "x-numeric": 
                case "x-measurement": 
                case "x-punctuation": {
                    break;
                }
                case "x-manual-notrans": {
                    trgSeg.setProperty(new Property(PROP_XTM_LOCKED, "true"));
                }
            }
        }
        if (trgSeg.getContent().isEmpty() && !tu.getSource().getFirstSegment().getContent().isEmpty() && bestRef != null) {
            trgSeg.setProperty(new Property("repetition", bestRef.getOrigin()));
        }
    }
}

