/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.plaintext;

import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.filters.AbstractCompoundFilter;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.filters.plaintext.Parameters;
import net.sf.okapi.filters.plaintext.base.BasePlainTextFilter;
import net.sf.okapi.filters.plaintext.paragraphs.ParaPlainTextFilter;
import net.sf.okapi.filters.plaintext.regex.RegexPlainTextFilter;
import net.sf.okapi.filters.plaintext.spliced.SplicedLinesFilter;

@UsingParameters(value=Parameters.class)
public class PlainTextFilter
extends AbstractCompoundFilter {
    public static final String FILTER_NAME = "okf_plaintext";
    public static final String FILTER_MIME = "text/plain";

    public PlainTextFilter() {
        this.setName(FILTER_NAME);
        this.setDisplayName("Plain Text Filter");
        this.setMimeType(FILTER_MIME);
        this.setParameters(new Parameters(this));
        this.addSiblingFilter(BasePlainTextFilter.class);
        this.addSiblingFilter(ParaPlainTextFilter.class);
        this.addSiblingFilter(SplicedLinesFilter.class);
        this.addSiblingFilter(RegexPlainTextFilter.class);
        this.removeConfiguration("okf_plaintext_spliced");
        this.removeConfiguration("okf_plaintext_paragraphs_lines");
        this.removeConfiguration("okf_plaintext_regex");
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        IFilter filter = this.getActiveSiblingFilter();
        if (filter != null) {
            filter.setFilterConfigurationMapper(fcMapper);
        }
    }
}

