/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.pdf;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.core.simplifierrules.ParseException;
import net.sf.okapi.core.simplifierrules.SimplifierRules;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider,
ISimplifierRulesParameters {
    public static final String USECODEFINDER = "useCodeFinder";
    public static final String INDENT_THRESHOLD = "indentThreshold";
    public static final String SPACING_TOLERANCE = "spacingTolerance";
    public static final String PRESERVE_WHITESPACE = "preserveWhitespace";
    public static final String LINE_SEPARATOR = "lineSeparator";
    public static final String PARAGRAPH_SEPARATOR = "paragraphSeparator";
    public InlineCodeFinder codeFinder;

    public boolean getUseCodeFinder() {
        return this.getBoolean(USECODEFINDER);
    }

    public void setUseCodeFinder(boolean useCodeFinder) {
        this.setBoolean(USECODEFINDER, useCodeFinder);
    }

    public void setIndentThreshold(String value) {
        this.setString(INDENT_THRESHOLD, value);
    }

    public String getIndentThreshold() {
        return this.getString(INDENT_THRESHOLD);
    }

    public void setSpacingTolerance(String value) {
        this.setString(SPACING_TOLERANCE, value);
    }

    public String getSpacingTolerance() {
        return this.getString(SPACING_TOLERANCE);
    }

    public void setPreserveWhitespace(boolean preserve) {
        this.setBoolean(PRESERVE_WHITESPACE, preserve);
    }

    public boolean getPreserveWhitespace() {
        return this.getBoolean(PRESERVE_WHITESPACE);
    }

    public String getLineSeparator() {
        return this.getString(LINE_SEPARATOR);
    }

    public void setLineSeparator(String value) {
        this.setString(LINE_SEPARATOR, value);
    }

    public String getParagraphSeparator() {
        return this.getString(PARAGRAPH_SEPARATOR);
    }

    public void setParagraphSeparator(String value) {
        this.setString(PARAGRAPH_SEPARATOR, value);
    }

    @Override
    public void reset() {
        super.reset();
        this.codeFinder = new InlineCodeFinder();
        this.setUseCodeFinder(true);
        this.setIndentThreshold("2.0");
        this.setSpacingTolerance("0.5");
        this.setLineSeparator("\n");
        this.setParagraphSeparator("\n");
        this.setPreserveWhitespace(false);
        this.codeFinder.setSample("&name; <tag></at><tag/> <tag attr='val'> </tag=\"val\">");
        this.codeFinder.setUseAllRulesWhenTesting(true);
        this.codeFinder.addRule("</?([A-Z0-9a-z]*)\\b[^>]*>");
        this.setSimplifierRules(null);
    }

    @Override
    public String toString() {
        super.toString();
        this.buffer.setGroup("codeFinderRules", this.codeFinder.toString());
        return this.buffer.toString();
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        this.codeFinder.fromString(this.buffer.getGroup("codeFinderRules", ""));
    }

    @Override
    public String getSimplifierRules() {
        return this.getString("simplifierRules");
    }

    @Override
    public void setSimplifierRules(String rules) {
        this.setString("simplifierRules", rules);
    }

    @Override
    public void validateSimplifierRules() throws ParseException {
        SimplifierRules r = new SimplifierRules(this.getSimplifierRules(), new Code());
        r.parse();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(LINE_SEPARATOR, "Character to use as line separator", null);
        desc.add(PARAGRAPH_SEPARATOR, "Character to use as paragraph separator", null);
        desc.add(INDENT_THRESHOLD, "Amount of indent needed to define a new paragraph (Default=2.0)", null);
        desc.add(SPACING_TOLERANCE, "Amount of spacing needed to define a white space character (Default=0.5)", null);
        desc.add(PRESERVE_WHITESPACE, "Preserve whitespace", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("PDF Filter", true, false);
        desc.addTextInputPart(paramsDesc.get(LINE_SEPARATOR));
        desc.addTextInputPart(paramsDesc.get(PARAGRAPH_SEPARATOR));
        desc.addTextInputPart(paramsDesc.get(INDENT_THRESHOLD));
        desc.addTextInputPart(paramsDesc.get(SPACING_TOLERANCE));
        desc.addSeparatorPart();
        desc.addCheckboxPart(paramsDesc.get(PRESERVE_WHITESPACE));
        return desc;
    }
}

