/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.QuoteMode;
import net.sf.okapi.common.encoder.XMLEncoder;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.openxml.CellReference;
import net.sf.okapi.filters.openxml.CrossSheetCellReference;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.ExcelWorksheetTransUnitProperty;
import net.sf.okapi.filters.openxml.OpenXMLFilter;
import net.sf.okapi.filters.openxml.TranslatablePart;
import net.sf.okapi.filters.openxml.WorkbookFragments;
import net.sf.okapi.filters.openxml.XMLEventsReader;

class WorkbookPart
extends TranslatablePart {
    private static final String EMPTY = "";
    private final WorkbookFragments fragments;
    private final IdGenerator textUnitIds;
    private final XMLEncoder attributeValueEncoder;
    private String subDocumentId;
    private Iterator<Event> filterEventsIterator;

    WorkbookPart(Document.General generalDocument, ZipEntry entry, WorkbookFragments fragments) {
        super(generalDocument, entry);
        this.fragments = fragments;
        this.textUnitIds = new IdGenerator(entry.getName(), "tu");
        this.attributeValueEncoder = new XMLEncoder(OpenXMLFilter.ENCODING.name(), "\n", true, true, false, QuoteMode.ALL);
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        this.subDocumentId = this.generalDocument.nextSubDocumentId();
        this.readFilterEventsWith(new XMLEventsReader(this.fragments.events()));
        this.filterEventsIterator = this.filterEvents.iterator();
        return this.createStartSubDocumentEvent(this.generalDocument.documentId(), this.subDocumentId);
    }

    private void readFilterEventsWith(XMLEventsReader reader) {
        while (reader.hasNext()) {
            XMLEvent e = reader.nextEvent();
            if (!e.isStartElement() || !"sheet".equals(e.asStartElement().getName().getLocalPart())) {
                this.addEventToDocumentPart(e);
                continue;
            }
            String sheetName = e.asStartElement().getAttributeByName(WorkbookFragments.SHEET_NAME).getValue();
            if (this.fragments.localisedWorksheetNameHiddenFor(sheetName)) {
                this.addEventToDocumentPart(e);
                continue;
            }
            this.flushDocumentPart();
            XMLEvent ee = reader.nextEvent();
            if (!ee.isEndElement() || !ee.asEndElement().getName().equals(e.asStartElement().getName())) {
                throw new IllegalStateException("Unsupported document structure found");
            }
            CrossSheetCellReference crossSheetCellReference = new CrossSheetCellReference(sheetName, new CellReference(EMPTY));
            ITextUnit textUnit = this.textUnitFor(e.asStartElement(), crossSheetCellReference);
            this.generalDocument.dispersedTranslations().add(crossSheetCellReference, EMPTY, sheetName);
            this.filterEvents.add(new Event(EventType.TEXT_UNIT, textUnit));
        }
        this.flushDocumentPart();
        this.filterEvents.add(new Event(EventType.END_SUBDOCUMENT, new Ending(this.subDocumentId)));
    }

    private ITextUnit textUnitFor(StartElement startElement, CrossSheetCellReference crossSheetCellReference) {
        TextUnit textUnit = new TextUnit(this.textUnitIds.createId());
        textUnit.setSource(new TextContainer(new TextFragment(crossSheetCellReference.worksheetName())));
        textUnit.setMimeType("text/xml");
        GenericSkeleton skel = new GenericSkeleton();
        skel.append("<");
        skel.append(WorkbookPart.stringFor(startElement.getName()));
        Iterator<Attribute> iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            skel.append(" ");
            skel.append(WorkbookPart.stringFor(attribute.getName()));
            skel.append("=\"");
            if (attribute.getValue().equals(crossSheetCellReference.worksheetName())) {
                skel.addContentPlaceholder(textUnit);
            } else {
                skel.append(this.stringFor(attribute.getValue()));
            }
            skel.append("\"");
        }
        skel.append("/>");
        textUnit.setSkeleton(skel);
        textUnit.setProperty(new Property(ExcelWorksheetTransUnitProperty.SHEET_NAME.getKeyName(), crossSheetCellReference.worksheetName(), true));
        textUnit.setProperty(new Property(ExcelWorksheetTransUnitProperty.CELL_REFERENCE.getKeyName(), crossSheetCellReference.cellReference().toString(), true));
        return textUnit;
    }

    private static String stringFor(QName name) {
        StringBuilder sb = new StringBuilder();
        if (null != name.getPrefix() && !EMPTY.equals(name.getPrefix())) {
            sb.append(name.getPrefix()).append(":");
        }
        sb.append(name.getLocalPart());
        return sb.toString();
    }

    private String stringFor(String attributeValue) {
        return this.attributeValueEncoder.encode(attributeValue, EncoderContext.INLINE);
    }

    @Override
    public boolean hasNextEvent() {
        return this.filterEventsIterator.hasNext();
    }

    @Override
    public Event nextEvent() {
        return this.filterEventsIterator.next();
    }

    @Override
    public void close() {
    }

    @Override
    public void logEvent(Event e) {
    }
}

