/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.Part;
import net.sf.okapi.filters.openxml.XMLEventSerializer;

abstract class TranslatablePart
implements Part {
    protected final Document.General generalDocument;
    protected final ZipEntry entry;
    final List<Event> filterEvents;
    final IdGenerator documentPartIdGenerator;
    List<XMLEvent> documentPartEvents;

    TranslatablePart(Document.General generalDocument, ZipEntry entry) {
        this.generalDocument = generalDocument;
        this.entry = entry;
        this.filterEvents = new ArrayList<Event>();
        this.documentPartIdGenerator = new IdGenerator(entry.getName(), "dp");
        this.documentPartEvents = new ArrayList<XMLEvent>();
    }

    Event createStartSubDocumentEvent(String documentId, String subDocumentId) {
        StartSubDocument sd = new StartSubDocument(documentId, subDocumentId);
        sd.setName(this.entry.getName());
        if (this.generalDocument != null) {
            ZipSkeleton zs = new ZipSkeleton(this.generalDocument.zipFile(), this.entry);
            sd.setSkeleton(zs);
        }
        sd.setFilterId("okf_openxml");
        sd.setFilterParameters(this.generalDocument.conditionalParameters());
        return new Event(EventType.START_SUBDOCUMENT, sd);
    }

    void addEventToDocumentPart(XMLEvent e) {
        this.documentPartEvents.add(e);
    }

    void flushDocumentPart() {
        DocumentPart documentPart = new DocumentPart(this.documentPartIdGenerator.createId(), false, new GenericSkeleton(XMLEventSerializer.serialize(this.documentPartEvents)));
        this.filterEvents.add(new Event(EventType.DOCUMENT_PART, documentPart));
        this.documentPartEvents = new ArrayList<XMLEvent>();
    }
}

