/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.filters.openxml.ContentFilter;
import net.sf.okapi.filters.openxml.DefaultPart;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.ModifiablePart;
import net.sf.okapi.filters.openxml.Namespace;
import net.sf.okapi.filters.openxml.NonModifiablePart;
import net.sf.okapi.filters.openxml.NotesMasterFragments;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.Part;
import net.sf.okapi.filters.openxml.PresentationFragments;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.RelationshipsPart;
import net.sf.okapi.filters.openxml.SlidablePart;
import net.sf.okapi.filters.openxml.SlideFragments;
import net.sf.okapi.filters.openxml.SlideMasterFragments;
import net.sf.okapi.filters.openxml.SlideTemplateFragments;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.StyledTextPart;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import net.sf.okapi.filters.openxml.ZipEntryComparator;

class PowerpointDocument
implements Document {
    private static final String SLIDE_MASTER = "/slideMaster";
    private static final String SLIDE_LAYOUT = "/slideLayout";
    private static final String COMMENTS = "/comments";
    private static final String NOTES_SLIDE = "/notesSlide";
    private static final String NOTES_MASTER = "/notesMaster";
    private static final String CHART = "/chart";
    private static final String DIAGRAM_DATA = "/diagramData";
    private static final Pattern RELS_NAME_PATTERN = Pattern.compile(".+slide\\d+\\.xml\\.rels");
    private Matcher relsNameMatcher = RELS_NAME_PATTERN.matcher("").reset();
    private static final String SLD = "sld";
    private static final QName SHOW = new QName("show");
    private final Document.General generalDocument;
    private PresentationFragments presentationFragments;
    private Enumeration<? extends ZipEntry> entries;
    private Set<String> hiddenSlides;
    private Set<String> slideLayoutNames;
    private Set<String> notesSlideNames;
    private Map<String, SlideFragments> slideMasterFragmentsByName;
    private Map<String, SlideFragments> slideLayoutFragmentsByName;
    private Map<String, SlideFragments> slideFragmentsByName;
    private Map<String, SlideFragments> notesMasterFragmentsByName;
    private Map<String, SlideFragments> notesSlideFragmentsByName;
    private Map<String, Set<String>> slideLayoutsBySlide;
    private Map<String, Set<String>> slideMastersBySlideLayout;
    private Map<String, String> slidesByComment;
    private Map<String, String> slidesByNotesSlide;
    private Map<String, Set<String>> notesMastersByNotesSlide;
    private Map<String, String> slidesByChart;
    private Map<String, String> slidesByDiagramData;

    PowerpointDocument(Document.General generalDocument) {
        this.generalDocument = generalDocument;
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        this.presentationFragments = this.presentationFragments();
        this.entries = this.entries();
        this.hiddenSlides = this.hiddenSlides();
        this.slideLayoutNames = this.slideRelatedPartNamesOf(SLIDE_LAYOUT);
        this.notesSlideNames = this.slideRelatedPartNamesOf(NOTES_SLIDE);
        this.slideMasterFragmentsByName = this.slideMasterFragments();
        this.slideLayoutFragmentsByName = this.slideLayoutFragments();
        this.slideFragmentsByName = this.slideFragments();
        this.notesMasterFragmentsByName = this.notesMasterFragments();
        this.notesSlideFragmentsByName = this.notesSlideFragments();
        this.slideLayoutsBySlide = this.slideLayoutsBySlide();
        this.slideMastersBySlideLayout = this.slideMastersBySlideLayout();
        this.slidesByComment = this.slidesBy(COMMENTS);
        this.slidesByNotesSlide = this.slidesBy(NOTES_SLIDE);
        this.notesMastersByNotesSlide = this.notesMastersByNotesSlide();
        this.slidesByChart = this.slidesBy(CHART);
        this.slidesByDiagramData = this.slidesBy(DIAGRAM_DATA);
        return this.generalDocument.startDocumentEvent();
    }

    private PresentationFragments presentationFragments() throws IOException, XMLStreamException {
        PresentationFragments.Default pf = new PresentationFragments.Default(this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), this.generalDocument.relationshipsFor(this.generalDocument.mainPartName()));
        try (Reader reader = this.generalDocument.getPartReader(this.generalDocument.mainPartName());){
            pf.readWith(this.generalDocument.inputFactory().createXMLEventReader(reader));
        }
        return pf;
    }

    private Enumeration<? extends ZipEntry> entries() throws IOException, XMLStreamException {
        Enumeration<? extends ZipEntry> entries = this.generalDocument.entries();
        ArrayList<? extends ZipEntry> entryList = Collections.list(entries);
        entryList.sort(new ZipEntryComparator(this.reorderedPartNames()));
        return Collections.enumeration(entryList);
    }

    private List<String> reorderedPartNames() throws IOException, XMLStreamException {
        LinkedList<String> names = new LinkedList<String>();
        for (String slideName : this.presentationFragments.slideNames()) {
            names.add(slideName);
            if (!this.generalDocument.conditionalParameters().getReorderPowerpointNotesAndComments()) continue;
            String namespaceUri = this.generalDocument.documentRelationshipsNamespace().uri();
            names.addAll(this.slideRelationshipTargetsForType(slideName, namespaceUri.concat(NOTES_SLIDE)));
            names.addAll(this.slideRelationshipTargetsForType(slideName, namespaceUri.concat(COMMENTS)));
        }
        return names;
    }

    private List<String> slideRelationshipTargetsForType(String slideName, String typeUri) throws IOException, XMLStreamException {
        List<Relationships.Rel> rels = this.generalDocument.relationshipsFor(slideName).getRelByType(typeUri);
        return rels == null ? Collections.emptyList() : rels.stream().map(r -> r.target).collect(Collectors.toList());
    }

    private Set<String> hiddenSlides() throws IOException, XMLStreamException {
        HashSet<String> hiddenSlides = new HashSet<String>(this.presentationFragments.slideNames().size());
        for (String name : this.presentationFragments.slideNames()) {
            Reader reader = this.generalDocument.getPartReader(name);
            Throwable throwable = null;
            try {
                XMLEventReader eventReader = this.generalDocument.inputFactory().createXMLEventReader(reader);
                XMLEvent e = eventReader.nextTag();
                if (!e.isStartElement() || !SLD.equals(e.asStartElement().getName().getLocalPart()) || XMLEventHelpers.getBooleanAttributeValue(e.asStartElement(), SHOW, XMLEventHelpers.DEFAULT_BOOLEAN_ATTRIBUTE_TRUE_VALUE)) continue;
                hiddenSlides.add(name);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
        return hiddenSlides;
    }

    private Set<String> slideRelatedPartNamesOf(String type) throws IOException, XMLStreamException {
        HashSet<String> names = new HashSet<String>();
        String typeUri = this.generalDocument.documentRelationshipsNamespace().uri().concat(type);
        for (String slideName : this.presentationFragments.slideNames()) {
            List<Relationships.Rel> rels = this.generalDocument.relationshipsFor(slideName).getRelByType(typeUri);
            if (null == rels || rels.isEmpty()) continue;
            names.addAll(rels.stream().map(rel -> rel.target).collect(Collectors.toSet()));
        }
        return names;
    }

    private Map<String, SlideFragments> slideMasterFragments() throws IOException, XMLStreamException {
        HashMap<String, SlideFragments> slideMasterFragments = new HashMap<String, SlideFragments>(this.presentationFragments.slideMasterNames().size());
        for (String name : this.presentationFragments.slideMasterNames()) {
            slideMasterFragments.put(name, this.slideMasterFragmentsOf(name));
        }
        return slideMasterFragments;
    }

    private SlideFragments slideMasterFragmentsOf(String partName) throws IOException, XMLStreamException {
        try (Reader reader = this.generalDocument.getPartReader(partName);){
            XMLEventReader eventReader = this.generalDocument.inputFactory().createXMLEventReader(reader);
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                if (e.isEndElement() && SlideMasterFragments.SLD_MASTER.equals(e.asEndElement().getName().getLocalPart())) {
                    break;
                }
                if (!e.isStartElement()) continue;
                if (!SlideMasterFragments.SLD_MASTER.equals(e.asStartElement().getName().getLocalPart())) continue;
                SlideMasterFragments slideTemplateFragments = new SlideMasterFragments(e.asStartElement(), this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory());
                slideTemplateFragments.readWith(eventReader);
                SlideMasterFragments slideMasterFragments = slideTemplateFragments;
                return slideMasterFragments;
            }
        }
        return new SlideTemplateFragments.Empty();
    }

    private Map<String, SlideFragments> slideLayoutFragments() throws IOException, XMLStreamException {
        HashMap<String, SlideFragments> slideLayoutFragments = new HashMap<String, SlideFragments>(this.slideLayoutNames.size());
        for (String name : this.slideLayoutNames) {
            slideLayoutFragments.put(name, this.slideLayoutFragmentsOf(name));
        }
        return slideLayoutFragments;
    }

    private SlideFragments slideLayoutFragmentsOf(String partName) throws IOException, XMLStreamException {
        List<Relationships.Rel> rels = this.generalDocument.relationshipsFor(partName).getRelByType(this.generalDocument.documentRelationshipsNamespace().uri().concat(SLIDE_MASTER));
        SlideTemplateFragments.Empty slideMasterFragments = null != rels && !rels.isEmpty() && this.slideMasterFragmentsByName.containsKey(rels.get((int)0).target) ? this.slideMasterFragmentsByName.get(rels.get((int)0).target) : new SlideTemplateFragments.Empty();
        try (Reader reader = this.generalDocument.getPartReader(partName);){
            XMLEventReader eventReader = this.generalDocument.inputFactory().createXMLEventReader(reader);
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                if (e.isEndElement() && "cSld".equals(e.asEndElement().getName().getLocalPart())) {
                    break;
                }
                if (!e.isStartElement()) continue;
                if (!"cSld".equals(e.asStartElement().getName().getLocalPart())) continue;
                SlideFragments.Default slideLayoutFragments = new SlideFragments.Default(e.asStartElement(), this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), slideMasterFragments);
                slideLayoutFragments.readWith(eventReader);
                SlideFragments.Default default_ = slideLayoutFragments;
                return default_;
            }
        }
        return new SlideFragments.Empty(slideMasterFragments);
    }

    private Map<String, SlideFragments> slideFragments() throws IOException, XMLStreamException {
        HashMap<String, SlideFragments> slideFragments = new HashMap<String, SlideFragments>(this.presentationFragments.slideNames().size());
        for (String name : this.presentationFragments.slideNames()) {
            slideFragments.put(name, this.slideFragmentsOf(name));
        }
        return slideFragments;
    }

    private SlideFragments slideFragmentsOf(String partName) throws IOException, XMLStreamException {
        List<Relationships.Rel> rels = this.generalDocument.relationshipsFor(partName).getRelByType(this.generalDocument.documentRelationshipsNamespace().uri().concat(SLIDE_LAYOUT));
        SlideFragments slideLayoutFragments = null != rels && !rels.isEmpty() && this.slideLayoutFragmentsByName.containsKey(rels.get((int)0).target) ? this.slideLayoutFragmentsByName.get(rels.get((int)0).target) : new SlideFragments.Empty(new SlideTemplateFragments.Empty());
        try (Reader reader = this.generalDocument.getPartReader(partName);){
            XMLEventReader eventReader = this.generalDocument.inputFactory().createXMLEventReader(reader);
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                if (e.isEndElement() && "cSld".equals(e.asEndElement().getName().getLocalPart())) {
                    break;
                }
                if (!e.isStartElement()) continue;
                if (!"cSld".equals(e.asStartElement().getName().getLocalPart())) continue;
                SlideFragments.Default slideFragments = new SlideFragments.Default(e.asStartElement(), this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), slideLayoutFragments);
                slideFragments.readWith(eventReader);
                SlideFragments.Default default_ = slideFragments;
                return default_;
            }
        }
        return new SlideFragments.Empty(slideLayoutFragments);
    }

    private Map<String, SlideFragments> notesMasterFragments() throws IOException, XMLStreamException {
        HashMap<String, SlideFragments> notesMasterFragments = new HashMap<String, SlideFragments>(this.presentationFragments.notesMasterNames().size());
        for (String name : this.presentationFragments.notesMasterNames()) {
            notesMasterFragments.put(name, this.notesMasterFragmentsOf(name));
        }
        return notesMasterFragments;
    }

    private SlideFragments notesMasterFragmentsOf(String partName) throws IOException, XMLStreamException {
        try (Reader reader = this.generalDocument.getPartReader(partName);){
            XMLEventReader eventReader = this.generalDocument.inputFactory().createXMLEventReader(reader);
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                if (e.isEndElement() && NotesMasterFragments.NOTES_MASTER.equals(e.asEndElement().getName().getLocalPart())) {
                    break;
                }
                if (!e.isStartElement()) continue;
                if (!NotesMasterFragments.NOTES_MASTER.equals(e.asStartElement().getName().getLocalPart())) continue;
                NotesMasterFragments notesMasterFragments = new NotesMasterFragments(e.asStartElement(), this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory());
                notesMasterFragments.readWith(eventReader);
                NotesMasterFragments notesMasterFragments2 = notesMasterFragments;
                return notesMasterFragments2;
            }
        }
        return new SlideTemplateFragments.Empty();
    }

    private Map<String, SlideFragments> notesSlideFragments() throws IOException, XMLStreamException {
        HashMap<String, SlideFragments> slideFragments = new HashMap<String, SlideFragments>(this.notesSlideNames.size());
        for (String name : this.notesSlideNames) {
            slideFragments.put(name, this.notesSlideFragmentsOf(name));
        }
        return slideFragments;
    }

    private SlideFragments notesSlideFragmentsOf(String partName) throws IOException, XMLStreamException {
        List<Relationships.Rel> rels = this.generalDocument.relationshipsFor(partName).getRelByType(this.generalDocument.documentRelationshipsNamespace().uri().concat(NOTES_MASTER));
        SlideTemplateFragments.Empty notesMasterFragments = null != rels && !rels.isEmpty() && this.notesMasterFragmentsByName.containsKey(rels.get((int)0).target) ? this.notesMasterFragmentsByName.get(rels.get((int)0).target) : new SlideTemplateFragments.Empty();
        try (Reader reader = this.generalDocument.getPartReader(partName);){
            XMLEventReader eventReader = this.generalDocument.inputFactory().createXMLEventReader(reader);
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                if (e.isEndElement() && "cSld".equals(e.asEndElement().getName().getLocalPart())) {
                    break;
                }
                if (!e.isStartElement()) continue;
                if (!"cSld".equals(e.asStartElement().getName().getLocalPart())) continue;
                SlideFragments.Default slideFragments = new SlideFragments.Default(e.asStartElement(), this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), notesMasterFragments);
                slideFragments.readWith(eventReader);
                SlideFragments.Default default_ = slideFragments;
                return default_;
            }
        }
        return new SlideFragments.Empty(notesMasterFragments);
    }

    private Map<String, Set<String>> slideLayoutsBySlide() throws IOException, XMLStreamException {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        String uri = this.generalDocument.documentRelationshipsNamespace().uri().concat(SLIDE_LAYOUT);
        for (String name : this.presentationFragments.slideNames()) {
            map.put(name, this.relatedPartsFor(name, uri));
        }
        return map;
    }

    private Map<String, Set<String>> slideMastersBySlideLayout() throws IOException, XMLStreamException {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        String uri = this.generalDocument.documentRelationshipsNamespace().uri().concat(SLIDE_MASTER);
        for (String name : this.slideLayoutNames) {
            map.put(name, this.relatedPartsFor(name, uri));
        }
        return map;
    }

    private Map<String, Set<String>> notesMastersByNotesSlide() throws IOException, XMLStreamException {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        String uri = this.generalDocument.documentRelationshipsNamespace().uri().concat(NOTES_MASTER);
        for (String name : this.notesSlideNames) {
            map.put(name, this.relatedPartsFor(name, uri));
        }
        return map;
    }

    private Set<String> relatedPartsFor(String name, String uri) throws IOException, XMLStreamException {
        List<Relationships.Rel> rels = this.generalDocument.relationshipsFor(name).getRelByType(uri);
        Set<String> names = null == rels || rels.isEmpty() ? Collections.emptySet() : rels.stream().map(rel -> rel.target).collect(Collectors.toSet());
        return names;
    }

    private Map<String, String> slidesBy(String relatedPart) throws IOException, XMLStreamException {
        String namespaceUri = this.generalDocument.documentRelationshipsNamespace().uri();
        return this.generalDocument.relsByEntry(this.presentationFragments.slideNames(), namespaceUri.concat(relatedPart));
    }

    @Override
    public boolean hasNextPart() {
        return this.entries.hasMoreElements();
    }

    @Override
    public Part nextPart() throws IOException, XMLStreamException {
        ParseType parseType;
        ZipEntry entry = this.entries.nextElement();
        String contentType = this.generalDocument.contentTypeFor(entry);
        this.relsNameMatcher.reset(entry.getName());
        if (PowerpointDocument.isRelationshipsPart(contentType) && this.relsNameMatcher.matches() && this.generalDocument.conditionalParameters().getExtractExternalHyperlinks()) {
            return new RelationshipsPart(this.generalDocument, entry);
        }
        if (!this.isTranslatablePart(entry)) {
            if (PowerpointDocument.isModifiablePart(contentType)) {
                return new ModifiablePart(this.generalDocument, entry, this.generalDocument.inputStreamFor(entry));
            }
            return new NonModifiablePart(this.generalDocument, entry);
        }
        if (this.isStyledTextPart(entry)) {
            if (this.isSlidablePart(entry.getName(), contentType)) {
                return new SlidablePart(this.generalDocument, entry, this.slideFragmentsFor(entry.getName(), contentType));
            }
            StyleDefinitions.Empty styleDefinitions = new StyleDefinitions.Empty();
            StyleOptimisation styleOptimisation = this.styleOptimisationFor(entry, styleDefinitions);
            return new StyledTextPart(this.generalDocument, entry, styleDefinitions, styleOptimisation);
        }
        ContentFilter contentFilter = new ContentFilter(this.generalDocument.conditionalParameters(), entry.getName());
        this.generalDocument.conditionalParameters().nFileType = parseType = this.getParseType(contentType);
        contentFilter.setUpConfig(parseType);
        return new DefaultPart(this.generalDocument, entry, contentFilter);
    }

    private static boolean isRelationshipsPart(String contentType) {
        return "application/vnd.openxmlformats-package.relationships+xml".equals(contentType);
    }

    private StyleOptimisation styleOptimisationFor(ZipEntry entry, StyleDefinitions styleDefinitions) throws IOException, XMLStreamException {
        Namespace namespace = this.generalDocument.namespacesOf(entry).forPrefix("a");
        if (null == namespace) {
            return new StyleOptimisation.Bypass();
        }
        return new StyleOptimisation.Default(new StyleOptimisation.Bypass(), this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), new QName(namespace.uri(), "pPr", namespace.prefix()), new QName(namespace.uri(), "defRPr", namespace.prefix()), Collections.emptyList(), styleDefinitions);
    }

    private ParseType getParseType(String contentType) {
        ParseType parseType;
        if (contentType.equals("application/vnd.openxmlformats-package.core-properties+xml")) {
            parseType = ParseType.MSWORDDOCPROPERTIES;
        } else if (contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.comments+xml")) {
            parseType = ParseType.MSPOWERPOINTCOMMENTS;
        } else {
            throw new IllegalStateException("Unexpected content type " + contentType);
        }
        return parseType;
    }

    private boolean isTranslatablePart(ZipEntry entry) throws IOException, XMLStreamException {
        String type = this.generalDocument.contentTypeFor(entry);
        if (!entry.getName().endsWith(".xml")) {
            return false;
        }
        if (this.isExcluded(entry.getName(), type)) {
            return false;
        }
        if (this.isHidden(entry.getName(), type)) {
            return false;
        }
        if (this.generalDocument.conditionalParameters().getTranslateDocProperties() && type.equals("application/vnd.openxmlformats-package.core-properties+xml")) {
            return true;
        }
        if (this.generalDocument.conditionalParameters().getTranslateComments() && type.equals("application/vnd.openxmlformats-officedocument.presentationml.comments+xml")) {
            return true;
        }
        return this.isStyledTextPart(entry);
    }

    private static boolean isModifiablePart(String contentType) {
        return "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml".equals(contentType) || "application/vnd.openxmlformats-officedocument.theme+xml".equals(contentType);
    }

    @Override
    public boolean isStyledTextPart(ZipEntry entry) {
        String type = this.generalDocument.contentTypeFor(entry);
        if (type.equals("application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml")) {
            return true;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.drawingml.chart+xml")) {
            return true;
        }
        return this.isSlidablePart(entry.getName(), type);
    }

    private boolean isSlidablePart(String entryName, String type) {
        return null != this.slideFragmentsFor(entryName, type);
    }

    private SlideFragments slideFragmentsFor(String entryName, String type) {
        if (this.generalDocument.conditionalParameters().getTranslatePowerpointMasters()) {
            if ("application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml".equals(type) && this.slideMasterFragmentsByName.containsKey(entryName)) {
                return this.slideMasterFragmentsByName.get(entryName);
            }
            if ("application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml".equals(type) && this.slideLayoutFragmentsByName.containsKey(entryName)) {
                return this.slideLayoutFragmentsByName.get(entryName);
            }
        }
        if ("application/vnd.openxmlformats-officedocument.presentationml.slide+xml".equals(type) && this.slideFragmentsByName.containsKey(entryName)) {
            return this.slideFragmentsByName.get(entryName);
        }
        if (this.generalDocument.conditionalParameters().getTranslatePowerpointNotes()) {
            if (this.generalDocument.conditionalParameters().getTranslatePowerpointMasters() && "application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml".equals(type) && this.notesMasterFragmentsByName.containsKey(entryName)) {
                return this.notesMasterFragmentsByName.get(entryName);
            }
            if ("application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml".equals(type) && this.notesSlideFragmentsByName.containsKey(entryName)) {
                return this.notesSlideFragmentsByName.get(entryName);
            }
        }
        return null;
    }

    private boolean isExcluded(String entryName, String contentType) {
        if (!this.generalDocument.conditionalParameters().getPowerpointIncludedSlideNumbersOnly()) {
            return false;
        }
        switch (contentType) {
            case "application/vnd.openxmlformats-officedocument.presentationml.slide+xml": {
                return this.isExcludedSlide(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml": {
                return this.isExcludedSlideLayout(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml": {
                return this.isExcludedSlideMaster(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.comments+xml": {
                return this.isExcludedComment(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml": {
                return this.isExcludedNotesSlide(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml": {
                return this.isExcludedNotesMaster(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.drawingml.chart+xml": {
                return this.isExcludedChart(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml": {
                return this.isExcludedDiagramData(entryName);
            }
        }
        return false;
    }

    private boolean isExcludedSlide(String entryName) {
        int slideIndex = this.presentationFragments.slideNames().indexOf(entryName);
        if (slideIndex == -1) {
            return false;
        }
        int slideNumber = slideIndex + 1;
        return !this.generalDocument.conditionalParameters().tsPowerpointIncludedSlideNumbers.contains(slideNumber);
    }

    private boolean isExcludedSlideLayout(String entryName) {
        boolean excluded = false;
        for (String slideName : this.slideLayoutsBySlide.keySet()) {
            if (!this.slideLayoutsBySlide.get(slideName).contains(entryName)) continue;
            if (this.isExcludedSlide(slideName)) {
                excluded = true;
                continue;
            }
            return false;
        }
        return excluded;
    }

    private boolean isExcludedSlideMaster(String entryName) {
        boolean excluded = false;
        for (String slideLayout : this.slideMastersBySlideLayout.keySet()) {
            if (!this.slideMastersBySlideLayout.get(slideLayout).contains(entryName)) continue;
            if (this.isExcludedSlideLayout(slideLayout)) {
                excluded = true;
                continue;
            }
            return false;
        }
        return excluded;
    }

    private boolean isExcludedComment(String entryName) {
        if (!this.slidesByComment.containsKey(entryName)) {
            return false;
        }
        return this.isExcludedSlide(this.slidesByComment.get(entryName));
    }

    private boolean isExcludedNotesSlide(String entryName) {
        if (!this.slidesByNotesSlide.containsKey(entryName)) {
            return false;
        }
        return this.isExcludedSlide(this.slidesByNotesSlide.get(entryName));
    }

    private boolean isExcludedNotesMaster(String entryName) {
        boolean excluded = false;
        for (String notesSlide : this.notesMastersByNotesSlide.keySet()) {
            if (!this.notesMastersByNotesSlide.get(notesSlide).contains(entryName)) continue;
            if (this.isExcludedNotesSlide(notesSlide)) {
                excluded = true;
                continue;
            }
            return false;
        }
        return excluded;
    }

    private boolean isExcludedChart(String entryName) {
        if (!this.slidesByChart.containsKey(entryName)) {
            return false;
        }
        return this.isExcludedSlide(this.slidesByChart.get(entryName));
    }

    private boolean isExcludedDiagramData(String entryName) {
        if (!this.slidesByDiagramData.containsKey(entryName)) {
            return false;
        }
        return this.isExcludedSlide(this.slidesByDiagramData.get(entryName));
    }

    private boolean isHidden(String entryName, String contentType) {
        if (this.generalDocument.conditionalParameters().getTranslatePowerpointHidden()) {
            return false;
        }
        switch (contentType) {
            case "application/vnd.openxmlformats-officedocument.presentationml.slide+xml": {
                return this.isHiddenSlide(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml": {
                return this.isHiddenSlideLayout(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml": {
                return this.isHiddenSlideMaster(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.comments+xml": {
                return this.isHiddenComment(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml": {
                return this.isHiddenNotesSlide(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml": {
                return this.isHiddenNotesMaster(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.drawingml.chart+xml": {
                return this.isHiddenChart(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml": {
                return this.isHiddenDiagramData(entryName);
            }
        }
        return false;
    }

    private boolean isHiddenSlide(String entryName) {
        return this.hiddenSlides.contains(entryName);
    }

    private boolean isHiddenSlideLayout(String entryName) {
        boolean hidden = false;
        for (String slideName : this.slideLayoutsBySlide.keySet()) {
            if (!this.slideLayoutsBySlide.get(slideName).contains(entryName)) continue;
            if (this.isHiddenSlide(slideName)) {
                hidden = true;
                continue;
            }
            return false;
        }
        return hidden;
    }

    private boolean isHiddenSlideMaster(String entryName) {
        boolean hidden = false;
        for (String slideLayout : this.slideMastersBySlideLayout.keySet()) {
            if (!this.slideMastersBySlideLayout.get(slideLayout).contains(entryName)) continue;
            if (this.isHiddenSlideLayout(slideLayout)) {
                hidden = true;
                continue;
            }
            return false;
        }
        return hidden;
    }

    private boolean isHiddenComment(String entryName) {
        if (!this.slidesByComment.containsKey(entryName)) {
            return false;
        }
        return this.isHiddenSlide(this.slidesByComment.get(entryName));
    }

    private boolean isHiddenNotesSlide(String entryName) {
        if (!this.slidesByNotesSlide.containsKey(entryName)) {
            return false;
        }
        return this.isHiddenSlide(this.slidesByNotesSlide.get(entryName));
    }

    private boolean isHiddenNotesMaster(String entryName) {
        boolean hidden = false;
        for (String notesSlide : this.notesMastersByNotesSlide.keySet()) {
            if (!this.notesMastersByNotesSlide.get(notesSlide).contains(entryName)) continue;
            if (this.isHiddenNotesSlide(notesSlide)) {
                hidden = true;
                continue;
            }
            return false;
        }
        return hidden;
    }

    private boolean isHiddenChart(String entryName) {
        if (!this.slidesByChart.containsKey(entryName)) {
            return false;
        }
        return this.isHiddenSlide(this.slidesByChart.get(entryName));
    }

    private boolean isHiddenDiagramData(String entryName) {
        if (!this.slidesByDiagramData.containsKey(entryName)) {
            return false;
        }
        return this.isHiddenSlide(this.slidesByDiagramData.get(entryName));
    }

    @Override
    public void close() throws IOException {
    }
}

