/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;

interface ExcelColor {
    public static final String BACKGROUND = "bgColor";
    public static final String FOREGROUND = "fgColor";

    public String argb();

    public boolean themeAvailable();

    public int themeId();

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public Markup asMarkup();

    public static final class Default
    implements ExcelColor {
        public static final String INDEXED = "indexed";
        public static final String RGB = "rgb";
        public static final String THEME = "theme";
        private final StartElement startElement;
        private boolean idAvailable;
        private int id;
        private String argb;
        private boolean themeIdAvailable;
        private int themeId;
        private EndElement endElement;
        private boolean startElementAttributesRead;

        Default(StartElement startElement) {
            this.startElement = startElement;
        }

        @Override
        public String argb() {
            if (!this.startElementAttributesRead) {
                this.readStartElementAttributes();
            }
            return this.argb;
        }

        @Override
        public boolean themeAvailable() {
            if (!this.startElementAttributesRead) {
                this.readStartElementAttributes();
            }
            return this.themeIdAvailable;
        }

        @Override
        public int themeId() {
            if (!this.startElementAttributesRead) {
                this.readStartElementAttributes();
            }
            return this.themeId;
        }

        private void readStartElementAttributes() {
            Iterator<Attribute> iterator = this.startElement.getAttributes();
            while (iterator.hasNext()) {
                Attribute a = iterator.next();
                switch (a.getName().getLocalPart()) {
                    case "indexed": {
                        this.idAvailable = true;
                        this.id = Integer.parseUnsignedInt(a.getValue());
                        break;
                    }
                    case "rgb": {
                        this.argb = a.getValue();
                        break;
                    }
                    case "theme": {
                        this.themeIdAvailable = true;
                        this.themeId = Integer.parseUnsignedInt(a.getValue());
                    }
                }
            }
            this.startElementAttributesRead = true;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (!e.isEndElement() || !e.asEndElement().getName().equals(this.startElement.getName())) continue;
                this.endElement = e.asEndElement();
                break;
            }
        }

        @Override
        public Markup asMarkup() {
            if (null == this.endElement) {
                throw new IllegalStateException("The end element is not available");
            }
            MarkupBuilder mb = new MarkupBuilder(new Markup.General(new LinkedList<MarkupComponent>()));
            mb.add(this.startElement);
            mb.add(this.endElement);
            return mb.build();
        }
    }

    public static final class Empty
    implements ExcelColor {
        private static final String EMPTY = "";

        @Override
        public String argb() {
            return EMPTY;
        }

        @Override
        public boolean themeAvailable() {
            return false;
        }

        @Override
        public int themeId() {
            return 0;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
        }

        @Override
        public Markup asMarkup() {
            return new Markup.Empty();
        }
    }
}

