/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.sf.okapi.common.LocaleId;

interface DispersedTranslation {
    public String namespace();

    public String rawSource();

    public void prepareFor(LocaleId var1, String var2);

    public String encodedTargetOrRawSourceFor(LocaleId var1);

    public static final class Default
    implements DispersedTranslation {
        private final String namespace;
        private final String rawSource;
        private final Map<LocaleId, String> encodedTargets;

        Default(String namespace, String rawSource) {
            this(namespace, rawSource, new HashMap<LocaleId, String>());
        }

        Default(String namespace, String rawSource, Map<LocaleId, String> encodedTargets) {
            this.namespace = namespace;
            this.rawSource = rawSource;
            this.encodedTargets = encodedTargets;
        }

        @Override
        public String namespace() {
            return this.namespace;
        }

        @Override
        public String rawSource() {
            return this.rawSource;
        }

        @Override
        public void prepareFor(LocaleId locale, String encodedTarget) {
            this.encodedTargets.put(locale, encodedTarget);
        }

        @Override
        public String encodedTargetOrRawSourceFor(LocaleId locale) {
            return this.encodedTargets.getOrDefault(locale, this.rawSource);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Default another = (Default)o;
            return this.namespace.equals(another.namespace) && this.rawSource.equals(another.rawSource);
        }

        public int hashCode() {
            return Objects.hash(this.namespace, this.rawSource);
        }
    }
}

