/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.net.URL;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.Tag;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.PropertyTextUnitPlaceholder;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.abstractmarkup.AbstractMarkupFilter;
import net.sf.okapi.filters.abstractmarkup.ExtractionRuleState;
import net.sf.okapi.filters.abstractmarkup.config.TaggedFilterConfiguration;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.YamlParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ContentFilter
extends AbstractMarkupFilter {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final ConditionalParameters filterParams;
    private final String partName;
    private ParseType configurationType;
    private ParseType filetype = ParseType.MSWORD;
    private String sConfigFileName;
    private StringBuilder sInExclusion = new StringBuilder();
    private boolean bInTextRun = false;
    private boolean bBetweenTextMarkers = false;
    private boolean bInSettingsFile = false;
    private YamlParameters params = null;
    private TaggedFilterConfiguration config = null;
    private String pendingTagName;
    private String pendingTagText;
    private boolean bInPowerpointComment = false;

    public ContentFilter(ConditionalParameters filterParams, String partName) {
        this.filterParams = filterParams;
        this.partName = partName;
        this.setMimeType("text/xml");
        this.setFilterWriter(this.createFilterWriter());
    }

    public void displayOneEvent(Event event) {
        if (this.LOGGER.isTraceEnabled()) {
            String etyp = event.getEventType().toString();
            if (event.getEventType() == EventType.TEXT_UNIT || event.getEventType() == EventType.DOCUMENT_PART || event.getEventType() == EventType.START_GROUP || event.getEventType() == EventType.END_GROUP || event.getEventType() == EventType.START_SUBFILTER || event.getEventType() == EventType.END_SUBFILTER) {
                // empty if block
            }
            if (etyp.equals("START")) {
                this.LOGGER.trace("\n");
            }
            this.LOGGER.trace("{}: ", (Object)etyp);
            if (event.getResource() != null) {
                this.LOGGER.trace("({})", (Object)event.getResource().getId());
                if (event.getResource() instanceof DocumentPart) {
                    Set<String> setter = ((DocumentPart)event.getResource()).getSourcePropertyNames();
                    for (String seti : setter) {
                        this.LOGGER.trace(seti);
                    }
                } else {
                    this.LOGGER.trace(event.getResource().toString());
                }
                if (event.getResource().getSkeleton() != null) {
                    this.LOGGER.trace("*Skeleton: \n{}", (Object)event.getResource().getSkeleton().toString());
                }
            }
        }
    }

    public ParseType getParseType() {
        return this.filetype;
    }

    public void setUpConfig(ParseType filetype) {
        this.filetype = filetype;
        switch (filetype) {
            case MSEXCEL: {
                this.sConfigFileName = "excelConfiguration.yml";
                this.configurationType = ParseType.MSEXCEL;
                break;
            }
            case MSWORDDOCPROPERTIES: {
                this.sConfigFileName = "wordDocPropertiesConfiguration.yml";
                this.configurationType = ParseType.MSWORDDOCPROPERTIES;
                break;
            }
            case MSPOWERPOINTCOMMENTS: {
                this.sConfigFileName = "powerpointCommentConfiguration.yml";
                break;
            }
            default: {
                this.sConfigFileName = "wordConfiguration.yml";
                this.configurationType = ParseType.MSWORD;
            }
        }
        URL urlConfig = ContentFilter.class.getResource(this.sConfigFileName);
        this.config = new TaggedFilterConfiguration(urlConfig);
        try {
            this.setParameters(new YamlParameters(urlConfig));
        }
        catch (Exception e) {
            throw new OkapiIOException("Can't read MS Office Filter Configuration File.");
        }
    }

    @Override
    protected void handleText(CharSequence text) {
        if (text == null) {
            return;
        }
        this.startDelayedTextUnit();
        String txt = text.toString();
        this.handleSomeText(txt, this.isWhiteSpace(text));
    }

    private void handleSomeText(String tixt, boolean bWhiteSpace) {
        String txt = tixt;
        if (this.getRuleState().isExcludedState()) {
            this.sInExclusion.append(tixt);
            return;
        }
        if (bWhiteSpace && !this.isInsideTextRun()) {
            this.addToDocumentPart(txt);
            return;
        }
        if (this.canStartNewTextUnit()) {
            this.addToDocumentPart(txt);
        } else if (this.bInTextRun) {
            if (this.bBetweenTextMarkers) {
                this.addToTextUnit(txt);
                this.bInTextRun = true;
            }
        } else if (this.bInPowerpointComment) {
            this.addToTextUnit(txt);
        }
    }

    @Override
    protected void handleStartTag(StartTag startTag) {
        this.startDelayedTextUnit();
        String sTagName = startTag.getName();
        String sTagString = startTag.toString();
        if (sTagName.equals("p:text")) {
            this.bInPowerpointComment = true;
        }
        EnumSet<TaggedFilterConfiguration.RULE_TYPE> ruleTypes = this.getConfig().getElementRuleTypes(sTagName, true);
        ExtractionRuleState.ExtractionRule rule = this.disambiguateElementRuleTypes((Tag)startTag, ruleTypes);
        switch (rule.ruleType) {
            case INLINE_ELEMENT: {
                this.addToDocumentPart(sTagString);
                break;
            }
            case ATTRIBUTES_ONLY: {
                List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders = this.createPropertyTextUnitPlaceholders(startTag);
                if (propertyTextUnitPlaceholders != null && !propertyTextUnitPlaceholders.isEmpty()) {
                    this.startDocumentPart(sTagString, sTagName, propertyTextUnitPlaceholders);
                    this.endDocumentPart();
                    break;
                }
                this.addToDocumentPart(sTagString);
                break;
            }
            case GROUP_ELEMENT: {
                if (!this.bInSettingsFile) break;
                this.addToDocumentPart(sTagString);
                break;
            }
            case EXCLUDED_ELEMENT: {
                this.getRuleState().pushExcludedIncludedRule(rule);
                this.sInExclusion.append(sTagString);
                break;
            }
            case TEXT_UNIT_ELEMENT: {
                this.pendingTagName = startTag.getName();
                this.pendingTagText = startTag.toString();
                break;
            }
            default: {
                this.addToDocumentPart(sTagString);
            }
        }
    }

    private void startDelayedTextUnit() {
        if (this.pendingTagName != null) {
            this.getRuleState().pushTextUnitRule(new ExtractionRuleState.ExtractionRule(this.pendingTagName, TaggedFilterConfiguration.RULE_TYPE.TEXT_UNIT_ELEMENT, true));
            this.startTextUnit(new GenericSkeleton(this.pendingTagText));
            if (this.configurationType == ParseType.MSEXCEL || this.configurationType == ParseType.MSWORDDOCPROPERTIES) {
                this.bInTextRun = true;
                this.bBetweenTextMarkers = true;
            } else {
                this.bInTextRun = false;
                this.bBetweenTextMarkers = false;
            }
            this.pendingTagName = null;
            this.pendingTagText = null;
        }
    }

    @Override
    protected void handleEndTag(EndTag endTag) {
        String sTagName = endTag.getName();
        String sTagString = endTag.toString();
        EnumSet<TaggedFilterConfiguration.RULE_TYPE> ruleTypes = this.getConfig().getElementRuleTypes(sTagName, false);
        ExtractionRuleState.ExtractionRule rule = this.disambiguateElementRuleTypes((Tag)endTag, ruleTypes);
        if (this.getRuleState().isExcludedState()) {
            this.sInExclusion.append(sTagString);
            switch (rule.ruleType) {
                case EXCLUDED_ELEMENT: {
                    this.getRuleState().popExcludedIncludedRule();
                }
            }
            if (sTagName.equals("p:text")) {
                this.bInPowerpointComment = false;
            }
            if (!this.getRuleState().isExcludedState()) {
                this.addToDocumentPart(this.sInExclusion.toString());
                this.sInExclusion = new StringBuilder();
            }
            return;
        }
        switch (rule.ruleType) {
            case INLINE_ELEMENT: {
                this.addToDocumentPart(sTagString);
                break;
            }
            case TEXT_UNIT_ELEMENT: {
                if (this.pendingTagName != null) {
                    this.addToDocumentPart(this.pendingTagText);
                    this.addToDocumentPart(sTagString);
                    this.pendingTagName = null;
                    this.pendingTagText = null;
                    break;
                }
                if (this.bInTextRun) {
                    this.bInTextRun = false;
                }
                this.bBetweenTextMarkers = true;
                try {
                    this.getRuleState().popTextUnitRule();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.endTextUnit(new GenericSkeleton(sTagString));
                break;
            }
            default: {
                this.addToDocumentPart(sTagString);
            }
        }
    }

    @Override
    public ExtractionRuleState.ExtractionRule disambiguateElementRuleTypes(Tag tag, EnumSet<TaggedFilterConfiguration.RULE_TYPE> ruleTypes) {
        ExtractionRuleState.ExtractionRule rule = new ExtractionRuleState.ExtractionRule(tag.getName().toLowerCase(), TaggedFilterConfiguration.RULE_TYPE.RULE_NOT_FOUND, true);
        if (ruleTypes.containsAll(TaggedFilterConfiguration.INLINE_AND_INCLUDE)) {
            rule.ruleType = TaggedFilterConfiguration.RULE_TYPE.INLINE_INCLUDED_ELEMENT;
        } else if (ruleTypes.containsAll(TaggedFilterConfiguration.INLINE_AND_EXCLUDE)) {
            rule.ruleType = TaggedFilterConfiguration.RULE_TYPE.INLINE_EXCLUDED_ELEMENT;
        } else if (ruleTypes.contains((Object)TaggedFilterConfiguration.RULE_TYPE.INLINE_ELEMENT)) {
            rule.ruleType = TaggedFilterConfiguration.RULE_TYPE.INLINE_ELEMENT;
        } else if (ruleTypes.contains((Object)TaggedFilterConfiguration.RULE_TYPE.INCLUDED_ELEMENT)) {
            rule.ruleType = TaggedFilterConfiguration.RULE_TYPE.INCLUDED_ELEMENT;
        } else if (ruleTypes.contains((Object)TaggedFilterConfiguration.RULE_TYPE.EXCLUDED_ELEMENT)) {
            rule.ruleType = TaggedFilterConfiguration.RULE_TYPE.EXCLUDED_ELEMENT;
        } else if (ruleTypes.contains((Object)TaggedFilterConfiguration.RULE_TYPE.GROUP_ELEMENT)) {
            rule.ruleType = TaggedFilterConfiguration.RULE_TYPE.GROUP_ELEMENT;
        } else if (ruleTypes.contains((Object)TaggedFilterConfiguration.RULE_TYPE.TEXT_UNIT_ELEMENT)) {
            rule.ruleType = TaggedFilterConfiguration.RULE_TYPE.TEXT_UNIT_ELEMENT;
        } else if (ruleTypes.contains((Object)TaggedFilterConfiguration.RULE_TYPE.ATTRIBUTES_ONLY)) {
            rule.ruleType = TaggedFilterConfiguration.RULE_TYPE.ATTRIBUTES_ONLY;
        }
        return rule;
    }

    @Override
    protected void handleComment(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    protected void handleDocTypeDeclaration(Tag tag) {
        this.handleDocumentPart(tag);
    }

    protected void handleMarkupDeclaration(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    protected void handleProcessingInstruction(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    protected void handleServerCommon(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    protected void handleServerCommonEscaped(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    protected void handleXmlDeclaration(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    public String getName() {
        return "OpenXMLContentFilter";
    }

    @Override
    protected String normalizeAttributeName(String attrName, String attrValue, Tag tag) {
        StartTag st;
        String normalizedName = attrName;
        String tagName = tag.getName();
        if ((tagName.equals("w:lang") || tagName.equals("w:themefontlang")) && (st = (StartTag)tag).getAttributeValue("w:val") != null) {
            normalizedName = "language";
            return normalizedName;
        }
        return normalizedName;
    }

    public ParseType getConfigurationType() {
        return this.configurationType;
    }

    protected void setBInSettingsFile(boolean bInSettingsFile) {
        this.bInSettingsFile = bInSettingsFile;
    }

    protected boolean getBInSettingsFile() {
        return this.bInSettingsFile;
    }

    @Override
    protected TaggedFilterConfiguration getConfig() {
        return this.config;
    }

    @Override
    public YamlParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (YamlParameters)params;
    }

    public ConditionalParameters getFilterParameters() {
        return this.filterParams;
    }

    public String toString() {
        return "OpenXMLContentFilter [" + this.partName + "]";
    }
}

