/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.CellAlignment;
import net.sf.okapi.filters.openxml.CellProtection;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;

interface CellFormat {
    public static final String NAME = "xf";

    public boolean idAvailable();

    public int id();

    public int numberFormatId();

    public int fontId();

    public int fillId();

    public int borderId();

    public CellAlignment alignment();

    public CellProtection protection();

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public Markup asMarkup();

    public static final class Default
    implements CellFormat {
        private static final String XF_ID = "xfId";
        private static final String NUM_FMT_ID = "numFmtId";
        private static final String FONT_ID = "fontId";
        private static final String FILL_ID = "fillId";
        private static final String BORDER_ID = "borderId";
        private final XMLEventFactory eventFactory;
        private final StartElement startElement;
        private boolean idAvailable;
        private int id;
        private int numberFormatId;
        private int fontId;
        private int fillId;
        private int borderId;
        private CellAlignment alignment;
        private CellProtection protection;
        private EndElement endElement;
        private boolean startElementAttributesRead;

        Default(XMLEventFactory eventFactory, StartElement startElement) {
            this.eventFactory = eventFactory;
            this.startElement = startElement;
        }

        @Override
        public boolean idAvailable() {
            if (!this.startElementAttributesRead) {
                this.readStartElementAttributes();
            }
            return this.idAvailable;
        }

        @Override
        public int id() {
            if (!this.startElementAttributesRead) {
                this.readStartElementAttributes();
            }
            return this.id;
        }

        @Override
        public int numberFormatId() {
            if (!this.startElementAttributesRead) {
                this.readStartElementAttributes();
            }
            return this.numberFormatId;
        }

        @Override
        public int fontId() {
            if (!this.startElementAttributesRead) {
                this.readStartElementAttributes();
            }
            return this.fontId;
        }

        @Override
        public int fillId() {
            if (!this.startElementAttributesRead) {
                this.readStartElementAttributes();
            }
            return this.fillId;
        }

        @Override
        public int borderId() {
            if (!this.startElementAttributesRead) {
                this.readStartElementAttributes();
            }
            return this.borderId;
        }

        @Override
        public CellAlignment alignment() {
            if (null == this.alignment) {
                this.alignment = new CellAlignment.Empty();
            }
            return this.alignment;
        }

        @Override
        public CellProtection protection() {
            if (null == this.protection) {
                this.protection = new CellProtection.Empty();
            }
            return this.protection;
        }

        private void readStartElementAttributes() {
            Iterator<Attribute> iterator = this.startElement.getAttributes();
            while (iterator.hasNext()) {
                Attribute a = iterator.next();
                switch (a.getName().getLocalPart()) {
                    case "xfId": {
                        this.idAvailable = true;
                        this.id = Integer.parseUnsignedInt(a.getValue());
                        break;
                    }
                    case "numFmtId": {
                        this.numberFormatId = Integer.parseUnsignedInt(a.getValue());
                        break;
                    }
                    case "fontId": {
                        this.fontId = Integer.parseUnsignedInt(a.getValue());
                        break;
                    }
                    case "fillId": {
                        this.fillId = Integer.parseUnsignedInt(a.getValue());
                        break;
                    }
                    case "borderId": {
                        this.borderId = Integer.parseUnsignedInt(a.getValue());
                    }
                }
            }
            this.startElementAttributesRead = true;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = e.asEndElement();
                    break;
                }
                if (!e.isStartElement()) continue;
                StartElement se = e.asStartElement();
                if ("alignment".equals(se.getName().getLocalPart())) {
                    this.alignment = new CellAlignment.Default(this.eventFactory, se);
                    this.alignment.readWith(reader);
                    continue;
                }
                if (!"protection".equals(se.getName().getLocalPart())) continue;
                this.protection = new CellProtection.Default(se);
                this.protection.readWith(reader);
            }
        }

        @Override
        public Markup asMarkup() {
            if (null == this.endElement) {
                throw new IllegalStateException("The end element is not available");
            }
            MarkupBuilder mb = new MarkupBuilder(new Markup.General(new LinkedList<MarkupComponent>()));
            mb.add(this.startElement);
            mb.add(this.alignment().asMarkup());
            mb.add(this.protection().asMarkup());
            mb.add(this.endElement);
            return mb.build();
        }
    }
}

