/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.ElementParser;
import net.sf.okapi.filters.idml.GeometryPathParser;
import net.sf.okapi.filters.idml.Namespaces;
import net.sf.okapi.filters.idml.Property;

class PropertyParser
extends ElementParser {
    private static final QName GEOMETRY_PATH_TYPE = Namespaces.getDefaultNamespace().getQName("GeometryPathType");

    PropertyParser(StartElement startElement, XMLEventReader eventReader, XMLEventFactory eventFactory) {
        super(startElement, eventReader, eventFactory);
    }

    Property parse() throws XMLStreamException {
        return (Property)super.parse(new Property.Builder());
    }

    static class PathGeometryPropertyParserRange
    extends PropertyParser {
        PathGeometryPropertyParserRange(StartElement startElement, XMLEventReader eventReader, XMLEventFactory eventFactory) {
            super(startElement, eventReader, eventFactory);
        }

        @Override
        Property.PathGeometryProperty parse() throws XMLStreamException {
            Property.PathGeometryProperty.Builder builder = new Property.PathGeometryProperty.Builder();
            builder.setStartElement(this.startElement);
            while (this.eventReader.hasNext()) {
                XMLEvent event = this.eventReader.nextEvent();
                if (event.isEndElement() && event.asEndElement().getName().equals(this.startElement.getName())) {
                    builder.setEndElement(event.asEndElement());
                    return builder.build();
                }
                if (!event.isStartElement() || !GEOMETRY_PATH_TYPE.equals(event.asStartElement().getName())) continue;
                builder.addGeometryPath(new GeometryPathParser(event.asStartElement(), this.eventReader, this.eventFactory).parse());
            }
            throw new IllegalStateException("Unexpected structure");
        }
    }
}

