/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.abstractmarkup.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.filters.abstractmarkup.config.IllegalConditionalAttributeException;
import org.yaml.snakeyaml.Yaml;

public class YamlConfigurationReader
implements AutoCloseable {
    private static final String REGEX_META_CHARS_REGEX = "[({^$|})?*+\\[\\]]+";
    private static final Pattern REGEX_META_CHARS_PATTERN = Pattern.compile("[({^$|})?*+\\[\\]]+");
    private boolean preserveWhitespace;
    private final Yaml yaml;
    private final Map<String, Object> config;
    private Map<String, Object> elementRules;
    private Map<String, Object> attributeRules;
    private Map<String, Object> elementRegexRules;
    private Map<String, Pattern> elementCompiledRegexRules;
    private Map<String, Object> attributeRegexRules;
    private Map<String, Pattern> attributeCompiledRegexRules;
    private InputStreamReader reader;

    public boolean isPreserveWhitespace() {
        return this.preserveWhitespace;
    }

    public void setPreserveWhitespace(boolean preserveWhitespace) {
        this.preserveWhitespace = preserveWhitespace;
    }

    public YamlConfigurationReader() {
        this.yaml = new Yaml();
        this.config = (Map)this.yaml.load("collapse_whitespace: false\nassumeWellformed: true");
        this.initialize();
    }

    public YamlConfigurationReader(URL configurationPathAsResource) {
        try {
            this.reader = new InputStreamReader(configurationPathAsResource.openStream(), StandardCharsets.UTF_8);
            this.yaml = new Yaml();
            this.config = (Map)this.yaml.load((Reader)this.reader);
            this.initialize();
        }
        catch (IOException e) {
            throw new OkapiException(e);
        }
    }

    public YamlConfigurationReader(File configurationFile) {
        try {
            this.reader = new InputStreamReader((InputStream)new FileInputStream(configurationFile), StandardCharsets.UTF_8);
            this.yaml = new Yaml();
            this.config = (Map)this.yaml.load((Reader)this.reader);
            this.initialize();
        }
        catch (FileNotFoundException e) {
            throw new OkapiException(e);
        }
    }

    public YamlConfigurationReader(String configurationScript) {
        this.yaml = new Yaml();
        this.config = (Map)this.yaml.load(configurationScript);
        this.initialize();
    }

    protected void initialize() {
        this.elementRules = new LinkedHashMap<String, Object>();
        this.attributeRules = new LinkedHashMap<String, Object>();
        Map er = (Map)this.config.get("elements");
        Map ar = (Map)this.config.get("attributes");
        if (er != null) {
            this.elementRules = er;
        }
        if (ar != null) {
            this.attributeRules = ar;
        }
        this.elementRegexRules = new LinkedHashMap<String, Object>();
        this.attributeRegexRules = new LinkedHashMap<String, Object>();
        this.findRegexRules();
        this.compileRegexRules();
    }

    public String toString() {
        return this.yaml.dump(this.config);
    }

    public List<Map> getAllRuleTypes(String ruleName) {
        LinkedList<Map> rules = new LinkedList<Map>();
        List<Map> rule = this.getElementRules(ruleName);
        if (rule != null) {
            rules.addAll(rule);
        }
        rules.addAll(this.getAttributeRules(ruleName));
        return rules;
    }

    public List<Map> getElementRules(String ruleName) {
        LinkedList<Map> rules = new LinkedList<Map>();
        Map rule = (Map)this.elementRules.get(ruleName);
        if (rule != null) {
            rules.add(rule);
        }
        rules.addAll(this.getRegexElementRule(ruleName));
        return rules;
    }

    public List<Map> getRegexElementRule(String ruleName) {
        LinkedList<Map> rules = new LinkedList<Map>();
        if (!this.elementRegexRules.isEmpty()) {
            for (Map.Entry<String, Object> e : this.elementRegexRules.entrySet()) {
                Matcher m = this.elementCompiledRegexRules.get(e.getKey()).matcher(ruleName);
                if (!m.matches()) continue;
                rules.add((Map)e.getValue());
            }
        }
        return rules;
    }

    public List<Map> getAttributeRules(String ruleName) {
        LinkedList<Map> rules = new LinkedList<Map>();
        Map rule = (Map)this.attributeRules.get(ruleName);
        if (rule != null) {
            rules.add(rule);
        }
        rules.addAll(this.getRegexAttributeRules(ruleName));
        return rules;
    }

    public List<Map> getRegexAttributeRules(String ruleName) {
        LinkedList<Map> rules = new LinkedList<Map>();
        if (!this.attributeRegexRules.isEmpty()) {
            for (Map.Entry<String, Object> e : this.attributeRegexRules.entrySet()) {
                Matcher m = this.attributeCompiledRegexRules.get(e.getKey()).matcher(ruleName);
                if (!m.matches()) continue;
                rules.add((Map)e.getValue());
            }
        }
        return rules;
    }

    public Object getProperty(String property) {
        return this.config.get(property);
    }

    public void addProperty(String property, boolean value) {
        this.config.put(property, value);
    }

    public void addProperty(String property, String value) {
        this.config.put(property, value);
    }

    public void clearRules() {
        this.config.clear();
        this.elementRules.clear();
        this.attributeRules.clear();
        this.elementRegexRules.clear();
        this.elementCompiledRegexRules.clear();
        this.attributeRegexRules.clear();
        this.attributeCompiledRegexRules.clear();
    }

    protected void findRegexRules() {
        Matcher m;
        for (Map.Entry<String, Object> entry : this.elementRules.entrySet()) {
            try {
                m = REGEX_META_CHARS_PATTERN.matcher(entry.getKey());
                if (!m.find()) continue;
                this.elementRegexRules.put(entry.getKey(), entry.getValue());
            }
            catch (PatternSyntaxException e) {
                throw new IllegalConditionalAttributeException(e);
            }
        }
        for (Map.Entry<String, Object> entry : this.attributeRules.entrySet()) {
            try {
                m = REGEX_META_CHARS_PATTERN.matcher(entry.getKey());
                if (!m.find()) continue;
                this.attributeRegexRules.put(entry.getKey(), entry.getValue());
            }
            catch (PatternSyntaxException e) {
                throw new IllegalConditionalAttributeException(e);
            }
        }
    }

    protected void compileRegexRules() {
        Pattern compiledRegex;
        if (!this.elementRegexRules.isEmpty()) {
            this.elementCompiledRegexRules = new LinkedHashMap<String, Pattern>();
            for (String r : this.elementRegexRules.keySet()) {
                compiledRegex = Pattern.compile(r);
                this.elementCompiledRegexRules.put(r, compiledRegex);
            }
        }
        if (!this.attributeRegexRules.isEmpty()) {
            this.attributeCompiledRegexRules = new LinkedHashMap<String, Pattern>();
            for (String r : this.attributeRegexRules.keySet()) {
                compiledRegex = Pattern.compile(r);
                this.attributeCompiledRegexRules.put(r, compiledRegex);
            }
        }
    }

    public Map<String, Object> getAttributeRules() {
        return this.attributeRules;
    }

    public Map<String, Object> getElementRules() {
        return this.elementRules;
    }

    @Override
    public void close() throws Exception {
        this.reader.close();
    }
}

