/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.microsoft;

import java.util.List;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.connectors.microsoft.Parameters;
import net.sf.okapi.connectors.microsoft.TranslationResponse;

abstract class QueryResultBuilder<T> {
    protected Parameters params;
    protected int weight;

    QueryResultBuilder(Parameters params, int weight) {
        this.params = params;
        this.weight = weight;
    }

    abstract List<QueryResult> convertResponses(List<TranslationResponse> var1, T var2);

    protected QueryResult createQueryResult(TranslationResponse response) {
        QueryResult qr = new QueryResult();
        if (response.rating != QueryResult.QUALITY_UNDEFINED) {
            qr.setQuality(Util.normalizeRange(-10.0, 10.0, response.rating));
        }
        qr.setFuzzyScore(response.matchDegree);
        qr.setCombinedScore(response.combinedScore);
        qr.weight = this.weight;
        qr.origin = "Microsoft-Translator";
        if (!Util.isEmpty(this.params.getCategory())) {
            qr.engine = this.params.getCategory();
        }
        qr.matchType = MatchType.MT;
        return qr;
    }
}

