/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.skeleton;

import java.util.List;
import java.util.regex.Pattern;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.RegexUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;

public class SkeletonUtil {
    private static final String TU_REF = TextFragment.makeRefMarker("$self$");
    private static final Pattern PROPERTY_REGEX = Pattern.compile(String.format("%s%s%s.+%s", RegexUtil.escape("[#$"), RegexUtil.escape("$self$"), RegexUtil.escape("@%"), RegexUtil.escape("]")));
    private static final Pattern REF_REGEX = Pattern.compile(String.format("%s.+%s", RegexUtil.escape("[#$"), RegexUtil.escape("]")));
    private static final Pattern SEG_REF_REGEX = Pattern.compile(String.format("%s.+%s%s%s", RegexUtil.escape("[#$"), RegexUtil.escape("@%"), RegexUtil.escape(Segment.REF_MARKER), RegexUtil.escape("]")));

    public static int findTuRefInSkeleton(GenericSkeleton skel) {
        return SkeletonUtil.findTuRefInSkeleton(skel, null);
    }

    public static int findTuRefInSkeleton(GenericSkeleton skel, LocaleId locId) {
        if (skel == null) {
            return -1;
        }
        List<GenericSkeletonPart> list = skel.getParts();
        for (int i = 0; i < list.size(); ++i) {
            GenericSkeletonPart part = list.get(i);
            String st = part.toString();
            if (Util.isEmpty(st) || !st.equalsIgnoreCase(TU_REF)) continue;
            if (Util.isNullOrEmpty(locId)) {
                return i;
            }
            if (!locId.equals(part.getLocale())) continue;
            return i;
        }
        return -1;
    }

    public static boolean hasTuRef(GenericSkeleton skel) {
        return SkeletonUtil.findTuRefInSkeleton(skel) != -1;
    }

    public static boolean hasTuRef(GenericSkeleton skel, LocaleId locId) {
        return SkeletonUtil.findTuRefInSkeleton(skel, locId) != -1;
    }

    public static GenericSkeleton[] splitSkeleton(GenericSkeleton skel) {
        GenericSkeleton[] res = new GenericSkeleton[2];
        int index = SkeletonUtil.findTuRefInSkeleton(skel);
        if (index == -1) {
            res[0] = skel;
            res[1] = new GenericSkeleton();
        } else {
            List<GenericSkeletonPart> parts = skel.getParts();
            res[0] = new GenericSkeleton();
            res[0].getParts().addAll(parts.subList(0, index));
            res[1] = new GenericSkeleton();
            res[1].getParts().addAll(parts.subList(index + 1, parts.size()));
        }
        return res;
    }

    public static boolean replaceSkeletonPart(GenericSkeleton skel, int index, GenericSkeleton replacement) {
        if (skel == null) {
            return false;
        }
        if (replacement == null) {
            return false;
        }
        List<GenericSkeletonPart> list = skel.getParts();
        if (!Util.checkIndex(index, list)) {
            return false;
        }
        List<GenericSkeletonPart> list2 = ListUtil.moveItems(list);
        for (int i = 0; i < list2.size(); ++i) {
            if (i == index) {
                skel.add(replacement);
                continue;
            }
            list.add(list2.get(i));
        }
        return true;
    }

    public static int getNumParts(GenericSkeleton skel) {
        return skel.getParts().size();
    }

    public static GenericSkeletonPart getPart(GenericSkeleton skel, int index) {
        List<GenericSkeletonPart> parts = skel.getParts();
        if (!Util.checkIndex(index, parts)) {
            return null;
        }
        return parts.get(index);
    }

    public static boolean isTuRef(GenericSkeletonPart part) {
        return TU_REF.equals(part.toString());
    }

    public static boolean isRef(GenericSkeletonPart part) {
        String st = part.toString();
        return !SkeletonUtil.isTuRef(part) && RegexUtil.contains(st, REF_REGEX);
    }

    public static boolean isPropRef(GenericSkeletonPart part) {
        String st = part.toString();
        return !SkeletonUtil.isTuRef(part) && RegexUtil.matches(st, PROPERTY_REGEX);
    }

    public static boolean isSegRef(GenericSkeletonPart part) {
        String st = part.toString();
        return !SkeletonUtil.isTuRef(part) && RegexUtil.matches(st, SEG_REF_REGEX);
    }

    public static boolean isSourcePlaceholder(GenericSkeletonPart part, IResource resource) {
        if (resource == null || part == null) {
            return false;
        }
        return SkeletonUtil.isTuRef(part) && part.getParent() == resource && part.getLocale() == null;
    }

    public static boolean isTargetPlaceholder(GenericSkeletonPart part, IResource resource) {
        if (resource == null || part == null) {
            return false;
        }
        return SkeletonUtil.isTuRef(part) && part.getParent() == resource && part.getLocale() != null;
    }

    public static boolean isPropValuePlaceholder(GenericSkeletonPart part, IResource resource) {
        if (resource == null || part == null) {
            return false;
        }
        return SkeletonUtil.isPropRef(part) && part.getParent() == resource;
    }

    public static boolean isSegmentPlaceholder(GenericSkeletonPart part, IResource resource) {
        if (resource == null || part == null) {
            return false;
        }
        return SkeletonUtil.isSegRef(part) && part.getParent() == resource;
    }

    public static boolean isExtSourcePlaceholder(GenericSkeletonPart part, IResource resource) {
        if (resource == null || part == null) {
            return false;
        }
        return SkeletonUtil.isTuRef(part) && part.getParent() != resource && part.getParent() != null && part.getLocale() == null;
    }

    public static boolean isExtTargetPlaceholder(GenericSkeletonPart part, IResource resource) {
        if (resource == null || part == null) {
            return false;
        }
        return SkeletonUtil.isTuRef(part) && part.getParent() != resource && part.getParent() != null && part.getLocale() != null;
    }

    public static boolean isExtPropValuePlaceholder(GenericSkeletonPart part, IResource resource) {
        if (resource == null || part == null) {
            return false;
        }
        return SkeletonUtil.isPropRef(part) && part.getParent() != resource && part.getParent() != null;
    }

    public static boolean isExtSegmentPlaceholder(GenericSkeletonPart part, IResource resource) {
        if (resource == null || part == null) {
            return false;
        }
        return SkeletonUtil.isSegRef(part) && part.getParent() != resource && part.getParent() != null;
    }

    public static boolean isReference(GenericSkeletonPart part) {
        if (part == null) {
            return false;
        }
        return SkeletonUtil.isRef(part) && part.getParent() == null && part.getLocale() == null;
    }

    public static boolean isText(GenericSkeletonPart part) {
        if (part == null) {
            return false;
        }
        return !SkeletonUtil.isTuRef(part) && !SkeletonUtil.isPropRef(part) && !SkeletonUtil.isRef(part) && !SkeletonUtil.isSegRef(part);
    }

    public static String getRefId(GenericSkeletonPart part) {
        Object[] marker = TextFragment.getRefMarker(part.getData());
        return (String)marker[0];
    }

    public static void changeParent(ISkeleton skel, IResource curParent, IResource newParent) {
        if (skel instanceof GenericSkeleton) {
            GenericSkeleton gs = (GenericSkeleton)skel;
            if (gs.getParent() == curParent) {
                gs.setParent(newParent);
            }
            for (GenericSkeletonPart part : gs.getParts()) {
                if (part.getParent() != curParent) continue;
                part.setParent(newParent);
            }
        }
    }
}

