/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.resource.AlignedSegments;
import net.sf.okapi.common.resource.BaseReferenceable;
import net.sf.okapi.common.resource.IAlignedSegments;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.IWithAnnotations;
import net.sf.okapi.common.resource.IWithProperties;
import net.sf.okapi.common.resource.IWithSourceProperties;
import net.sf.okapi.common.resource.IWithTargetProperties;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;

public class TextUnit
extends BaseReferenceable
implements ITextUnit {
    private static int TARGETS_INITCAP = 2;
    private int refCount;
    private String type;
    private boolean isTranslatable = true;
    private boolean preserveWS;
    private TextContainer source;
    private ConcurrentHashMap<LocaleId, TextContainer> targets = new ConcurrentHashMap(TARGETS_INITCAP);

    public TextUnit() {
        this.create(null, null, false, null);
    }

    public TextUnit(String id) {
        this.create(id, null, false, null);
    }

    public TextUnit(String id, String sourceText) {
        this.create(id, sourceText, false, null);
    }

    public TextUnit(String id, String sourceText, boolean isReferent) {
        this.create(id, sourceText, isReferent, null);
    }

    public TextUnit(String id, String sourceText, boolean isReferent, String mimeType) {
        this.create(id, sourceText, isReferent, mimeType);
    }

    private void create(String id, String sourceText, boolean isReferent, String mimeType) {
        this.id = id;
        this.refCount = isReferent ? 1 : 0;
        this.mimeType = mimeType;
        this.source = new TextContainer(sourceText);
    }

    @Override
    public boolean isEmpty() {
        return this.getSource().isEmpty();
    }

    @Override
    public TextContainer getSource() {
        return this.source;
    }

    @Override
    public TextContainer setSource(TextContainer textContainer) {
        this.source = textContainer;
        return this.source;
    }

    @Override
    public TextFragment setSourceContent(TextFragment content) {
        this.getSource().setContent(content);
        return this.getSource().getFirstContent();
    }

    @Override
    public TextContainer createTarget(LocaleId targetLocale, boolean overwriteExisting, int creationOptions) {
        TextContainer trgCont = this.targets.get(targetLocale);
        if (trgCont == null || overwriteExisting) {
            trgCont = this.getSource().clone((creationOptions & 2) == 2);
            if ((creationOptions & 4) != 4) {
                trgCont.joinAll();
            }
            if ((creationOptions & 1) != 1) {
                for (Segment seg : trgCont.getSegments()) {
                    seg.text.clear();
                }
            }
            this.targets.put(targetLocale, trgCont);
        }
        return trgCont;
    }

    @Override
    public TextContainer getTarget(LocaleId locId) {
        if (locId == null) {
            return new TextContainer();
        }
        return this.targets.get(locId);
    }

    @Override
    public TextContainer setTarget(LocaleId locId, TextContainer text) {
        this.targets.put(locId, text);
        return text;
    }

    @Override
    public void removeTarget(LocaleId locId) {
        if (this.hasTarget(locId)) {
            this.targets.remove(locId);
        }
    }

    @Override
    public boolean hasTarget(LocaleId locId) {
        return this.targets.containsKey(locId);
    }

    @Override
    public TextFragment setTargetContent(LocaleId locId, TextFragment content) {
        TextContainer tc = this.createTarget(locId, false, 0);
        tc.setContent(content);
        return tc.getSegments().getFirstContent();
    }

    @Override
    public IAlignedSegments getAlignedSegments() {
        return new AlignedSegments(this);
    }

    @Override
    public ISegments getSourceSegments() {
        return this.getSource().getSegments();
    }

    @Override
    public Segment getSourceSegment(String segId, boolean createIfNeeded) {
        Segment seg = this.getSource().getSegments().get(segId);
        if (seg == null && createIfNeeded) {
            seg = new Segment(segId);
            this.getSource().getSegments().append(seg);
        }
        return seg;
    }

    @Override
    public ISegments getTargetSegments(LocaleId trgLoc) {
        return this.createTarget(trgLoc, false, 4).getSegments();
    }

    @Override
    public Segment getTargetSegment(LocaleId trgLoc, String segId, boolean createIfNeeded) {
        Segment seg = this.createTarget(trgLoc, false, 4).getSegments().get(segId);
        if (seg == null && createIfNeeded) {
            seg = new Segment(segId);
            this.getTarget(trgLoc).getSegments().append(seg);
        }
        return seg;
    }

    @Override
    public Set<LocaleId> getTargetLocales() {
        return this.targets.keySet();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String value) {
        this.type = value;
    }

    @Override
    public boolean isTranslatable() {
        return this.isTranslatable;
    }

    @Override
    public void setIsTranslatable(boolean value) {
        this.isTranslatable = value;
    }

    @Override
    public boolean preserveWhitespaces() {
        return this.preserveWS;
    }

    @Override
    public void setPreserveWhitespaces(boolean value) {
        this.preserveWS = value;
    }

    @Override
    public void setSkeleton(ISkeleton skeleton) {
        if (skeleton != null) {
            skeleton.setParent(this);
        }
        super.setSkeleton(skeleton);
    }

    @Override
    public boolean isReferent() {
        return this.refCount > 0;
    }

    @Override
    public void setIsReferent(boolean value) {
        this.refCount = value ? 1 : 0;
    }

    @Override
    public int getReferenceCount() {
        return this.refCount;
    }

    @Override
    public void setReferenceCount(int value) {
        this.refCount = value;
    }

    @Override
    public String toString() {
        return this.getSource().toString();
    }

    @Override
    public TextUnit clone() {
        TextUnit tu = new TextUnit(this.getId());
        tu.setIsReferent(this.isReferent());
        tu.setIsTranslatable(this.isTranslatable);
        tu.setMimeType(this.getMimeType());
        tu.setName(this.getName());
        tu.setPreserveWhitespaces(this.preserveWS);
        tu.setReferenceCount(this.getReferenceCount());
        tu.setSource(this.getSource().clone());
        tu.setType(this.getType());
        for (Map.Entry<LocaleId, TextContainer> entry : this.targets.entrySet()) {
            tu.setTarget(entry.getKey(), entry.getValue().clone());
        }
        IWithProperties.copy(this, tu);
        IWithTargetProperties.copy(this, tu);
        IWithSourceProperties.copy(this, tu);
        IWithAnnotations.copy(this, tu);
        if (this.getSkeleton() != null) {
            ISkeleton skel = this.getSkeleton().clone();
            tu.setSkeleton(skel);
        }
        return tu;
    }

    @Override
    public void removeAllSegmentations() {
        if (this.getSource().hasBeenSegmented()) {
            this.getSource().joinAll();
        }
        for (Map.Entry<LocaleId, TextContainer> entry : this.targets.entrySet()) {
            if (!entry.getValue().hasBeenSegmented()) continue;
            entry.getValue().joinAll();
        }
    }

    @Override
    public void createSourceSegmentation(ISegmenter segmenter) {
        segmenter.computeSegments(this.getSource());
        this.getSource().getSegments().create(segmenter.getRanges());
    }

    @Override
    public void createTargetSegmentation(ISegmenter segmenter, LocaleId targetLocale) {
        TextContainer tc = this.getTarget(targetLocale);
        if (tc == null) {
            throw new OkapiException(String.format("There is no target content for '%s'", targetLocale.toString()));
        }
        segmenter.computeSegments(tc);
        tc.getSegments().create(segmenter.getRanges());
    }

    @Override
    public Property getSourceProperty(String name) {
        return this.getSource().getProperty(name);
    }

    @Override
    public Property setSourceProperty(Property property) {
        return this.getSource().setProperty(property);
    }

    @Override
    public void removeSourceProperty(String name) {
        this.getSource().removeProperty(name);
    }

    @Override
    public Set<String> getSourcePropertyNames() {
        return this.getSource().getPropertyNames();
    }

    @Override
    public boolean hasSourceProperty(String name) {
        return this.getSource().hasProperty(name);
    }

    @Override
    public Property getTargetProperty(LocaleId locId, String name) {
        if (!this.hasTarget(locId)) {
            return null;
        }
        return this.getTarget(locId).getProperty(name);
    }

    @Override
    public Property setTargetProperty(LocaleId locId, Property property) {
        return this.createTarget(locId, false, 4).setProperty(property);
    }

    @Override
    public void removeTargetProperty(LocaleId locId, String name) {
        if (this.hasTarget(locId)) {
            this.getTarget(locId).removeProperty(name);
        }
    }

    @Override
    public Set<String> getTargetPropertyNames(LocaleId locId) {
        if (this.hasTarget(locId)) {
            return this.getTarget(locId).getPropertyNames();
        }
        return Collections.emptySet();
    }

    @Override
    public boolean hasTargetProperty(LocaleId locId, String name) {
        TextContainer tc = this.getTarget(locId);
        if (tc == null) {
            return false;
        }
        return tc.getProperty(name) != null;
    }

    @Override
    public Map<String, Property> getSourceProperties() {
        return this.getSource().getProperties();
    }

    @Override
    public Property createTargetProperty(LocaleId locId, String name, boolean overwriteExisting, int creationOptions) {
        TextContainer tc = this.createTarget(locId, false, 0);
        Property prop = tc.getProperty(name);
        if (prop == null || overwriteExisting) {
            prop = this.getSource().getProperty(name);
            if (prop == null) {
                return tc.setProperty(new Property(name, "", false));
            }
            if (creationOptions == 0) {
                return tc.setProperty(new Property(name, "", prop.isReadOnly()));
            }
            return tc.setProperty(prop.clone());
        }
        return prop;
    }
}

