/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.Map;
import java.util.Set;
import net.sf.okapi.common.resource.Property;

public interface IWithSourceProperties {
    public static void copy(IWithSourceProperties from, IWithSourceProperties to) {
        if (from == null || to == null) {
            return;
        }
        for (String propName : from.getSourcePropertyNames()) {
            if (to.hasSourceProperty(propName)) continue;
            to.setSourceProperty(from.getSourceProperty(propName).clone());
        }
    }

    public Map<String, Property> getSourceProperties();

    default public Property getSourceProperty(String name) {
        return this.getSourceProperties().get(name);
    }

    default public Set<String> getSourcePropertyNames() {
        return this.getSourceProperties().keySet();
    }

    default public boolean hasSourceProperty(String name) {
        return this.getSourceProperties().containsKey(name);
    }

    default public void removeSourceProperty(String name) {
        this.getSourceProperties().remove(name);
    }

    default public Property setSourceProperty(Property property) {
        this.getSourceProperties().put(property.getName(), property);
        return property;
    }
}

