/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipelinebuilder;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.pipelinebuilder.XDocument;
import net.sf.okapi.common.pipelinedriver.BatchItemContext;
import net.sf.okapi.common.pipelinedriver.DocumentData;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;
import net.sf.okapi.common.resource.RawDocument;

public class XBatchItem {
    private BatchItemContext bic = new BatchItemContext();

    public XBatchItem(XDocument ... documents) {
        for (XDocument document : documents) {
            this.addDocument(document);
        }
    }

    private void addDocument(XDocument document) {
        if (document == null) {
            return;
        }
        this.bic.add(document.getDocumentData());
    }

    public XBatchItem(URI inputURI, String defaultEncoding, String filterConfigId, URI outputURI, String outputEncoding, LocaleId sourceLocale, LocaleId targetLocale) {
        this.addDocument(new XDocument(inputURI, defaultEncoding, filterConfigId, outputURI, outputEncoding, sourceLocale, targetLocale));
    }

    public XBatchItem(RawDocument rawDocument) {
        this.addDocument(new XDocument(rawDocument));
    }

    public XBatchItem(DocumentData documentData) {
        this.addDocument(new XDocument(documentData));
    }

    public XBatchItem(RawDocument rawDoc, URI outputURI, String outputEncoding) {
        this.addDocument(new XDocument(rawDoc, outputURI, outputEncoding));
    }

    public XBatchItem(CharSequence inputCharSequence, LocaleId sourceLocale) {
        this.addDocument(new XDocument(inputCharSequence, sourceLocale));
    }

    public XBatchItem(URI inputURI, String defaultEncoding, LocaleId sourceLocale) {
        this.addDocument(new XDocument(inputURI, defaultEncoding, sourceLocale));
    }

    public XBatchItem(URI inputURI, String defaultEncoding, URI outputURI, String outputEncoding, LocaleId sourceLocale, LocaleId targetLocale) {
        this.addDocument(new XDocument(inputURI, defaultEncoding, outputURI, outputEncoding, sourceLocale, targetLocale));
    }

    public XBatchItem(URI inputURI, String defaultEncoding, LocaleId sourceLocale, LocaleId targetLocale) {
        this.addDocument(new XDocument(inputURI, defaultEncoding, sourceLocale, targetLocale));
    }

    public XBatchItem(URL inputURL, String defaultEncoding, LocaleId sourceLocale) {
        this.addDocument(new XDocument(inputURL, defaultEncoding, sourceLocale));
    }

    public XBatchItem(URL inputURL, String defaultEncoding, LocaleId sourceLocale, LocaleId targetLocale) {
        this.addDocument(new XDocument(inputURL, defaultEncoding, sourceLocale, targetLocale));
    }

    public XBatchItem(URL inputURL, String defaultEncoding, URL outputURL, String outputEncoding, LocaleId sourceLocale, LocaleId targetLocale) {
        this.addDocument(new XDocument(inputURL, defaultEncoding, outputURL, outputEncoding, sourceLocale, targetLocale));
    }

    public XBatchItem(URL inputURL, String defaultEncoding, String outputPath, String outputEncoding, LocaleId sourceLocale, LocaleId targetLocale) {
        this.addDocument(new XDocument(inputURL, defaultEncoding, outputPath, outputEncoding, sourceLocale, targetLocale));
    }

    public XBatchItem(InputStream inputStream, String defaultEncoding, LocaleId sourceLocale) {
        this.addDocument(new XDocument(inputStream, defaultEncoding, sourceLocale));
    }

    public XBatchItem(InputStream inputStream, String defaultEncoding, String outputPath, String outputEncoding, LocaleId sourceLocale, LocaleId targetLocale) {
        this.addDocument(new XDocument(inputStream, defaultEncoding, outputPath, outputEncoding, sourceLocale, targetLocale));
    }

    public XBatchItem(InputStream inputStream, String defaultEncoding, LocaleId sourceLocale, LocaleId targetLocale) {
        this.addDocument(new XDocument(inputStream, defaultEncoding, sourceLocale, targetLocale));
    }

    public IBatchItemContext getContext() {
        return this.bic;
    }
}

