/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffsplitter;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

@EditorFor(value=XliffWCSplitterParameters.class)
public class XliffWCSplitterParameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String THRESHOLD = "threshold";

    public XliffWCSplitterParameters() {
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.setThreshold(200000);
    }

    public int getThreshold() {
        return this.getInteger(THRESHOLD);
    }

    public void setThreshold(int threshold) {
        this.setInteger(THRESHOLD, threshold);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(THRESHOLD, "Maximum word-count per part:", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("XLIFF Word-Count Splitter", true, false);
        TextInputPart ip = desc.addTextInputPart(paramsDesc.get(THRESHOLD));
        ip.setAllowEmpty(false);
        ip.setRange(1, 1000000);
        ip.setVertical(false);
        return desc;
    }
}

