/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount;

import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.RuleBasedBreakIterator;
import com.ibm.icu.util.ULocale;
import java.util.Locale;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.steps.wordcount.common.Metrics;
import net.sf.okapi.steps.wordcount.common.MetricsAnnotation;

public class SimpleWordCountStep
extends BasePipelineStep {
    private RuleBasedBreakIterator srcWordIterator = null;
    private LocaleId srcLoc;
    private long srcBatchItemWordCount;
    private long srcBatchWordCount;

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.srcLoc = sourceLocale;
        this.srcWordIterator = (RuleBasedBreakIterator)BreakIterator.getWordInstance((ULocale)ULocale.createCanonical((String)this.srcLoc.toString()));
        RuleBasedBreakIterator.registerInstance((BreakIterator)this.srcWordIterator, (Locale)this.srcLoc.toJavaLocale(), (int)1);
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.srcBatchWordCount = 0L;
        return super.handleStartBatch(event);
    }

    @Override
    protected Event handleStartBatchItem(Event event) {
        this.srcBatchItemWordCount = 0L;
        return super.handleStartBatchItem(event);
    }

    @Override
    protected Event handleEndBatchItem(Event event) {
        MetricsAnnotation sma;
        Ending res = event.getEnding();
        if (res == null) {
            res = new Ending("");
            event.setResource(res);
        }
        if ((sma = res.getAnnotation(MetricsAnnotation.class)) == null) {
            sma = new MetricsAnnotation();
            res.setAnnotation(sma);
        }
        Metrics m = sma.getMetrics();
        m.setMetric("TotalWordCount", this.srcBatchItemWordCount);
        this.srcBatchWordCount += this.srcBatchItemWordCount;
        return super.handleEndBatchItem(event);
    }

    @Override
    protected Event handleEndBatch(Event event) {
        MetricsAnnotation sma;
        Ending res = event.getEnding();
        if (res == null) {
            res = new Ending("");
            event.setResource(res);
        }
        if ((sma = res.getAnnotation(MetricsAnnotation.class)) == null) {
            sma = new MetricsAnnotation();
            res.setAnnotation(sma);
        }
        Metrics m = sma.getMetrics();
        m.setMetric("TotalWordCount", this.srcBatchWordCount);
        return super.handleEndBatch(event);
    }

    @Override
    protected Event handleTextUnit(Event event) {
        MetricsAnnotation sma;
        ITextUnit tu = event.getTextUnit();
        long srcWordCount = 0L;
        if (tu.isEmpty() || !tu.isTranslatable()) {
            return event;
        }
        if (!tu.getSource().isEmpty()) {
            srcWordCount = this.countWords(tu.getSource().getUnSegmentedContentCopy().getText());
            this.srcBatchItemWordCount += srcWordCount;
        }
        if ((sma = tu.getSource().getAnnotation(MetricsAnnotation.class)) == null) {
            sma = new MetricsAnnotation();
            tu.getSource().setAnnotation(sma);
        }
        Metrics m = sma.getMetrics();
        m.setMetric("TotalWordCount", srcWordCount);
        return event;
    }

    @Override
    public String getName() {
        return "Simple Word Count";
    }

    @Override
    public String getDescription() {
        return "Annotates each text unit source with a total word count and gives total source word counts for batches Expects: filter events. Sends back: filter events.";
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public void setParameters(IParameters params) {
    }

    private long countWords(String text) {
        long totalWordCount = 0L;
        if (Util.isEmpty(text)) {
            return totalWordCount;
        }
        RuleBasedBreakIterator wordIterator = this.srcWordIterator;
        wordIterator.setText(text);
        int current = wordIterator.next();
        while (current != -1) {
            if (wordIterator.getRuleStatus() != 0) {
                ++totalWordCount;
            }
            current = wordIterator.next();
        }
        return totalWordCount;
    }
}

