/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.qualitycheck;

import java.io.File;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiEditorCreationException;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.lib.verification.IQualityCheckEditor;
import net.sf.okapi.lib.verification.Parameters;
import net.sf.okapi.lib.verification.QualityCheckSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class QualityCheckStep
extends BasePipelineStep {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private QualityCheckSession session = new QualityCheckSession();
    private IQualityCheckEditor editor;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private boolean isDone;
    private boolean initDone;
    private String rootDir;
    private IFilterConfigurationMapper fcMapper;
    private boolean RawDocumentMode;
    private Object uiParent;

    @Override
    public String getName() {
        return "Quality Check";
    }

    @Override
    public String getDescription() {
        return "Compare source and target for quality. Expects: filter events or raw documents. Sends back: filter events or raw document.";
    }

    @Override
    public Parameters getParameters() {
        return this.session.getParameters();
    }

    @Override
    public void setParameters(IParameters params) {
        this.session.setParameters((Parameters)params);
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @StepParameterMapping(parameterType=StepParameterType.UI_PARENT)
    public void setUIParent(Object uiParent) {
        this.uiParent = uiParent;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.isDone = true;
        this.initDone = false;
        return event;
    }

    @Override
    protected Event handleStartBatchItem(Event event) {
        this.isDone = false;
        return event;
    }

    @Override
    protected Event handleRawDocument(Event event) {
        this.RawDocumentMode = true;
        if (this.editor == null) {
            try {
                this.editor = (IQualityCheckEditor)Class.forName("net.sf.okapi.lib.ui.verification.QualityCheckEditor").newInstance();
                this.editor.initialize(this.uiParent, true, null, this.fcMapper, this.session);
            }
            catch (Throwable e) {
                throw new OkapiEditorCreationException("Could not create an instance of IQualityCheckEditor.\n" + e.getMessage(), e);
            }
        }
        this.editor.addRawDocument(event.getRawDocument());
        this.isDone = true;
        return event;
    }

    @Override
    protected Event handleStartDocument(Event event) {
        this.RawDocumentMode = false;
        this.isDone = true;
        if (!this.initDone) {
            this.session.startProcess(this.sourceLocale, this.targetLocale);
            this.initDone = true;
        }
        this.session.processStartDocument((StartDocument)event.getResource(), null);
        return event;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        this.session.processTextUnit(event.getTextUnit());
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        if (this.RawDocumentMode) {
            this.editor.edit(true);
            this.editor = null;
        } else {
            this.session.generateReport(this.rootDir);
            String finalPath = Util.fillRootDirectoryVariable(this.session.getParameters().getOutputPath(), this.rootDir);
            if (this.session.getParameters().getSaveSession()) {
                String sessionPath = Util.fillRootDirectoryVariable(this.session.getParameters().getSessionPath(), this.rootDir);
                this.session.saveSession(sessionPath);
            }
            this.LOGGER.info("\nOutput: {}", (Object)finalPath);
            int count = this.session.getIssues().size();
            if (count == 0) {
                this.LOGGER.info("No issue found.");
            } else {
                this.LOGGER.warn("Number of issues found = {}", (Object)count);
            }
            if (this.session.getParameters().getAutoOpen()) {
                Util.openURL(new File(finalPath).getAbsolutePath());
            }
        }
        return event;
    }
}

