/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.PowerpointStyleDefinitions;
import net.sf.okapi.filters.openxml.PowerpointStyleDefinitionsReader;
import net.sf.okapi.filters.openxml.StyleDefinitions;

interface TextStyleDefinitions {
    public static final String TX_STYLES = "txStyles";
    public static final String OTHER = "other";

    public StyleDefinitions styleFor(String var1);

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public static final class Default
    implements TextStyleDefinitions {
        private final StartElement startElement;
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private StyleDefinitions title;
        private StyleDefinitions body;
        private StyleDefinitions other;

        Default(StartElement startElement, ConditionalParameters conditionalParameters, XMLEventFactory eventFactory) {
            this.startElement = startElement;
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
        }

        @Override
        public StyleDefinitions styleFor(String type) {
            switch (type) {
                case "title": 
                case "ctrTitle": {
                    return null == this.title ? new StyleDefinitions.Empty() : this.title;
                }
                case "subTitle": 
                case "body": {
                    return null == this.body ? new StyleDefinitions.Empty() : this.body;
                }
            }
            return null == this.other ? new StyleDefinitions.Empty() : this.other;
        }

        @Override
        public void readWith(XMLEventReader eventReader) throws XMLStreamException {
            XMLEvent e;
            while (!(!eventReader.hasNext() || (e = eventReader.nextEvent()).isEndElement() && e.asEndElement().getName().equals(this.startElement.getName()))) {
                if (!e.isStartElement()) continue;
                StartElement se = e.asStartElement();
                if ("titleStyle".equals(se.getName().getLocalPart())) {
                    this.title = this.textStyleDefinitions(se, eventReader);
                    continue;
                }
                if ("bodyStyle".equals(se.getName().getLocalPart())) {
                    this.body = this.textStyleDefinitions(se, eventReader);
                    continue;
                }
                if (!"otherStyle".equals(se.getName().getLocalPart())) continue;
                this.other = this.textStyleDefinitions(se, eventReader);
            }
        }

        private StyleDefinitions textStyleDefinitions(StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
            PowerpointStyleDefinitions styleDefinitions = new PowerpointStyleDefinitions(this.eventFactory);
            styleDefinitions.readWith(new PowerpointStyleDefinitionsReader(this.conditionalParameters, this.eventFactory, eventReader, startElement, startElement.getName().getLocalPart()));
            return styleDefinitions;
        }
    }

    public static final class Empty
    implements TextStyleDefinitions {
        @Override
        public StyleDefinitions styleFor(String type) {
            return new StyleDefinitions.Empty();
        }

        @Override
        public void readWith(XMLEventReader eventReader) throws XMLStreamException {
        }
    }
}

