/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import net.sf.okapi.filters.openxml.ConditionalParameters;

interface StrippableAttributes {
    public StartElement strip(StartElement var1);

    public static interface Name {
        public String value();

        public static enum Revision implements Name
        {
            RPR("rsidRPr"),
            DEL("rsidDel"),
            R("rsidR"),
            SECT("rsidSect"),
            P("rsidP"),
            R_DEFAULT("rsidRDefault"),
            TR("rsidTr");

            private final String value;

            private Revision(String value) {
                this.value = value;
            }

            @Override
            public String value() {
                return this.value;
            }
        }

        public static enum General implements Name
        {
            SPELLING_ERROR("err"),
            NO_PROOFING("noProof"),
            DIRTY("dirty"),
            SMART_TAG_CLEAN("smtClean"),
            LANG("lang"),
            ALT_LANG("altLang"),
            SPACING("spc");

            private final String value;

            private General(String value) {
                this.value = value;
            }

            @Override
            public String value() {
                return this.value;
            }
        }
    }

    public static final class SectionPropertiesRevisions
    implements StrippableAttributes {
        private final Default defaultStrippableAttributes;

        SectionPropertiesRevisions(XMLEventFactory eventFactory) {
            this(new Default(eventFactory));
        }

        SectionPropertiesRevisions(Default defaultStrippableAttributes) {
            this.defaultStrippableAttributes = defaultStrippableAttributes;
            this.defaultStrippableAttributes.names.addAll(Stream.of(Name.Revision.RPR.value(), Name.Revision.DEL.value(), Name.Revision.R.value(), Name.Revision.SECT.value()).collect(Collectors.toSet()));
        }

        @Override
        public StartElement strip(StartElement startElement) {
            return this.defaultStrippableAttributes.strip(startElement);
        }
    }

    public static final class TableRowRevisions
    implements StrippableAttributes {
        private final Default defaultStrippableAttributes;

        TableRowRevisions(XMLEventFactory eventFactory) {
            this(new Default(eventFactory));
        }

        TableRowRevisions(Default defaultStrippableAttributes) {
            this.defaultStrippableAttributes = defaultStrippableAttributes;
            this.defaultStrippableAttributes.names.addAll(Stream.of(Name.Revision.RPR.value(), Name.Revision.DEL.value(), Name.Revision.R.value(), Name.Revision.TR.value()).collect(Collectors.toSet()));
        }

        @Override
        public StartElement strip(StartElement startElement) {
            return this.defaultStrippableAttributes.strip(startElement);
        }
    }

    public static final class RunRevisions
    implements StrippableAttributes {
        private final Default defaultStrippableAttributes;

        RunRevisions(XMLEventFactory eventFactory) {
            this(new Default(eventFactory));
        }

        RunRevisions(Default defaultStrippableAttributes) {
            this.defaultStrippableAttributes = defaultStrippableAttributes;
            this.defaultStrippableAttributes.names.addAll(Stream.of(Name.Revision.RPR.value(), Name.Revision.DEL.value(), Name.Revision.R.value()).collect(Collectors.toSet()));
        }

        @Override
        public StartElement strip(StartElement startElement) {
            return this.defaultStrippableAttributes.strip(startElement);
        }
    }

    public static final class ParagraphRevisions
    implements StrippableAttributes {
        private final Default defaultStrippableAttributes;

        ParagraphRevisions(XMLEventFactory eventFactory) {
            this(new Default(eventFactory));
        }

        ParagraphRevisions(Default defaultStrippableAttributes) {
            this.defaultStrippableAttributes = defaultStrippableAttributes;
            this.defaultStrippableAttributes.names.addAll(Stream.of(Name.Revision.RPR.value(), Name.Revision.DEL.value(), Name.Revision.R.value(), Name.Revision.P.value(), Name.Revision.R_DEFAULT.value()).collect(Collectors.toSet()));
        }

        @Override
        public StartElement strip(StartElement startElement) {
            return this.defaultStrippableAttributes.strip(startElement);
        }
    }

    public static final class General
    implements StrippableAttributes {
        private final Default defaultStrippableAttributes;

        General(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory) {
            this(new Default(eventFactory), conditionalParameters);
        }

        General(Default defaultStrippableAttributes, ConditionalParameters conditionalParameters) {
            this.defaultStrippableAttributes = defaultStrippableAttributes;
            Stream<String> unconditional = Stream.of(Name.General.SPELLING_ERROR.value(), Name.General.NO_PROOFING.value(), Name.General.DIRTY.value(), Name.General.SMART_TAG_CLEAN.value(), Name.General.LANG.value(), Name.General.ALT_LANG.value());
            Stream<String> merged = conditionalParameters.getCleanupAggressively() ? Stream.concat(unconditional, Stream.of(Name.General.SPACING.value())) : unconditional;
            this.defaultStrippableAttributes.names.addAll(merged.collect(Collectors.toSet()));
        }

        @Override
        public StartElement strip(StartElement startElement) {
            return this.defaultStrippableAttributes.strip(startElement);
        }
    }

    public static final class Default
    implements StrippableAttributes {
        private final Set<String> names;
        private final XMLEventFactory eventFactory;

        Default(XMLEventFactory eventFactory) {
            this(new HashSet<String>(), eventFactory);
        }

        Default(Set<String> names, XMLEventFactory eventFactory) {
            this.names = names;
            this.eventFactory = eventFactory;
        }

        @Override
        public StartElement strip(StartElement startElement) {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            Iterator<Attribute> currentAttributesIterator = startElement.getAttributes();
            while (currentAttributesIterator.hasNext()) {
                Attribute attribute = currentAttributesIterator.next();
                if (this.names.contains(attribute.getName().getLocalPart())) continue;
                attributes.add(attribute);
            }
            return this.eventFactory.createStartElement(startElement.getName(), attributes.iterator(), startElement.getNamespaces());
        }
    }
}

