/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.PowerpointStyleDefinitions;
import net.sf.okapi.filters.openxml.PowerpointStyleDefinitionsReader;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.StyleDefinitions;

interface PresentationFragments {
    public List<String> slideMasterNames();

    public List<String> notesMasterNames();

    public List<String> slideNames();

    public StyleDefinitions defaultTextStyle();

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public static class Default
    implements PresentationFragments {
        private static final String PRESENTATION = "presentation";
        private static final String SLIDE_MASTER_ID = "sldMasterId";
        private static final String NOTES_MASTER_ID = "notesMasterId";
        private static final String SLIDE_ID = "sldId";
        private static final String ID = "id";
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final Relationships relationships;
        private final List<String> slideMasterNames;
        private final List<String> notesMasterNames;
        private final List<String> slideNames;
        private StyleDefinitions defaultTextStyle;
        private QName slideMasterId;
        private QName notesMasterId;
        private QName slideId;
        private QName id;

        Default(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, Relationships relationships) {
            this(conditionalParameters, eventFactory, relationships, new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>());
        }

        Default(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, Relationships relationships, List<String> slideMasterNames, List<String> notesMasterNames, List<String> slideNames) {
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.relationships = relationships;
            this.slideMasterNames = slideMasterNames;
            this.notesMasterNames = notesMasterNames;
            this.slideNames = slideNames;
        }

        @Override
        public List<String> slideMasterNames() {
            return this.slideMasterNames;
        }

        @Override
        public List<String> notesMasterNames() {
            return this.notesMasterNames;
        }

        @Override
        public List<String> slideNames() {
            return this.slideNames;
        }

        @Override
        public StyleDefinitions defaultTextStyle() {
            return null == this.defaultTextStyle ? new StyleDefinitions.Empty() : this.defaultTextStyle;
        }

        @Override
        public void readWith(XMLEventReader eventReader) throws XMLStreamException {
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                if (!e.isStartElement()) continue;
                StartElement el = e.asStartElement();
                if (PRESENTATION.equals(el.getName().getLocalPart())) {
                    this.qualifyNames(el);
                    continue;
                }
                if (el.getName().equals(this.slideMasterId)) {
                    this.addRelationshipTargetFor(el, this.slideMasterNames);
                    continue;
                }
                if (el.getName().equals(this.notesMasterId)) {
                    this.addRelationshipTargetFor(el, this.notesMasterNames);
                    continue;
                }
                if (el.getName().equals(this.slideId)) {
                    this.addRelationshipTargetFor(el, this.slideNames);
                    continue;
                }
                if (!"defaultTextStyle".equals(el.getName().getLocalPart())) continue;
                this.defaultTextStyle = new PowerpointStyleDefinitions(this.eventFactory);
                this.defaultTextStyle.readWith(new PowerpointStyleDefinitionsReader(this.conditionalParameters, this.eventFactory, eventReader, el, el.getName().getLocalPart()));
            }
        }

        private void qualifyNames(StartElement startElement) {
            this.slideMasterId = new QName(startElement.getNamespaceURI("p"), SLIDE_MASTER_ID, "p");
            this.notesMasterId = new QName(startElement.getNamespaceURI("p"), NOTES_MASTER_ID, "p");
            this.slideId = new QName(startElement.getNamespaceURI("p"), SLIDE_ID, "p");
            this.id = new QName(startElement.getNamespaceURI("r"), ID, "r");
        }

        private void addRelationshipTargetFor(StartElement startElement, List<String> names) {
            Attribute id = startElement.getAttributeByName(this.id);
            if (id != null) {
                names.add(this.relationshipTargetFor(id.getValue()));
            }
        }

        private String relationshipTargetFor(String id) {
            Relationships.Rel rel = this.relationships.getRelById(id);
            if (rel == null) {
                throw new IllegalStateException("A non-existent relationship is requested: " + id);
            }
            return rel.target;
        }
    }
}

