/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.sf.okapi.filters.openxml.BlockProperties;
import net.sf.okapi.filters.openxml.BlockProperty;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponentParser;
import net.sf.okapi.filters.openxml.ParagraphBlockProperties;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.SkippableElements;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StrippableAttributes;
import net.sf.okapi.filters.openxml.StyleDefinition;

interface PowerpointStyleDefinition
extends StyleDefinition {
    public static final String DEF_PPR = "defPPr";
    public static final Set<String> PARAGRAPH_LEVELS = new HashSet<String>(Arrays.asList("lvl1pPr", "lvl2pPr", "lvl3pPr", "lvl4pPr", "lvl5pPr", "lvl6pPr", "lvl7pPr", "lvl8pPr", "lvl9pPr"));
    public static final String EMPTY = "";

    public String id();

    public PowerpointStyleDefinition mergedWith(PowerpointStyleDefinition var1);

    public static class ParagraphLevel
    implements PowerpointStyleDefinition {
        private static final int ID_BEGIN_INDEX = 3;
        private static final int ID_END_INDEX = 4;
        private final ParagraphDefault paragraphDefault;
        private String id;

        ParagraphLevel(ParagraphDefault paragraphDefault) {
            this.paragraphDefault = paragraphDefault;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public PowerpointStyleDefinition mergedWith(PowerpointStyleDefinition other) {
            if (!(other instanceof ParagraphLevel)) {
                throw new IllegalArgumentException("The provided argument is illegal: ".concat(other.getClass().getSimpleName()));
            }
            ParagraphLevel that = (ParagraphLevel)other;
            if (!this.id().equals(that.id())) {
                throw new IllegalArgumentException("The provided paragraph level ID does not match with the available one: ".concat(that.id()).concat(" instead of ").concat(this.id()));
            }
            ParagraphLevel merged = new ParagraphLevel((ParagraphDefault)this.paragraphDefault.mergedWith(that.paragraphDefault));
            merged.id = this.id;
            return merged;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            this.id = this.readId();
            this.paragraphDefault.readWith(reader);
        }

        private String readId() {
            return this.paragraphDefault.startElement.getName().getLocalPart().substring(3, 4);
        }

        @Override
        public RunProperties runProperties() {
            return this.paragraphDefault.runProperties();
        }

        @Override
        public Markup toMarkup() {
            return this.paragraphDefault.toMarkup();
        }
    }

    public static class ParagraphDefault
    implements PowerpointStyleDefinition {
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final StartElement startElement;
        private ParagraphBlockProperties paragraphProperties;
        private RunProperties defaultRunProperties;

        ParagraphDefault(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, StartElement startElement) {
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.startElement = startElement;
        }

        @Override
        public String id() {
            return PowerpointStyleDefinition.EMPTY;
        }

        @Override
        public PowerpointStyleDefinition mergedWith(PowerpointStyleDefinition other) {
            if (other instanceof Empty) {
                return this;
            }
            if (!(other instanceof ParagraphDefault)) {
                throw new IllegalArgumentException("The provided argument is illegal: ".concat(other.getClass().getSimpleName()));
            }
            ParagraphDefault that = (ParagraphDefault)other;
            ParagraphDefault merged = new ParagraphDefault(this.conditionalParameters, this.eventFactory, this.startElement);
            merged.paragraphProperties = this.paragraphProperties.mergedWith(that.paragraphProperties);
            merged.defaultRunProperties = this.defaultRunProperties.mergedWith(that.defaultRunProperties);
            return merged;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            StrippableAttributes.General strippableAttributes = new StrippableAttributes.General(this.conditionalParameters, this.eventFactory);
            this.paragraphProperties = new MarkupComponentParser().parseParagraphBlockProperties(StartElementContextFactory.createStartElementContext(this.startElement, reader, this.eventFactory, this.conditionalParameters), strippableAttributes, new SkippableElements.Empty());
            ListIterator<BlockProperty> iterator = this.paragraphProperties.properties().listIterator();
            while (iterator.hasNext()) {
                BlockProperty blockProperty = iterator.next();
                if (!"defRPr".equals(blockProperty.getName().getLocalPart())) continue;
                this.defaultRunProperties = blockProperty.asRunProperties();
                if (this.defaultRunProperties.getProperties().isEmpty()) {
                    this.defaultRunProperties = new RunProperties.Empty();
                    iterator.remove();
                    continue;
                }
                iterator.set(new BlockProperty(this.defaultRunProperties.getEvents(), this.conditionalParameters, this.eventFactory, strippableAttributes));
            }
            if (this.paragraphProperties.isEmpty()) {
                this.paragraphProperties = new ParagraphBlockProperties.Empty(new BlockProperties.Empty(this.paragraphProperties.startElement(), this.paragraphProperties.endElement()));
            }
            if (null == this.defaultRunProperties) {
                this.defaultRunProperties = new RunProperties.Empty();
            }
        }

        @Override
        public RunProperties runProperties() {
            return this.defaultRunProperties;
        }

        @Override
        public Markup toMarkup() {
            return new Markup.General(Collections.singletonList(this.paragraphProperties));
        }
    }

    public static class Empty
    implements PowerpointStyleDefinition {
        @Override
        public String id() {
            return PowerpointStyleDefinition.EMPTY;
        }

        @Override
        public PowerpointStyleDefinition mergedWith(PowerpointStyleDefinition other) {
            return other;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
        }

        @Override
        public RunProperties runProperties() {
            return new RunProperties.Empty();
        }

        @Override
        public Markup toMarkup() {
            return new Markup.Empty();
        }
    }
}

