/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ListIterator;
import net.sf.okapi.filters.openxml.BlockPropertiesClarifier;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentClarifier;
import net.sf.okapi.filters.openxml.StylesClarifier;

class MarkupClarifier {
    private final MarkupComponentClarifier.SheetViewClarifier sheetViewClarifier;
    private final MarkupComponentClarifier.AlignmentClarifier alignmentClarifier;
    private final MarkupComponentClarifier.PresentationClarifier presentationClarifier;
    private final BlockPropertiesClarifier.TablePropertiesClarifier tablePropertiesClarifier;
    private final BlockPropertiesClarifier.TextBodyPropertiesClarifier textBodyPropertiesClarifier;
    private final BlockPropertiesClarifier.ParagraphPropertiesClarifier paragraphPropertiesClarifier;
    private final StylesClarifier wordStylesClarifier;

    MarkupClarifier(MarkupComponentClarifier.SheetViewClarifier sheetViewClarifier, MarkupComponentClarifier.AlignmentClarifier alignmentClarifier, MarkupComponentClarifier.PresentationClarifier presentationClarifier, BlockPropertiesClarifier.TablePropertiesClarifier tablePropertiesClarifier, BlockPropertiesClarifier.TextBodyPropertiesClarifier textBodyPropertiesClarifier, BlockPropertiesClarifier.ParagraphPropertiesClarifier paragraphPropertiesClarifier, StylesClarifier wordStylesClarifier) {
        this.sheetViewClarifier = sheetViewClarifier;
        this.alignmentClarifier = alignmentClarifier;
        this.presentationClarifier = presentationClarifier;
        this.tablePropertiesClarifier = tablePropertiesClarifier;
        this.textBodyPropertiesClarifier = textBodyPropertiesClarifier;
        this.paragraphPropertiesClarifier = paragraphPropertiesClarifier;
        this.wordStylesClarifier = wordStylesClarifier;
    }

    void clarify(Markup markup) {
        ListIterator<MarkupComponent> iterator = markup.components().listIterator();
        while (iterator.hasNext()) {
            MarkupComponent component = iterator.next();
            if (MarkupComponent.isSheetViewStart(component)) {
                this.sheetViewClarifier.clarify(component);
                continue;
            }
            if (MarkupComponent.isAlignmentEmptyElement(component)) {
                this.alignmentClarifier.clarify(component);
                continue;
            }
            if (MarkupComponent.isPresentationStart(component)) {
                this.presentationClarifier.clarify(component);
                continue;
            }
            if (MarkupComponent.isTableStart(component)) {
                this.tablePropertiesClarifier.clarifyWith(iterator);
                continue;
            }
            if (MarkupComponent.isTextBodyStart(component)) {
                this.textBodyPropertiesClarifier.clarifyWith(iterator);
                continue;
            }
            if (MarkupComponent.isParagraphStart(component)) {
                this.paragraphPropertiesClarifier.clarifyWith(iterator);
                continue;
            }
            if (!MarkupComponent.isWordStylesStart(component)) continue;
            this.wordStylesClarifier.clarifyWith(iterator);
        }
    }
}

