/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class ExcelWorkbook {
    private static final String WORKBOOK = "workbook";
    private static final String SHEET = "sheet";
    private static final QName SHEET_NAME = new QName("name");
    private static final QName SHEET_ID = new QName("sheetId");
    private static final QName SHEET_STATE = new QName("state");
    private static final String ID = "id";
    private QName sheet;
    private QName id;
    private List<Sheet> sheets = new ArrayList<Sheet>();

    ExcelWorkbook() {
    }

    List<Sheet> getSheets() {
        return this.sheets;
    }

    private void addSheet(String name, String id, String relId, boolean visible) {
        Sheet sheet = new Sheet();
        sheet.name = name;
        sheet.id = id;
        sheet.relId = relId;
        sheet.visible = visible;
        this.sheets.add(sheet);
    }

    ExcelWorkbook parseFrom(XMLEventReader reader, ConditionalParameters params) throws XMLStreamException {
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (!event.isStartElement()) continue;
            StartElement e = event.asStartElement();
            if (e.getName().getLocalPart().equals(WORKBOOK)) {
                this.qualifyNames(e);
                continue;
            }
            if (!e.getName().equals(this.sheet)) continue;
            if (null == this.id) {
                this.qualifyIdName(e);
            }
            String state = XMLEventHelpers.getAttributeValue(e, SHEET_STATE);
            boolean visible = params.getTranslateExcelHidden() || !"hidden".equals(state);
            this.addSheet(e.getAttributeByName(SHEET_NAME).getValue(), e.getAttributeByName(SHEET_ID).getValue(), e.getAttributeByName(this.id).getValue(), visible);
        }
        return this;
    }

    private void qualifyNames(StartElement startElement) {
        this.sheet = new QName(startElement.getName().getNamespaceURI(), SHEET, startElement.getName().getPrefix());
        this.qualifyIdName(startElement);
    }

    private void qualifyIdName(StartElement startElement) {
        String namespaceUri = startElement.getNamespaceURI("r");
        if (null == namespaceUri) {
            return;
        }
        this.id = new QName(namespaceUri, ID, "r");
    }

    static class Sheet {
        String name;
        String id;
        String relId;
        boolean visible;

        Sheet() {
        }

        String getName() {
            return this.name;
        }
    }
}

