/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.BlockSkippableElements;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ChunkContainer;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.MarkupComponentParser;
import net.sf.okapi.filters.openxml.ParagraphBlockProperties;
import net.sf.okapi.filters.openxml.Parser;
import net.sf.okapi.filters.openxml.RunBuilder;
import net.sf.okapi.filters.openxml.RunBuilderSkipper;
import net.sf.okapi.filters.openxml.RunContainer;
import net.sf.okapi.filters.openxml.RunMerger;
import net.sf.okapi.filters.openxml.RunParser;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunPropertiesParser;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.RunSkippableElements;
import net.sf.okapi.filters.openxml.SkippableElement;
import net.sf.okapi.filters.openxml.SkippableElements;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StrippableAttributes;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BlockParser
implements Parser<Block> {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String LOCAL_SIMPLE_FIELD = "fldSimple";
    private final StartElementContext startElementContext;
    private final IdGenerator nestedBlockIdGenerator;
    private final StyleDefinitions styleDefinitions;
    private final StyleOptimisation styleOptimisation;
    private final StrippableAttributes.General generalStrippableAttributes;
    private final StrippableAttributes.ParagraphRevisions paragraphRevisions;
    private final SkippableElements emptySkippableElements;
    private final SkippableElements defaultSkippableElements;
    private final SkippableElements blockPropertiesSkippableElements;
    private final BlockSkippableElements blockSkippableElements;
    private final RunBuilderSkipper runBuilderSkipper;
    private final Block.Builder builder;
    private final Queue<XMLEvent> deferredEvents;
    private String paragraphStyle;

    BlockParser(StartElementContext startElementContext, IdGenerator nestedBlockIdGenerator, StyleDefinitions styleDefinitions, StyleOptimisation styleOptimisation) {
        this.startElementContext = startElementContext;
        this.nestedBlockIdGenerator = nestedBlockIdGenerator;
        this.styleDefinitions = styleDefinitions;
        this.styleOptimisation = styleOptimisation;
        this.generalStrippableAttributes = new StrippableAttributes.General(startElementContext.getConditionalParameters(), startElementContext.getEventFactory());
        this.paragraphRevisions = new StrippableAttributes.ParagraphRevisions(startElementContext.getEventFactory());
        this.emptySkippableElements = new SkippableElements.Empty();
        this.defaultSkippableElements = new SkippableElements.Default(new SkippableElement[0]);
        this.blockPropertiesSkippableElements = new SkippableElements.RevisionProperty(new SkippableElements.Property(new SkippableElements.Default(SkippableElement.BlockProperty.BLOCK_PROPERTY_BIDI, SkippableElement.RunProperty.RUN_PROPERTY_RTL, SkippableElement.RunProperty.RUN_PROPERTY_LANGUAGE, SkippableElement.RunProperty.RUN_PROPERTY_NO_SPELLING_OR_GRAMMAR, SkippableElement.RevisionProperty.RUN_PROPERTY_INSERTED_PARAGRAPH_MARK, SkippableElement.RevisionProperty.RUN_PROPERTY_MOVED_PARAGRAPH_TO, SkippableElement.RevisionProperty.RUN_PROPERTY_MOVED_PARAGRAPH_FROM, SkippableElement.RevisionProperty.PARAGRAPH_PROPERTIES_CHANGE, SkippableElement.RevisionProperty.RUN_PROPERTIES_CHANGE), startElementContext.getConditionalParameters()), startElementContext.getConditionalParameters());
        this.blockSkippableElements = new BlockSkippableElements(startElementContext);
        this.runBuilderSkipper = new RunBuilderSkipper();
        this.builder = new Block.Builder();
        this.deferredEvents = new LinkedList<XMLEvent>();
    }

    private static boolean isSimpleFieldStartEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_SIMPLE_FIELD);
    }

    private void addRunsToBuilder(Block.Builder builder, RunMerger runMerger) throws XMLStreamException {
        for (Chunk chunk : runMerger.getRuns()) {
            builder.add(chunk);
        }
        runMerger.reset();
    }

    private void parseRunContainer(ChunkContainer chunkContainer, StartElement runContainerStart) throws XMLStreamException {
        RunContainer.Builder rcb = new RunContainer.Builder();
        RunMerger runMerger = new RunMerger();
        rcb.addType(RunContainer.Type.fromString(runContainerStart.getName().getLocalPart()));
        rcb.addToStartMarkup(MarkupComponentFactory.createStartMarkupComponent(this.startElementContext.getEventFactory(), runContainerStart));
        while (this.startElementContext.getEventReader().hasNext()) {
            XMLEvent e = this.startElementContext.getEventReader().nextEvent();
            if (e.isEndElement() && runContainerStart.getName().equals(e.asEndElement().getName())) {
                rcb.add(runMerger.getRuns());
                runMerger.reset();
                rcb.addToEndMarkup(MarkupComponentFactory.createEndMarkupComponent(e.asEndElement()));
                chunkContainer.add(rcb.build());
                return;
            }
            if (XMLEventHelpers.isRunStartEvent(e)) {
                this.processRun(runMerger, e.asStartElement());
                continue;
            }
            if (RunContainer.isStart(e)) {
                rcb.add(runMerger.getRuns());
                runMerger.reset();
                this.parseRunContainer(rcb, e.asStartElement());
                continue;
            }
            if (RunContainer.isPropertiesStart(e)) {
                rcb.addToStartMarkup(new MarkupComponentParser().parseBlockProperties(StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext), this.generalStrippableAttributes, this.emptySkippableElements));
                continue;
            }
            if (RunContainer.isContentStart(e)) {
                rcb.addToStartMarkup(MarkupComponentFactory.createStartMarkupComponent(this.startElementContext.getEventFactory(), e.asStartElement()));
                continue;
            }
            if (!RunContainer.isContentEnd(e)) continue;
            rcb.addToEndMarkup(MarkupComponentFactory.createEndMarkupComponent(e.asEndElement()));
        }
        throw new IllegalStateException("Invalid content? Unterminated run container");
    }

    @Override
    public Block parse() throws XMLStreamException {
        this.log("startBlock: " + this.startElementContext.getStartElement());
        this.builder.addToMarkup(MarkupComponentFactory.createStartMarkupComponent(this.startElementContext.getEventFactory(), this.paragraphRevisions.strip(this.startElementContext.getStartElement())));
        RunMerger runMerger = new RunMerger();
        while (this.startElementContext.getEventReader().hasNext()) {
            XMLEvent e = this.startElementContext.getEventReader().nextEvent();
            if (XMLEventHelpers.isParagraphPropertiesStartEvent(e)) {
                String textColor;
                String highlightColor;
                StartElementContext blockPropertiesElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext);
                ParagraphBlockProperties blockProperties = new MarkupComponentParser().parseParagraphBlockProperties(blockPropertiesElementContext, this.generalStrippableAttributes, this.blockPropertiesSkippableElements);
                if (!blockProperties.isEmpty()) {
                    if (blockProperties.containsRunPropertyDeletedParagraphMark()) {
                        this.builder.mergeable(true);
                    } else {
                        this.builder.addToMarkup(blockProperties);
                    }
                }
                this.paragraphStyle = blockProperties.paragraphStyle();
                runMerger.setParagraphStyle(this.paragraphStyle);
                if (this.paragraphStyle != null) {
                    if (this.startElementContext.getConditionalParameters().getTranslateWordInExcludeStyleMode()) {
                        this.builder.hidden(this.startElementContext.getConditionalParameters().isWordExcludedStyle(this.paragraphStyle));
                    } else {
                        this.builder.hidden(!this.startElementContext.getConditionalParameters().isWordExcludedStyle(this.paragraphStyle));
                    }
                }
                if ((highlightColor = blockProperties.highlightColor()) != null) {
                    if (this.startElementContext.getConditionalParameters().getTranslateWordInExcludeHighlightMode() && !this.builder.hidden()) {
                        this.builder.hidden(this.startElementContext.getConditionalParameters().isWordHighlightColor(highlightColor));
                    } else {
                        this.builder.hidden(!this.startElementContext.getConditionalParameters().isWordHighlightColor(highlightColor));
                    }
                }
                if ((textColor = blockProperties.textColor()) == null || !this.startElementContext.getConditionalParameters().getTranslateWordExcludeColors() || this.builder.hidden()) continue;
                this.builder.hidden(this.startElementContext.getConditionalParameters().isWordExcludedColor(textColor));
                continue;
            }
            if (XMLEventHelpers.isRunStartEvent(e)) {
                this.processRun(runMerger, e.asStartElement());
                if (this.deferredEvents.isEmpty() || !XMLEventHelpers.isParagraphEndEvent(this.deferredEvents.peek())) continue;
                this.addRunsToBuilder(this.builder, runMerger);
                this.builder.addToMarkup(MarkupComponentFactory.createEndMarkupComponent(this.deferredEvents.poll().asEndElement()));
                this.builder.addDeferredEvents(this.deferredEvents);
                this.builder.styleOptimisation(this.styleOptimisation);
                return this.builder.build();
            }
            if (this.startElementContext.getConditionalParameters().getAddLineSeparatorCharacter() && XMLEventHelpers.isLineBreakStartEvent(e) && runMerger.hasRunBuilder()) {
                runMerger.addToRunTextInRunBuilder(String.valueOf(this.startElementContext.getConditionalParameters().getLineSeparatorReplacement()));
                this.defaultSkippableElements.skip(StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext));
                continue;
            }
            if (RunContainer.isStart(e)) {
                StartElement runContainerStart = e.asStartElement();
                this.addRunsToBuilder(this.builder, runMerger);
                this.parseRunContainer(this.builder, runContainerStart);
                continue;
            }
            if (BlockParser.isSimpleFieldStartEvent(e)) {
                this.addRunsToBuilder(this.builder, runMerger);
                StartElementContext simpleFieldElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext);
                for (XMLEvent fldEvent : XMLEventHelpers.gatherEvents(simpleFieldElementContext)) {
                    this.builder.addToMarkup(fldEvent);
                }
                this.builder.flushMarkup();
                continue;
            }
            if (e.isStartElement() && "endParaRPr".equals(e.asStartElement().getName().getLocalPart())) {
                RunProperties endParaRunProperties = new RunPropertiesParser(StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext), new RunSkippableElements(this.startElementContext)).parse();
                this.addRunsToBuilder(this.builder, runMerger);
                if (this.builder.chunksEmpty()) {
                    this.builder.flushMarkup();
                }
                this.builder.addToMarkup(endParaRunProperties);
                continue;
            }
            if (this.blockSkippableElements.skip(e)) {
                if (!this.blockSkippableElements.isBorderCrossed()) continue;
                this.builder.skipped(true);
                this.builder.styleOptimisation(new StyleOptimisation.Bypass());
                return this.builder.build();
            }
            if (XMLEventHelpers.isWhitespace(e)) continue;
            this.addRunsToBuilder(this.builder, runMerger);
            if (e.isEndElement() && this.startElementContext.getStartElement().getName().equals(e.asEndElement().getName())) {
                this.log("End block: " + e);
                if (this.builder.chunksEmpty()) {
                    this.builder.flushMarkup();
                }
                this.builder.addToMarkup(MarkupComponentFactory.createEndMarkupComponent(e.asEndElement()));
                this.builder.styleOptimisation(this.styleOptimisation);
                return this.builder.build();
            }
            this.builder.addToMarkup(e);
        }
        throw new IllegalStateException("Invalid content? Unterminated paragraph");
    }

    private void processRun(RunMerger runMerger, StartElement startEl) throws XMLStreamException {
        StartElementContext runElementContext = StartElementContextFactory.createStartElementContext(startEl, this.startElementContext);
        RunBuilder runBuilder = new RunParser(runElementContext, this.nestedBlockIdGenerator, this.styleDefinitions, this.styleOptimisation, this.paragraphStyle, this.builder.hidden()).parse();
        this.deferredEvents.addAll(runBuilder.deferredEvents());
        if (this.runBuilderSkipper.canSkip(runBuilder)) {
            return;
        }
        this.clarifyVisibility(runBuilder);
        this.builder.runName(startEl.getName());
        this.builder.textName(runBuilder.getTextName());
        this.builder.mergeable(runBuilder.containsMergeableMarkup());
        runMerger.add(runBuilder);
    }

    private void clarifyVisibility(RunBuilder runBuilder) {
        if (this.startElementContext.getConditionalParameters().getTranslateWordHidden()) {
            return;
        }
        List<RunProperty> combinedRunProperties = this.styleDefinitions.combinedRunProperties(this.paragraphStyle, runBuilder.getRunStyle(), runBuilder.getRunProperties()).getProperties();
        for (RunProperty property : combinedRunProperties) {
            if (!XMLEventHelpers.WPML_PROPERTY_VANISH.getLocalPart().equals(property.getName().getLocalPart())) continue;
            if (property instanceof RunProperty.WpmlToggleRunProperty && !((RunProperty.WpmlToggleRunProperty)property).getToggleValue()) {
                return;
            }
            runBuilder.setHidden(true);
            return;
        }
    }

    private void log(String s) {
        this.LOGGER.debug(s);
    }
}

