/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;

interface ZipInput<T> {
    public T of(ZipEntry var1) throws IOException, XMLStreamException;

    public static class Reader
    implements ZipInput<XMLEventReader> {
        private final ZipInput<InputStream> zipInputStream;
        private final String encoding;
        private final XMLInputFactory inputFactory;

        Reader(ZipInput<InputStream> zipInputStream, String encoding, XMLInputFactory inputFactory) {
            this.zipInputStream = zipInputStream;
            this.encoding = encoding;
            this.inputFactory = inputFactory;
        }

        @Override
        public XMLEventReader of(ZipEntry entry) throws IOException, XMLStreamException {
            return this.inputFactory.createXMLEventReader(new InputStreamReader(this.zipInputStream.of(entry), this.encoding));
        }
    }

    public static class Stream
    implements ZipInput<InputStream> {
        private final ZipFile zipFile;

        Stream(ZipFile zipFile) {
            this.zipFile = zipFile;
        }

        @Override
        public InputStream of(ZipEntry entry) throws IOException, XMLStreamException {
            if (null == entry) {
                throw new IllegalArgumentException("The provided zip entry is null");
            }
            return new BufferedInputStream(this.zipFile.getInputStream(entry));
        }
    }
}

