/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.idml.MarkupRange;
import net.sf.okapi.filters.idml.Nameable;

interface Element
extends MarkupRange,
Nameable {
    public StartElement startElement();

    public List<XMLEvent> innerEvents();

    public void updateInnerEventsWith(List<XMLEvent> var1);

    public EndElement endElement();

    public static class Builder
    implements net.sf.okapi.filters.idml.Builder<Element> {
        protected StartElement startElement;
        protected List<XMLEvent> innerEvents = new ArrayList<XMLEvent>();
        protected EndElement endElement;
        protected XMLEventFactory eventFactory;

        Builder setStartElement(StartElement startElement) {
            this.startElement = startElement;
            return this;
        }

        Builder addInnerEvent(XMLEvent innerEvent) {
            this.innerEvents.add(innerEvent);
            return this;
        }

        Builder addInnerEvents(List<XMLEvent> innerEvents) {
            this.innerEvents.addAll(innerEvents);
            return this;
        }

        Builder setEndElement(EndElement endElement) {
            this.endElement = endElement;
            return this;
        }

        void setEventFactory(XMLEventFactory eventFactory) {
            this.eventFactory = eventFactory;
        }

        @Override
        public Element build() {
            return new Default(this.startElement, this.innerEvents, this.endElement, this.eventFactory);
        }
    }

    public static class Default
    implements Element {
        private final StartElement startElement;
        private final List<XMLEvent> innerEvents;
        private final EndElement endElement;
        private final XMLEventFactory eventFactory;

        Default(StartElement startElement, List<XMLEvent> innerEvents, EndElement endElement, XMLEventFactory eventFactory) {
            this.startElement = startElement;
            this.innerEvents = innerEvents;
            this.endElement = endElement;
            this.eventFactory = eventFactory;
        }

        @Override
        public StartElement startElement() {
            return this.startElement;
        }

        @Override
        public List<XMLEvent> innerEvents() {
            return this.innerEvents;
        }

        @Override
        public void updateInnerEventsWith(List<XMLEvent> events) {
            ListIterator<XMLEvent> iterator = this.innerEvents.listIterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
            events.forEach(e -> iterator.add((XMLEvent)e));
        }

        @Override
        public EndElement endElement() {
            return this.endElement;
        }

        XMLEventFactory eventFactory() {
            return this.eventFactory;
        }

        @Override
        public void apply(FontMappings fontMappings) {
        }

        @Override
        public List<XMLEvent> getEvents() {
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>(this.innerEvents.size() + 2);
            events.add(this.startElement);
            events.addAll(this.innerEvents);
            events.add(this.endElement);
            return events;
        }

        @Override
        public QName getName() {
            return this.startElement.getName();
        }
    }
}

