/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.sentencealigner;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.PathInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String GENERATETMX = "generateTMX";
    private static final String TMXOUTPUTPATH = "tmxOutputPath";
    private static final String COLLAPSEWHITESPACE = "collapseWhitespace";
    private static final String OUTPUT_ONE_TO_ONE_MATCHES_ONLY = "outputOneTOneMatchesOnly";
    private static final String SEGMENTSOURCE = "segmentSource";
    private static final String USECUSTOMSOURCERULES = "useCustomSourceRules";
    private static final String CUSTOMSOURCERULESPATH = "customSourceRulesPath";
    private static final String SEGMENTTARGET = "segmentTarget";
    private static final String USECUSTOMTARGETRULES = "useCustomTargetRules";
    private static final String CUSTOMTARGETRULESPATH = "customTargetRulesPath";
    private static final String FORCESIMPLEONETOONEALIGNMENT = "forceSimpleOneToOneAlignment";

    public boolean isGenerateTMX() {
        return this.getBoolean(GENERATETMX);
    }

    public void setGenerateTMX(boolean generateTMX) {
        this.setBoolean(GENERATETMX, generateTMX);
    }

    public String getTmxOutputPath() {
        return this.getString(TMXOUTPUTPATH);
    }

    public void setTmxOutputPath(String tmxOutputPath) {
        this.setString(TMXOUTPUTPATH, tmxOutputPath);
    }

    public boolean isSegmentSource() {
        return this.getBoolean(SEGMENTSOURCE);
    }

    public void setSegmentSource(boolean segmentSource) {
        this.setBoolean(SEGMENTSOURCE, segmentSource);
    }

    public boolean isUseCustomSourceRules() {
        return this.getBoolean(USECUSTOMSOURCERULES);
    }

    public void setUseCustomSourceRules(boolean useCustomSourceRules) {
        this.setBoolean(USECUSTOMSOURCERULES, useCustomSourceRules);
    }

    public String getCustomSourceRulesPath() {
        return this.getString(CUSTOMSOURCERULESPATH);
    }

    public void setCustomSourceRulesPath(String customSourceRulesPath) {
        this.setString(CUSTOMSOURCERULESPATH, customSourceRulesPath);
    }

    public boolean isSegmentTarget() {
        return this.getBoolean(SEGMENTTARGET);
    }

    public void setSegmentTarget(boolean segmentTarget) {
        this.setBoolean(SEGMENTTARGET, segmentTarget);
    }

    public boolean isUseCustomTargetRules() {
        return this.getBoolean(USECUSTOMTARGETRULES);
    }

    public void setUseCustomTargetRules(boolean useCustomTargetRules) {
        this.setBoolean(USECUSTOMTARGETRULES, useCustomTargetRules);
    }

    public String getCustomTargetRulesPath() {
        return this.getString(CUSTOMTARGETRULESPATH);
    }

    public void setCustomTargetRulesPath(String customTargetRulesPath) {
        this.setString(CUSTOMTARGETRULESPATH, customTargetRulesPath);
    }

    public boolean isCollapseWhitespace() {
        return this.getBoolean(COLLAPSEWHITESPACE);
    }

    public void setCollapseWhitespace(boolean collapseWhitespace) {
        this.setBoolean(COLLAPSEWHITESPACE, collapseWhitespace);
    }

    public boolean isOutputOneTOneMatchesOnly() {
        return this.getBoolean(OUTPUT_ONE_TO_ONE_MATCHES_ONLY);
    }

    public void setOutputOneTOneMatchesOnly(boolean outputOneTOneMatchesOnly) {
        this.setBoolean(OUTPUT_ONE_TO_ONE_MATCHES_ONLY, outputOneTOneMatchesOnly);
    }

    public boolean isForceSimpleOneToOneAlignment() {
        return this.getBoolean(FORCESIMPLEONETOONEALIGNMENT);
    }

    public void setForceSimpleOneToOneAlignment(boolean forceSimpleOneToOneAlignment) {
        this.setBoolean(FORCESIMPLEONETOONEALIGNMENT, forceSimpleOneToOneAlignment);
    }

    @Override
    public void reset() {
        super.reset();
        this.setTmxOutputPath("aligned.tmx");
        this.setGenerateTMX(true);
        this.setSegmentSource(true);
        this.setUseCustomSourceRules(false);
        this.setCustomSourceRulesPath("");
        this.setSegmentTarget(true);
        this.setUseCustomTargetRules(false);
        this.setCustomTargetRulesPath("");
        this.setCollapseWhitespace(false);
        this.setOutputOneTOneMatchesOnly(false);
        this.setForceSimpleOneToOneAlignment(false);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(GENERATETMX, "Generate the following TMX document:", "If generateTMX is false generate bilingual TextUnits, otherwise (true) output a TMX file");
        desc.add(TMXOUTPUTPATH, "TMX output path", "Full path of the output TMX file");
        desc.add(SEGMENTSOURCE, "Segment the source content (overriding possible existing segmentation)", null);
        desc.add(USECUSTOMSOURCERULES, "Use custom source segmentation rules (instead of the default ones)", null);
        desc.add(CUSTOMSOURCERULESPATH, "SRX path for the source", "Full path of the SRX document to use for the source");
        desc.add(SEGMENTTARGET, "Segment the target content (overriding possible existing segmentation)", null);
        desc.add(USECUSTOMTARGETRULES, "Use custom target segmentation rules (instead of the default ones)", null);
        desc.add(CUSTOMTARGETRULESPATH, "SRX path for the target", "Full path of the SRX document to use for the target");
        desc.add(COLLAPSEWHITESPACE, "Collapse whitspace", "Collapse whitespace (space, newline etc.) to a single space before segmentation and alignment");
        desc.add(OUTPUT_ONE_TO_ONE_MATCHES_ONLY, "Output 1-1 matches only", "Ouput only 1-1 sentence aligned matches");
        desc.add(FORCESIMPLEONETOONEALIGNMENT, "Force Simple One to One Alignment", "If the number of sentences are the same then align one to one. Otherwise collapse the sentences and align");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Sentence Aligner", true, false);
        CheckboxPart cbp = desc.addCheckboxPart(paramsDesc.get(GENERATETMX));
        PathInputPart pip = desc.addPathInputPart(paramsDesc.get(TMXOUTPUTPATH), "TMX Document to Generate", true);
        pip.setBrowseFilters("TMX Documents (*.tmx)\tAll Files (*.*)", "*.tmx\t*.*");
        pip.setWithLabel(false);
        pip.setMasterPart(cbp, true);
        desc.addSeparatorPart();
        CheckboxPart cbp1 = desc.addCheckboxPart(paramsDesc.get(SEGMENTSOURCE));
        CheckboxPart cbp2 = desc.addCheckboxPart(paramsDesc.get(USECUSTOMSOURCERULES));
        cbp2.setMasterPart(cbp1, true);
        pip = desc.addPathInputPart(paramsDesc.get(CUSTOMSOURCERULESPATH), "Segmentation Rules for Source", false);
        pip.setBrowseFilters("SRX Documents (*.srx)\tAll Files (*.*)", "*.srx\t*.*");
        pip.setWithLabel(false);
        pip.setMasterPart(cbp2, true);
        desc.addSeparatorPart();
        cbp1 = desc.addCheckboxPart(paramsDesc.get(SEGMENTTARGET));
        cbp2 = desc.addCheckboxPart(paramsDesc.get(USECUSTOMTARGETRULES));
        cbp2.setMasterPart(cbp1, true);
        pip = desc.addPathInputPart(paramsDesc.get(CUSTOMTARGETRULESPATH), "Segmentation Rules for Target", false);
        pip.setBrowseFilters("SRX Documents (*.srx)\tAll Files (*.*)", "*.srx\t*.*");
        pip.setWithLabel(false);
        pip.setMasterPart(cbp2, true);
        desc.addSeparatorPart();
        desc.addCheckboxPart(paramsDesc.get(COLLAPSEWHITESPACE));
        desc.addSeparatorPart();
        desc.addCheckboxPart(paramsDesc.get(OUTPUT_ONE_TO_ONE_MATCHES_ONLY));
        desc.addSeparatorPart();
        desc.addCheckboxPart(paramsDesc.get(FORCESIMPLEONETOONEALIGNMENT));
        return desc;
    }
}

