/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.net.URI;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;

public class Issue
extends GenericAnnotation {
    public static final int DISPSEVERITY_LOW = 0;
    public static final int DISPSEVERITY_MEDIUM = 1;
    public static final int DISPSEVERITY_HIGH = 2;
    public static final double SEVERITY_LOW = 1.0;
    public static final double SEVERITY_MEDIUM = 50.0;
    public static final double SEVERITY_HIGH = 100.0;
    private URI docURI;
    private String subDocId;
    private IssueType issueType;
    private String tuId;
    private String segId;
    private String tuName;
    private int trgStart;
    private int trgEnd;
    private List<Code> codes;
    private String source;
    private String target;
    private int dispSeverity;
    private TextContainer srcContainer;
    private TextContainer trgContainer;

    public Issue(URI docId, String subDocId, IssueType issueType, String tuId, String segId, String message, int srcStart, int srcEnd, int trgStart, int trgEnd, double severity, String tuName) {
        super("its-lqi");
        this.docURI = docId;
        this.subDocId = subDocId;
        this.issueType = issueType;
        this.tuId = tuId;
        this.segId = segId;
        this.setString("lqiComment", message);
        this.setInteger("lqiXStart", srcStart);
        this.setInteger("lqiXEnd", srcEnd);
        this.trgStart = trgStart;
        this.trgEnd = trgEnd;
        this.dispSeverity = Issue.severityToDisplaySeverity(severity);
        this.setDouble("lqiSeverity", severity);
        this.tuName = tuName;
        this.setBoolean("lqiEnabled", true);
    }

    public URI getDocumentURI() {
        return this.docURI;
    }

    public String getSubDocumentId() {
        return this.subDocId;
    }

    public IssueType getIssueType() {
        return this.issueType;
    }

    public String getITSType() {
        return this.getString("lqiType");
    }

    public String getTuId() {
        return this.tuId;
    }

    public String getTuName() {
        return this.tuName;
    }

    public String getSegId() {
        return this.segId;
    }

    public int getSourceStart() {
        return this.getInteger("lqiXStart");
    }

    public int getSourceEnd() {
        return this.getInteger("lqiXEnd");
    }

    public int getTargetStart() {
        return this.trgStart;
    }

    public int getTargetEnd() {
        return this.trgEnd;
    }

    public boolean getEnabled() {
        return this.getBoolean("lqiEnabled");
    }

    public void setEnabled(boolean enabled) {
        this.setBoolean("lqiEnabled", enabled);
    }

    public int getDisplaySeverity() {
        return this.dispSeverity;
    }

    public double getSeverity() {
        return this.getDouble("lqiSeverity");
    }

    public String getMessage() {
        return this.getString("lqiComment");
    }

    public List<Code> getCodes() {
        return this.codes;
    }

    public void setCodes(List<Code> codes) {
        this.codes = codes;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setContainers(ITextUnit tu, LocaleId trgLoc) {
        this.srcContainer = tu.getSource();
        this.trgContainer = null;
        if (tu.hasTarget(trgLoc)) {
            this.trgContainer = tu.getTarget(trgLoc);
        }
    }

    public TextContainer getSourceContainer() {
        return this.srcContainer;
    }

    public TextContainer getTargetContainer() {
        return this.trgContainer;
    }

    String getSignature() {
        return String.format("%s-%s-%s-%s-%d-%s", new Object[]{this.docURI, this.subDocId, this.tuId, this.segId == null ? "" : this.segId, this.getInteger("lqiXStart"), this.issueType});
    }

    @Override
    public String toString() {
        StringBuilder tmp = new StringBuilder();
        tmp.append("<qaItem");
        tmp.append(" docUri=\"" + Util.escapeToXML(this.docURI.getPath(), 3, false, null) + "\"");
        tmp.append(" tuId=\"" + Util.escapeToXML(this.tuId, 3, false, null) + "\"");
        tmp.append(" segId=\"" + Util.escapeToXML(this.segId, 3, false, null) + "\"");
        tmp.append(" tuName=\"" + (this.tuName != null ? Util.escapeToXML(this.tuName, 3, false, null) : "") + "\"");
        tmp.append(String.format(" srcStart=\"%d\" srcEnd=\"%d\"", this.getInteger("lqiXStart"), this.getInteger("lqiXEnd")));
        tmp.append(String.format(" trgStart=\"%d\" trgEnd=\"%d\"", this.trgStart, this.trgEnd));
        tmp.append(String.format(" severity=\"%d\"", this.dispSeverity));
        tmp.append("><qaNote>" + Util.escapeToXML(this.getString("lqiComment"), 0, false, null) + "<qaNote>");
        tmp.append("</qaItem>");
        return tmp.toString();
    }

    public static int severityToDisplaySeverity(double value) {
        if (value < 33.33) {
            return 0;
        }
        if (value >= 33.33 && value < 66.33) {
            return 1;
        }
        return 2;
    }

    public static double displaySeverityToSeverity(int value) {
        if (value == 0) {
            return 1.0;
        }
        if (value == 1) {
            return 50.0;
        }
        return 100.0;
    }
}

