/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.merge.merge;

import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.MimeTypeMapper;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.StringUtil;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.exceptions.OkapiMergeException;
import net.sf.okapi.common.resource.CodeAnomalies;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragmentUtil;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.lib.merge.merge.ITextUnitMerger;
import net.sf.okapi.lib.merge.merge.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextUnitMerger
implements ITextUnitMerger {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private LocaleId trgLoc;
    private Parameters params;
    private List<Range> srcRanges;
    private List<Range> trgRanges;

    @Override
    public ITextUnit mergeTargets(ITextUnit tuFromSkel, ITextUnit tuFromTran) {
        String sourceFromTranslated;
        String originalSource;
        if (!tuFromSkel.getId().equals(tuFromTran.getId())) {
            String s = String.format("Text Unit id mismatch during merger: Original id=\"%s\" target id=\"%s\"", tuFromSkel.getId(), tuFromTran.getId());
            this.LOGGER.error(s);
            if (this.params.isThrowSegmentIdException()) {
                throw new OkapiMergeException(s);
            }
        }
        if (!(originalSource = StringUtil.removeWhiteSpace(tuFromSkel.getSource().createJoinedContent().getText())).equals(sourceFromTranslated = StringUtil.removeWhiteSpace(tuFromTran.getSource().createJoinedContent().getText()))) {
            String s = String.format("Text Unit source mismatch during merge: Original id=\"%s\" target id=\"%s\"\nOriginal Source=\"%s\"\nTranslated Source=\"%s\"", tuFromSkel.getId(), tuFromTran.getId(), originalSource, sourceFromTranslated);
            this.LOGGER.error(s);
            if (this.params.isThrowSegmentSourceException()) {
                throw new OkapiMergeException(s);
            }
        }
        TextContainer sourceFromSkel = tuFromSkel.getSource();
        TextContainer sourceFromTarget = tuFromTran.getSource();
        TextContainer targetFromSkel = tuFromSkel.hasTarget(this.trgLoc) ? tuFromSkel.getTarget(this.trgLoc).clone() : null;
        TextContainer mergeFromSkel = targetFromSkel == null || targetFromSkel.isEmpty() ? sourceFromSkel : targetFromSkel.clone();
        TextContainer targetFromTran = null;
        targetFromTran = tuFromTran.hasTarget(this.trgLoc) ? tuFromTran.getTarget(this.trgLoc).clone() : tuFromTran.getSource().clone();
        if (targetFromTran == null) {
            if (tuFromSkel.getSource().hasText()) {
                this.LOGGER.error("No translation found for TU id='{}'. Using source instead.", (Object)tuFromTran.getId());
            }
            return tuFromSkel;
        }
        boolean isTransApproved = false;
        Property traProp = targetFromTran.getProperty("approved");
        if (traProp != null) {
            isTransApproved = traProp.getValue().equals("yes");
        }
        if (this.params != null && this.params.isApprovedOnly() && !isTransApproved) {
            this.LOGGER.warn("Item id='{}': Target is not approved; using source instead.", (Object)tuFromSkel.getId());
            return tuFromSkel;
        }
        boolean mergeAsSegments = MimeTypeMapper.isSegmentationSupported(tuFromSkel.getMimeType());
        this.srcRanges = null;
        this.trgRanges = null;
        boolean simplified = false;
        if (!mergeFromSkel.contentIsOneSegment()) {
            this.srcRanges = mergeFromSkel.getSegments().getRanges();
            mergeFromSkel.joinAll();
        }
        if (!targetFromTran.contentIsOneSegment()) {
            for (TextPart tp : targetFromTran.getSegments()) {
                if (!TextUnitUtil.hasMergedCode(tp.text)) continue;
                tp.text = TextUnitUtil.expandCodes(tp.text);
                simplified = true;
            }
            this.trgRanges = targetFromTran.getSegments().getRanges();
            targetFromTran.joinAll();
        } else if (TextUnitUtil.hasMergedCode(targetFromTran.getFirstContent())) {
            targetFromTran.setContent(TextUnitUtil.expandCodes(targetFromTran.getFirstContent()));
            simplified = true;
        }
        TextFragmentUtil.copyCodes(mergeFromSkel.getFirstContent(), targetFromTran.getFirstContent(), simplified);
        CodeAnomalies codeAnomalies = TextFragmentUtil.catalogCodeAnomalies(mergeFromSkel.getFirstContent(), targetFromTran.getFirstContent());
        if (codeAnomalies != null) {
            StringBuilder e = new StringBuilder();
            e.append(String.format("Text Unit id: %s", tuFromTran.getId()));
            if (codeAnomalies.hasAddedCodes()) {
                e.append(String.format("\nAdded Codes in target='%s'", codeAnomalies.addedCodesAsString()));
            }
            if (codeAnomalies.hasMissingCodes()) {
                e.append(String.format("\nMissing Codes in target='%s'", codeAnomalies.missingCodesAsString()));
            }
            e.append("\nTarget Text Unit:\n");
            e.append(targetFromTran.getUnSegmentedContentCopy().toText());
            this.LOGGER.error(e.toString());
            if (this.params.isThrowCodeException()) {
                throw new OkapiMergeException(e.toString());
            }
        }
        if (mergeAsSegments) {
            if (this.srcRanges != null) {
                mergeFromSkel.getSegments().create(this.srcRanges, true);
            }
            if (this.trgRanges != null) {
                targetFromTran.getSegments().create(this.trgRanges, true);
            }
        }
        if (mergeFromSkel.getSegments().count() < targetFromTran.getSegments().count()) {
            this.LOGGER.error("Item id='{}': There is at least one extra segment in the translation file.", (Object)tuFromTran.getId());
        }
        if (!tuFromSkel.hasTarget(this.trgLoc)) {
            tuFromSkel.createTarget(this.trgLoc, false, 7);
        }
        tuFromSkel.setTarget(this.trgLoc, targetFromTran);
        if (targetFromSkel == null) {
            return tuFromSkel;
        }
        if (mergeAsSegments) {
            for (Segment seg : targetFromSkel.getSegments()) {
                Segment tseg = targetFromTran.getSegments().get(seg.id);
                if (tseg == null || seg.getAnnotations() == null) continue;
                for (IAnnotation ann : seg.getAnnotations()) {
                    tseg.setAnnotation(ann);
                }
            }
        }
        for (IAnnotation ann : targetFromSkel.getAnnotations()) {
            targetFromTran.setAnnotation(ann);
        }
        for (String propName : targetFromSkel.getPropertyNames()) {
            if (propName.equals("state") && targetFromTran.hasProperty("state")) continue;
            targetFromTran.setProperty(targetFromSkel.getProperty(propName));
        }
        if (tuFromSkel.getMimeType() != null && tuFromSkel.getMimeType().equals("application/xliff+xml")) {
            tuFromSkel.setSource(sourceFromTarget);
        }
        return tuFromSkel;
    }

    @Override
    public void setTargetLocale(LocaleId trgLoc) {
        this.trgLoc = trgLoc;
    }

    public LocaleId getTargetLocale() {
        return this.trgLoc;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(Parameters params) {
        this.params = params;
    }
}

