/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff2.util;

import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.IWithProperties;
import net.sf.okapi.common.resource.InlineAnnotation;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.core.BaseList;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.CanReorder;
import net.sf.okapi.lib.xliff2.core.Directionality;
import net.sf.okapi.lib.xliff2.core.ExtAttributes;
import net.sf.okapi.lib.xliff2.core.IWithExtAttributes;
import net.sf.okapi.lib.xliff2.core.MidFileData;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.Skeleton;
import net.sf.okapi.lib.xliff2.core.StartFileData;
import net.sf.okapi.lib.xliff2.core.StartGroupData;
import net.sf.okapi.lib.xliff2.core.StartXliffData;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.core.TargetState;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.metadata.IMetadataItem;
import net.sf.okapi.lib.xliff2.metadata.Meta;
import net.sf.okapi.lib.xliff2.metadata.MetaGroup;
import net.sf.okapi.lib.xliff2.metadata.Metadata;
import org.slf4j.LoggerFactory;

public class PropertiesMapper {
    private static final Pattern EXTENDED_ATTRIBUTE_KEY_PATTERN = Pattern.compile("^" + Pattern.quote("extendedAttribute.") + "(.*)" + Pattern.quote("==") + "\\{(.*?)\\}(.*)$");

    public static void setStartXliffProperties(StartXliffData xliffStartXliff, StartDocument okapiStartDocument) {
        PropertiesMapper.setProperty("srcLang", xliffStartXliff.getSourceLanguage(), (IWithProperties)okapiStartDocument);
        PropertiesMapper.setProperty("trgLang", xliffStartXliff.getTargetLanguage(), (IWithProperties)okapiStartDocument);
        PropertiesMapper.setProperty("version", xliffStartXliff.getVersion(), (IWithProperties)okapiStartDocument);
        PropertiesMapper.setExtendedAttributes((IWithExtAttributes)xliffStartXliff, okapiStartDocument);
    }

    public static void setStartXliffProperties(StartDocument okapiStartDocument, StartXliffData xliffStartXliff) {
        xliffStartXliff.setSourceLanguage(okapiStartDocument.getLocale().toString());
        PropertiesMapper.setExtendedAttributes(okapiStartDocument, (IWithExtAttributes)xliffStartXliff);
    }

    public static void setStartFileProperties(StartFileData xliffStartFileData, StartSubDocument okapiStartSubDoc) {
        okapiStartSubDoc.setId(xliffStartFileData.getId());
        okapiStartSubDoc.setIsTranslatable(xliffStartFileData.getTranslate());
        PropertiesMapper.setProperty("srcDir", xliffStartFileData.getSourceDir(), (IWithProperties)okapiStartSubDoc);
        PropertiesMapper.setProperty("trgDir", xliffStartFileData.getTargetDir(), (IWithProperties)okapiStartSubDoc);
        PropertiesMapper.setProperty("canResegment", xliffStartFileData.getCanResegment(), (IWithProperties)okapiStartSubDoc);
        okapiStartSubDoc.setName(xliffStartFileData.getOriginal());
        PropertiesMapper.setExtendedAttributes((IWithExtAttributes)xliffStartFileData, okapiStartSubDoc);
    }

    public static void setStartFileProperties(StartSubDocument okapiStartSubDoc, StartFileData xliffStartFileData) {
        xliffStartFileData.setId(okapiStartSubDoc.getId());
        xliffStartFileData.setTranslate(okapiStartSubDoc.isTranslatable());
        xliffStartFileData.setOriginal(okapiStartSubDoc.getName());
        xliffStartFileData.setSourceDir(PropertiesMapper.stringToDirection(PropertiesMapper.getProperty("srcDir", okapiStartSubDoc)));
        xliffStartFileData.setTargetDir(PropertiesMapper.stringToDirection(PropertiesMapper.getProperty("trgDir", okapiStartSubDoc)));
        xliffStartFileData.setCanResegment(PropertiesMapper.stringToBoolean(PropertiesMapper.getProperty("canResegment", okapiStartSubDoc)));
        PropertiesMapper.setExtendedAttributes(okapiStartSubDoc, (IWithExtAttributes)xliffStartFileData);
    }

    public static void setSkeletonProperties(Skeleton skeletonData, StartSubDocument startSubDoc) {
        PropertiesMapper.setProperty("skeletonExists", true, (IWithProperties)startSubDoc);
        LoggerFactory.getLogger(PropertiesMapper.class).warn("Retrieving skeleton data not fully implemented in XLIFF 2.0 Filter.");
    }

    public static void setSkeletonProperties(StartSubDocument startSubDoc, Skeleton skeletonData) {
        if (PropertiesMapper.stringToBoolean(PropertiesMapper.getProperty("skeletonExists", startSubDoc))) {
            LoggerFactory.getLogger(PropertiesMapper.class).warn("Saving skeleton data not fully implemented in XLIFF 2.0 Filter Writer.");
        }
    }

    public static void setGroupProperties(StartGroupData xliffStartGroupData, StartGroup okapiStartGroup) {
        okapiStartGroup.setId(xliffStartGroupData.getId());
        okapiStartGroup.setIsTranslatable(xliffStartGroupData.getTranslate());
        okapiStartGroup.setName(xliffStartGroupData.getName());
        okapiStartGroup.setType(xliffStartGroupData.getType());
        PropertiesMapper.setProperty("canResegment", xliffStartGroupData.getCanResegment(), (IWithProperties)okapiStartGroup);
        PropertiesMapper.setProperty("srcDir", xliffStartGroupData.getSourceDir(), (IWithProperties)okapiStartGroup);
        PropertiesMapper.setProperty("trgDir", xliffStartGroupData.getTargetDir(), (IWithProperties)okapiStartGroup);
        PropertiesMapper.setExtendedAttributes((IWithExtAttributes)xliffStartGroupData, okapiStartGroup);
        if (xliffStartGroupData.hasMetadata()) {
            Metadata metadata = xliffStartGroupData.getMetadata();
            PropertiesMapper.setMetadata(metadata, okapiStartGroup);
        }
    }

    public static void setGroupProperties(StartGroup okapiStartGroup, StartGroupData xliffStartGroupData) {
        xliffStartGroupData.setId(okapiStartGroup.getId());
        xliffStartGroupData.setTranslate(okapiStartGroup.isTranslatable());
        String canResegment = PropertiesMapper.getProperty("canResegment", okapiStartGroup);
        if (canResegment != null) {
            xliffStartGroupData.setCanResegment(PropertiesMapper.stringToBoolean(canResegment));
        }
        xliffStartGroupData.setSourceDir(PropertiesMapper.stringToDirection(PropertiesMapper.getProperty("srcDir", okapiStartGroup)));
        xliffStartGroupData.setTargetDir(PropertiesMapper.stringToDirection(PropertiesMapper.getProperty("trgDir", okapiStartGroup)));
        xliffStartGroupData.setType(okapiStartGroup.getType());
        PropertiesMapper.setExtendedAttributes(okapiStartGroup, (IWithExtAttributes)xliffStartGroupData);
        xliffStartGroupData.setMetadata(PropertiesMapper.buildMetadataObject(okapiStartGroup));
        xliffStartGroupData.setName(okapiStartGroup.getName());
    }

    public static void setTextUnitProperties(Unit unit, ITextUnit tu) {
        tu.setId(unit.getId());
        PropertiesMapper.setProperty("name", unit.getName(), (IWithProperties)tu);
        PropertiesMapper.setProperty("canResegment", unit.getCanResegment(), (IWithProperties)tu);
        PropertiesMapper.setProperty("translate", unit.getTranslate(), (IWithProperties)tu);
        PropertiesMapper.setProperty("type", unit.getType(), (IWithProperties)tu);
        PropertiesMapper.setProperty("srcDir", unit.getSourceDir(), (IWithProperties)tu);
        PropertiesMapper.setProperty("trgDir", unit.getTargetDir(), (IWithProperties)tu);
        boolean preserveWhitespace = false;
        for (Segment segment : unit.getSegments()) {
            if (!segment.getPreserveWS()) continue;
            preserveWhitespace = true;
        }
        tu.setPreserveWhitespaces(preserveWhitespace);
        PropertiesMapper.setExtendedAttributes((IWithExtAttributes)unit, tu);
    }

    public static void setTextUnitProperties(ITextUnit okapiTextUnit, Unit xliffTextUnit) {
        String targetDirection;
        String sourceDirection;
        String translate;
        xliffTextUnit.setId(okapiTextUnit.getId());
        xliffTextUnit.setName(okapiTextUnit.getName());
        xliffTextUnit.setType(okapiTextUnit.getType());
        String canResegment = PropertiesMapper.getProperty("canResegment", okapiTextUnit);
        if (canResegment != null) {
            xliffTextUnit.setCanResegment(PropertiesMapper.stringToBoolean(canResegment));
        }
        if ((translate = PropertiesMapper.getProperty("translate", okapiTextUnit)) != null) {
            xliffTextUnit.setTranslate(PropertiesMapper.stringToBoolean(translate));
        }
        if ((sourceDirection = PropertiesMapper.getProperty("srcDir", okapiTextUnit)) != null) {
            xliffTextUnit.setTargetDir(PropertiesMapper.stringToDirection(sourceDirection));
        }
        if ((targetDirection = PropertiesMapper.getProperty("trgDir", okapiTextUnit)) != null) {
            xliffTextUnit.setSourceDir(PropertiesMapper.stringToDirection(targetDirection));
        }
        PropertiesMapper.setExtendedAttributes(okapiTextUnit, (IWithExtAttributes)xliffTextUnit);
    }

    public static void setPartProperties(Part xliffPart, TextPart okapiPart) {
        PropertiesMapper.setProperty("xmlPreserveWS", xliffPart.getPreserveWS(), (IWithProperties)okapiPart);
        PropertiesMapper.setProperty("id", xliffPart.getId(), (IWithProperties)okapiPart);
        if (xliffPart.isSegment()) {
            Segment xliffSegment = (Segment)xliffPart;
            net.sf.okapi.common.resource.Segment okapiSegment = (net.sf.okapi.common.resource.Segment)okapiPart;
            PropertiesMapper.setProperty("canResegment", xliffSegment.getCanResegment(), (IWithProperties)okapiPart);
            PropertiesMapper.setProperty("state", xliffSegment.getState(), (IWithProperties)okapiPart);
            PropertiesMapper.setProperty("subState", xliffSegment.getSubState(), (IWithProperties)okapiPart);
        }
    }

    public static void setPartProperties(TextPart okapiSourcePart, TextPart okapiTargetPart, Part xliffPart, ITextUnit okapiTextUnit) {
        String xmlPreserveWhitespace = PropertiesMapper.getProperty("xmlPreserveWS", okapiSourcePart);
        xliffPart.setPreserveWS(xmlPreserveWhitespace != null && PropertiesMapper.stringToBoolean(xmlPreserveWhitespace) || xmlPreserveWhitespace == null && okapiTextUnit.preserveWhitespaces());
        xliffPart.setId(PropertiesMapper.getProperty("id", okapiSourcePart));
        if (xliffPart.isSegment()) {
            String substate;
            String state;
            Segment xliffSegment = (Segment)xliffPart;
            net.sf.okapi.common.resource.Segment okapiSegment = (net.sf.okapi.common.resource.Segment)okapiSourcePart;
            String canResegment = PropertiesMapper.getProperty("canResegment", okapiSegment);
            if (canResegment != null) {
                xliffSegment.setCanResegment(PropertiesMapper.stringToBoolean(canResegment));
            }
            if ((state = PropertiesMapper.getProperty("state", okapiSegment)) != null) {
                xliffSegment.setState(PropertiesMapper.stringToTargetState(state));
            }
            if ((substate = PropertiesMapper.getProperty("subState", okapiSegment)) != null) {
                xliffSegment.setSubState(substate);
            }
        }
    }

    public static void setCodeProperties(Code okapiCode, CTag xliff2Ctag) {
        xliff2Ctag.setCanCopy(okapiCode.isCloneable());
        xliff2Ctag.setCanDelete(okapiCode.isDeleteable());
        xliff2Ctag.setData(okapiCode.getData());
        xliff2Ctag.setDisp(okapiCode.getDisplayText());
        if (okapiCode.getType() != null && !okapiCode.getType().equals("null")) {
            try {
                xliff2Ctag.setType(okapiCode.getType());
            }
            catch (InvalidParameterException e) {
                LoggerFactory.getLogger(PropertiesMapper.class).debug("Could net set CTag type of {}: {}", (Object)xliff2Ctag, (Object)e.getMessage());
            }
        }
        if (okapiCode.hasAnnotation("canCopy")) {
            xliff2Ctag.setCanCopy(PropertiesMapper.stringToBoolean(okapiCode.getAnnotation("canCopy").getData()));
        }
        if (okapiCode.hasAnnotation("canDelete")) {
            xliff2Ctag.setCanDelete(PropertiesMapper.stringToBoolean(okapiCode.getAnnotation("canDelete").getData()));
        }
        if (okapiCode.hasAnnotation("canReorder")) {
            xliff2Ctag.setCanReorder(CanReorder.valueOf(okapiCode.getAnnotation("canReorder").getData().toUpperCase()));
        }
        if (okapiCode.hasAnnotation("canOverlap")) {
            xliff2Ctag.setCanOverlap(PropertiesMapper.stringToBoolean(okapiCode.getAnnotation("canOverlap").getData()));
        }
        if (okapiCode.hasAnnotation("subFlows")) {
            xliff2Ctag.setSubFlows(okapiCode.getAnnotation("subFlows").getData());
        }
        if (okapiCode.hasAnnotation("subType")) {
            xliff2Ctag.setSubType(okapiCode.getAnnotation("subType").getData());
        }
        if (okapiCode.hasAnnotation("disp")) {
            xliff2Ctag.setDisp(okapiCode.getAnnotation("disp").getData());
        }
        if (okapiCode.hasAnnotation("dir")) {
            xliff2Ctag.setDir(PropertiesMapper.stringToDirection(okapiCode.getAnnotation("dir").getData()));
        }
        if (okapiCode.hasAnnotation("dataDir")) {
            xliff2Ctag.setDataDir(PropertiesMapper.stringToDirection(okapiCode.getAnnotation("dataDir").getData()));
        }
        if (okapiCode.hasAnnotation("dataRef")) {
            xliff2Ctag.setDataRef(okapiCode.getAnnotation("dataRef").getData());
        }
        if (okapiCode.hasAnnotation("equiv")) {
            xliff2Ctag.setEquiv(okapiCode.getAnnotation("equiv").getData());
        }
        PropertiesMapper.setExtendedAttributes(okapiCode, (IWithExtAttributes)xliff2Ctag);
    }

    public static void setCodeProperties(CTag xliff2Ctag, Code okapiCode) {
        String id = xliff2Ctag.getId();
        int hashId = id.hashCode();
        okapiCode.setId(hashId);
        okapiCode.setDeleteable(xliff2Ctag.getCanDelete());
        okapiCode.setCloneable(xliff2Ctag.getCanCopy());
        okapiCode.setData(xliff2Ctag.getData());
        okapiCode.setDisplayText(xliff2Ctag.getDisp());
        okapiCode.setOriginalId(xliff2Ctag.getId());
        okapiCode.setTagType(PropertiesMapper.convertTagType(xliff2Ctag.getTagType()));
        okapiCode.setAnnotation("original", new InlineAnnotation(xliff2Ctag.getId()));
        if (xliff2Ctag.getType() != null) {
            okapiCode.setType(xliff2Ctag.getType());
        }
        okapiCode.setAnnotation("canDelete", new InlineAnnotation(PropertiesMapper.booleanToString(xliff2Ctag.getCanDelete())));
        okapiCode.setAnnotation("canCopy", new InlineAnnotation(PropertiesMapper.booleanToString(xliff2Ctag.getCanCopy())));
        okapiCode.setAnnotation("canOverlap", new InlineAnnotation(PropertiesMapper.booleanToString(xliff2Ctag.getCanOverlap())));
        if (xliff2Ctag.getCanReorder() != null) {
            okapiCode.setAnnotation("canReorder", new InlineAnnotation(xliff2Ctag.getCanReorder().toString()));
        }
        if (xliff2Ctag.getSubType() != null) {
            okapiCode.setAnnotation("subType", new InlineAnnotation(xliff2Ctag.getSubType()));
        }
        if (xliff2Ctag.getSubFlows() != null) {
            okapiCode.setAnnotation("subFlows", new InlineAnnotation(xliff2Ctag.getSubFlows()));
        }
        if (xliff2Ctag.getDisp() != null) {
            okapiCode.setAnnotation("disp", new InlineAnnotation(xliff2Ctag.getDisp()));
        }
        if (xliff2Ctag.getDir() != null) {
            okapiCode.setAnnotation("dir", new InlineAnnotation(PropertiesMapper.directionToString(xliff2Ctag.getDir())));
        }
        if (xliff2Ctag.getDataDir() != null) {
            okapiCode.setAnnotation("dataDir", new InlineAnnotation(PropertiesMapper.directionToString(xliff2Ctag.getDataDir())));
        }
        if (xliff2Ctag.getDataRef() != null) {
            okapiCode.setAnnotation("dataRef", new InlineAnnotation(xliff2Ctag.getDataRef()));
        }
        if (xliff2Ctag.getEquiv() != null) {
            okapiCode.setAnnotation("equiv", new InlineAnnotation(xliff2Ctag.getEquiv()));
        }
        PropertiesMapper.setExtendedAttributes((IWithExtAttributes)xliff2Ctag, okapiCode);
    }

    public static void setMidFileProperties(MidFileData midFileData, DocumentPart documentPart) {
        if (midFileData.hasMetadata()) {
            Metadata metadata = midFileData.getMetadata();
            PropertiesMapper.setMetadata(metadata, documentPart);
        }
    }

    public static void setMidFileProperties(DocumentPart documentPart, MidFileData midFileData) {
        midFileData.setMetadata(PropertiesMapper.buildMetadataObject(documentPart));
    }

    public static void fixMissingTargetCodeProperties(ITextUnit tu) {
        for (TextPart part : tu.getSource()) {
            for (Code code : part.getContent().getCodes()) {
                String keyPrepend = PropertiesMapper.okapiCodePropertyKeyPrependGenerator(code);
                Set<String> annotationKeys = code.getAnnotationsTypes();
                for (String annotationKey : annotationKeys) {
                    tu.setProperty(new Property(keyPrepend + annotationKey, code.getAnnotation(annotationKey).getData()));
                }
            }
        }
        for (LocaleId locale : tu.getTargetLocales()) {
            for (TextPart part : tu.getTarget(locale).getParts()) {
                for (Code code : part.getContent().getCodes()) {
                    String keyPrepend = PropertiesMapper.okapiCodePropertyKeyPrependGenerator(code);
                    Set<String> annotationKeys = code.getAnnotationsTypes();
                    for (String annotationKey : annotationKeys) {
                        tu.setProperty(new Property(keyPrepend + annotationKey, code.getAnnotation(annotationKey).getData()));
                    }
                }
            }
        }
    }

    public static void fixMissingTargetCodeProperties(ITextUnit propertiesStorage, Code okapiCode) {
        if (propertiesStorage == null || !okapiCode.getAnnotationsTypes().isEmpty()) {
            return;
        }
        String keyPrepend = PropertiesMapper.okapiCodePropertyKeyPrependGenerator(okapiCode);
        Set<String> propertyKeys = propertiesStorage.getPropertyNames();
        for (String propertyKey : propertyKeys) {
            if (!propertyKey.startsWith(keyPrepend)) continue;
            String originalKey = propertyKey.replace(keyPrepend, "");
            String value = propertiesStorage.getProperty(propertyKey).getValue();
            okapiCode.setAnnotation(originalKey, new InlineAnnotation(value));
        }
    }

    private static String okapiCodePropertyKeyPrependGenerator(Code code) {
        return "CODE_STORAGE_" + code.getId() + "_" + (Object)((Object)code.getTagType()) + "_";
    }

    private static void setMetadata(Metadata metadata, IWithProperties eventWithProperties) {
        Iterator iterator = metadata.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            MetaGroup next = (MetaGroup)iterator.next();
            String newPrepend = "metadata[" + i + "]" + ".";
            PropertiesMapper.setMetadata(next, newPrepend, eventWithProperties);
            ++i;
        }
    }

    private static void setMetadata(IMetadataItem metadata, String prepend, IWithProperties eventWithProperties) {
        if (metadata.isGroup()) {
            MetaGroup metaGroup = (MetaGroup)metadata;
            if (metaGroup.getId() != null) {
                PropertiesMapper.setProperty(prepend + "metadatagroup" + "." + "id", metaGroup.getId(), eventWithProperties);
            }
            if (metaGroup.getCategory() != null) {
                PropertiesMapper.setProperty(prepend + "metadatagroup" + "." + "category", metaGroup.getCategory(), eventWithProperties);
            }
            if (metaGroup.getAppliesTo() != null && !metaGroup.getAppliesTo().name().equals("UNDEFINED")) {
                PropertiesMapper.setProperty(prepend + "metadatagroup" + "." + "appliesTo", metaGroup.getAppliesTo(), eventWithProperties);
            }
            Iterator metaIterator = metaGroup.iterator();
            int i = 0;
            while (metaIterator.hasNext()) {
                IMetadataItem next = (IMetadataItem)metaIterator.next();
                String newPrepend = prepend + "metadatagroup" + "[" + i + "]" + ".";
                PropertiesMapper.setMetadata(next, newPrepend, eventWithProperties);
                ++i;
            }
        } else {
            Meta meta = (Meta)metadata;
            PropertiesMapper.setProperty(prepend + "meta" + "." + "type", meta.getType(), eventWithProperties);
            PropertiesMapper.setProperty(prepend + "meta" + "." + "data", meta.getData(), eventWithProperties);
        }
    }

    private static Metadata buildMetadataObject(IWithProperties eventWithProperties) {
        Metadata metadata = new Metadata();
        eventWithProperties.getPropertyNames().stream().filter(name -> name.startsWith("metadata")).sorted().forEach(propertyName -> {
            String propertyValue = eventWithProperties.getProperty((String)propertyName).getValue();
            String[] splitKey = propertyName.split(Pattern.quote("."));
            int currentMetaIndex = Integer.valueOf(splitKey[0].substring("metadata".length() + 1, splitKey[0].length() - 1));
            BaseList previousMetaGroup = metadata;
            IMetadataItem previousItem = null;
            for (int i = 1; i < splitKey.length; ++i) {
                String section = splitKey[i];
                if (section.startsWith("metadatagroup")) {
                    MetaGroup currentMetaGroup;
                    if (previousMetaGroup instanceof Metadata) {
                        try {
                            currentMetaGroup = (MetaGroup)previousMetaGroup.get(currentMetaIndex);
                        }
                        catch (IndexOutOfBoundsException e) {
                            currentMetaGroup = new MetaGroup();
                            previousMetaGroup.addGroup(currentMetaGroup);
                        }
                    } else {
                        try {
                            currentMetaGroup = (MetaGroup)((MetaGroup)previousMetaGroup).get(currentMetaIndex);
                        }
                        catch (IndexOutOfBoundsException e) {
                            currentMetaGroup = new MetaGroup();
                            previousMetaGroup.addGroup(currentMetaGroup);
                        }
                    }
                    previousMetaGroup = currentMetaGroup;
                    previousItem = currentMetaGroup;
                    if (i + 2 >= splitKey.length) continue;
                    currentMetaIndex = Integer.valueOf(section.substring("metadatagroup".length() + 1, section.length() - 1));
                    continue;
                }
                if (section.equals("meta")) {
                    IMetadataItem iMetadataItem;
                    try {
                        iMetadataItem = (IMetadataItem)((MetaGroup)previousMetaGroup).get(currentMetaIndex);
                    }
                    catch (IndexOutOfBoundsException e) {
                        iMetadataItem = new Meta("");
                        ((MetaGroup)previousMetaGroup).add(iMetadataItem);
                    }
                    previousItem = iMetadataItem;
                    continue;
                }
                if (previousItem.isGroup()) {
                    MetaGroup metaDataGroup = (MetaGroup)previousItem;
                    if (section.equals("category")) {
                        metaDataGroup.setCategory(propertyValue);
                        continue;
                    }
                    if (section.equals("id")) {
                        metaDataGroup.setId(propertyValue);
                        continue;
                    }
                    if (!section.equals("appliesTo")) continue;
                    metaDataGroup.setAppliesTo(PropertiesMapper.stringToAppliesTo(propertyValue));
                    continue;
                }
                Meta meta = (Meta)previousItem;
                if (section.equals("type")) {
                    meta.setType(propertyValue);
                    continue;
                }
                if (!section.equals("data")) continue;
                meta.setData(propertyValue);
            }
        });
        return metadata;
    }

    private static void setExtendedAttributes(IWithExtAttributes xliffElement, Code code) {
        ExtAttributes extAttributes = xliffElement.getExtAttributes();
        Set<String> namespaces = extAttributes.getNamespaces();
        namespaces.forEach(namespaceURI -> {
            String propertyName = "extendedNamespace." + namespaceURI;
            String value = extAttributes.getNamespacePrefix((String)namespaceURI);
            code.setAnnotation(propertyName, new InlineAnnotation(value));
        });
        extAttributes.forEach(extAttribute -> {
            String propertyName = "extendedAttribute." + extAttribute.getPrefix() + "==" + extAttribute.getQName();
            String value = extAttribute.getValue();
            code.setAnnotation(propertyName, new InlineAnnotation(value));
        });
    }

    private static void setExtendedAttributes(Code code, IWithExtAttributes xliffElement) {
        ExtAttributes extAttributes = xliffElement.getExtAttributes();
        code.getAnnotationsTypes().stream().filter(p -> p.startsWith("extendedNamespace.")).forEach(annotationName -> {
            String namespaceURI = annotationName.replace("extendedNamespace.", "");
            String prefix = code.getAnnotation((String)annotationName).getData();
            extAttributes.setNamespace(prefix, namespaceURI);
        });
        code.getAnnotationsTypes().stream().filter(p -> p.startsWith("extendedAttribute.")).forEach(annotationName -> {
            Matcher matcher = EXTENDED_ATTRIBUTE_KEY_PATTERN.matcher((CharSequence)annotationName);
            boolean found = matcher.find();
            if (found) {
                String prexix = matcher.group(1);
                String namespaceURI = matcher.group(2);
                String localeName = matcher.group(3);
                String value = code.getAnnotation((String)annotationName).getData();
                extAttributes.setAttribute(namespaceURI, localeName, value);
            } else {
                LoggerFactory.getLogger(PropertiesMapper.class).warn("Could not find extended attribute information from {}", annotationName);
            }
        });
    }

    private static void setExtendedAttributes(IWithExtAttributes xliffElement, IWithProperties okapiProperties) {
        ExtAttributes extAttributes = xliffElement.getExtAttributes();
        Set<String> namespaces = extAttributes.getNamespaces();
        namespaces.forEach(namespaceURI -> {
            String propertyName = "extendedNamespace." + namespaceURI;
            String value = extAttributes.getNamespacePrefix((String)namespaceURI);
            PropertiesMapper.setProperty(propertyName, value, okapiProperties);
        });
        extAttributes.forEach(extAttribute -> {
            String propertyName = "extendedAttribute." + extAttribute.getPrefix() + "==" + extAttribute.getQName();
            String value = extAttribute.getValue();
            PropertiesMapper.setProperty(propertyName, value, okapiProperties);
        });
    }

    private static void setExtendedAttributes(IWithProperties okapiProperties, IWithExtAttributes xliffElement) {
        ExtAttributes extAttributes = xliffElement.getExtAttributes();
        okapiProperties.getPropertyNames().stream().filter(p -> p.startsWith("extendedNamespace.")).forEach(propertyName -> {
            String namespaceURI = propertyName.replace("extendedNamespace.", "");
            String prefix = PropertiesMapper.getProperty(propertyName, okapiProperties);
            extAttributes.setNamespace(prefix, namespaceURI);
        });
        okapiProperties.getPropertyNames().stream().filter(p -> p.startsWith("extendedAttribute.")).forEach(propertyName -> {
            Matcher matcher = EXTENDED_ATTRIBUTE_KEY_PATTERN.matcher((CharSequence)propertyName);
            boolean found = matcher.find();
            if (found) {
                String prexix = matcher.group(1);
                String namespaceURI = matcher.group(2);
                String localeName = matcher.group(3);
                String value = PropertiesMapper.getProperty(propertyName, okapiProperties);
                extAttributes.setAttribute(namespaceURI, localeName, value);
            } else {
                LoggerFactory.getLogger(PropertiesMapper.class).warn("Could not find extended attribute information from {}", propertyName);
            }
        });
    }

    private static String getProperty(String key, IWithProperties eventWithProperties) {
        Property property = eventWithProperties.getProperty(key);
        if (property == null) {
            return null;
        }
        return property.getValue();
    }

    private static void setProperty(String key, String value, IWithProperties eventWithProperties) {
        eventWithProperties.setProperty(new Property(key, value, true));
    }

    private static void setProperty(String key, boolean value, IWithProperties eventWithProperties) {
        eventWithProperties.setProperty(new Property(key, PropertiesMapper.booleanToString(value), true));
    }

    private static void setProperty(String key, Directionality value, IWithProperties eventWithProperties) {
        eventWithProperties.setProperty(new Property(key, PropertiesMapper.directionToString(value), true));
    }

    private static void setProperty(String key, TargetState value, IWithProperties eventWithProperties) {
        eventWithProperties.setProperty(new Property(key, PropertiesMapper.targetStateToString(value), true));
    }

    private static void setProperty(String key, MetaGroup.AppliesTo appliesTo, IWithProperties eventWithProperties) {
        eventWithProperties.setProperty(new Property(key, PropertiesMapper.appliesToToString(appliesTo), true));
    }

    private static boolean stringToBoolean(String value) {
        return "yes".equals(value);
    }

    private static String booleanToString(boolean value) {
        return value ? "yes" : "no";
    }

    private static Directionality stringToDirection(String value) {
        if (value == null) {
            return Directionality.AUTO;
        }
        if ("NOT ALLOWED".equals(value)) {
            value = "INHERITED";
        }
        return Directionality.valueOf(value.toUpperCase());
    }

    private static String directionToString(Directionality value) {
        return value.toString();
    }

    private static TargetState stringToTargetState(String value) {
        return TargetState.valueOf(value.toUpperCase());
    }

    private static String targetStateToString(TargetState value) {
        return value.toString();
    }

    private static String appliesToToString(MetaGroup.AppliesTo appliesTo) {
        return appliesTo.toString();
    }

    private static MetaGroup.AppliesTo stringToAppliesTo(String appliesTo) {
        return MetaGroup.AppliesTo.valueOf(appliesTo.toUpperCase());
    }

    private static TextFragment.TagType convertTagType(TagType tagType) {
        switch (tagType) {
            case CLOSING: {
                return TextFragment.TagType.CLOSING;
            }
            case OPENING: {
                return TextFragment.TagType.OPENING;
            }
            case STANDALONE: {
                return TextFragment.TagType.PLACEHOLDER;
            }
        }
        LoggerFactory.getLogger(PropertiesMapper.class).warn("TagType {} unrecognized. Treating it as {}.", (Object)tagType, (Object)TagType.STANDALONE);
        return TextFragment.TagType.PLACEHOLDER;
    }
}

