/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.sdlpackage;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.filters.archive.ArchiveFilter;
import net.sf.okapi.filters.archive.Parameters;

public class SdlPackageFilter
extends ArchiveFilter {
    public static final String MIME_TYPE = "application/x-sdlpackage";
    private List<FilterConfiguration> configs;

    public SdlPackageFilter() {
        Parameters params = (Parameters)this.getParameters();
        params.setMimeType(MIME_TYPE);
        params.setSimplifierRules(null);
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations("net.sf.okapi.filters.xliff.XLIFFFilter");
        this.setFilterConfigurationMapper(fcMapper);
        this.configs = new ArrayList<FilterConfiguration>();
        FilterConfiguration fc = new FilterConfiguration(this.getName(), MIME_TYPE, this.getClass().getName(), "SDL Trados Package Files", "SDL Trados 2017 SDLPPX and SDLRPX files", null, ".sdlppx;.sdlrpx;");
        this.configs.add(fc);
    }

    @Override
    public String getName() {
        return "okf_sdlpackage";
    }

    @Override
    public String getDisplayName() {
        return "SDLPPX and SDLRPX Filter (BETA)";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        return this.configs;
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        LocaleId trg = input.getTargetLocale();
        if (trg == null) {
            trg = this.getTrgLoc();
        }
        Parameters params = (Parameters)this.getParameters();
        params.setFileNames(trg.toBCP47() + "/*.sdlxliff");
        params.setConfigIds("okf_xliff-sdl");
        super.open(input, generateSkeleton);
    }
}

