/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ContentFilter;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.Part;

class DefaultPart
implements Part {
    private final Document.General generalDocument;
    private final ZipEntry entry;
    private final ContentFilter contentFilter;
    private String documentId;
    private String subDocumentId;

    DefaultPart(Document.General generalDocument, ZipEntry entry, ContentFilter contentFilter) {
        this.generalDocument = generalDocument;
        this.entry = entry;
        this.contentFilter = contentFilter;
    }

    @Override
    public Event open() throws IOException {
        this.documentId = this.generalDocument.documentId();
        this.subDocumentId = this.generalDocument.nextSubDocumentId();
        this.contentFilter.open(new RawDocument(new BufferedInputStream(this.generalDocument.inputStreamFor(this.entry)), StandardCharsets.UTF_8.name(), this.generalDocument.sourceLocale()));
        return this.convertToStartSubDocument(this.contentFilter.next());
    }

    private Event convertToStartSubDocument(Event event) {
        StartSubDocument sd = new StartSubDocument(this.documentId, this.subDocumentId);
        sd.setName(this.entry.getName());
        ConditionalParameters clonedParams = this.generalDocument.conditionalParameters().clone();
        sd.setFilterId("okf_openxml");
        clonedParams.nFileType = this.contentFilter.getParseType();
        sd.setFilterParameters(clonedParams);
        ZipSkeleton skel = new ZipSkeleton((GenericSkeleton)event.getStartDocument().getSkeleton(), this.generalDocument.zipFile(), this.entry);
        return new Event(EventType.START_SUBDOCUMENT, sd, skel);
    }

    @Override
    public boolean hasNextEvent() {
        return this.contentFilter.hasNext();
    }

    @Override
    public Event nextEvent() {
        Event event = this.contentFilter.next();
        if (EventType.END_DOCUMENT != event.getEventType()) {
            return event;
        }
        return this.convertToEndSubDocument(event);
    }

    private Event convertToEndSubDocument(Event event) {
        Ending ending = new Ending(this.subDocumentId);
        ZipSkeleton skel = new ZipSkeleton((GenericSkeleton)event.getResource().getSkeleton(), this.generalDocument.zipFile(), this.entry);
        return new Event(EventType.END_SUBDOCUMENT, ending, skel);
    }

    @Override
    public void close() {
        this.contentFilter.close();
    }

    @Override
    public void logEvent(Event e) {
        this.contentFilter.displayOneEvent(e);
    }
}

