/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openoffice;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.encoder.IEncoder;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiIllegalFilterOperationException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterUtil;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.filterwriter.ITSAnnotatorsRefContext;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.openoffice.AttributeRule;
import net.sf.okapi.filters.openoffice.Context;
import net.sf.okapi.filters.openoffice.ElementRule;
import net.sf.okapi.filters.openoffice.Parameters;

public class ODFFilter
implements IFilter {
    protected static final String NSURI_TEXT = "urn:oasis:names:tc:opendocument:xmlns:text:1.0";
    protected static final String NSURI_XLINK = "http://www.w3.org/1999/xlink";
    protected static final String TEXT_BOOKMARK_REF = "text:bookmark-ref";
    protected static final String OFFICE_ANNOTATION = "office:annotation";
    protected static final String DOCUMENT_TITLE = "dc:title";
    protected static final String DOCUMENT_DESCRIPTION = "dc:description";
    protected static final String DOCUMENT_SUBJECT = "dc:subject";
    protected static final String META_KEYWORD = "meta:keyword";
    protected static final String META_USER_DEFINED = "meta:user-defined";
    protected static final String META_NAME = "meta:name";
    protected static final String PAGE_NUMBER_TEXT = "text:page-number";
    protected static final String PAGE_COUNT_TEXT = "text:page-count";
    private static final String DEFAULT_ENCODER_CLASS_NAME = "net.sf.okapi.common.encoder.XMLEncoder";
    private Hashtable<String, ElementRule> toExtract = new Hashtable();
    private Hashtable<String, AttributeRule> attrbutesToExtract;
    private ArrayList<String> toProtect;
    private ArrayList<String> subFlow;
    private LinkedList<Event> queue;
    private IEncoder elementEncoder;
    private String docName;
    private XMLStreamReader reader;
    private int otherId;
    private int tuId;
    private Parameters params;
    private GenericSkeleton skel;
    private TextFragment tf;
    private ITextUnit tu;
    private boolean canceled;
    private boolean hasNext;
    private int dynamicContentDepth = 0;
    private Stack<Context> context;
    private String lineBreak = "\n";
    private String containerMimeType;
    private EncoderManager encoderManager;
    private Stack<GenericAnnotations> annotations;
    private ITSAnnotatorsRefContext annotatorsRef;
    private RawDocument input;

    public ODFFilter() {
        this.toExtract.put("text:p", new ElementRule("text:p", null));
        this.toExtract.put("text:h", new ElementRule("text:h", null));
        this.toExtract.put(DOCUMENT_TITLE, new ElementRule(DOCUMENT_TITLE, null));
        this.toExtract.put(DOCUMENT_DESCRIPTION, new ElementRule(DOCUMENT_DESCRIPTION, null));
        this.toExtract.put(DOCUMENT_SUBJECT, new ElementRule(DOCUMENT_SUBJECT, null));
        this.toExtract.put(META_KEYWORD, new ElementRule(META_KEYWORD, null));
        this.toExtract.put(META_USER_DEFINED, new ElementRule(META_USER_DEFINED, META_NAME));
        this.toExtract.put("text:index-title-template", new ElementRule("text:index-title-template", null));
        this.attrbutesToExtract = new Hashtable();
        this.attrbutesToExtract.put("style:num-prefix", new AttributeRule("style:num-prefix", null));
        this.attrbutesToExtract.put("style:num-suffix", new AttributeRule("style:num-suffix", null));
        this.attrbutesToExtract.put("table:name", new AttributeRule("table:name", "application/vnd.oasis.opendocument.spreadsheet"));
        this.subFlow = new ArrayList();
        this.subFlow.add("text:note");
        this.subFlow.add(OFFICE_ANNOTATION);
        this.toProtect = new ArrayList();
        this.toProtect.add("text:initial-creator");
        this.toProtect.add("text:creation-date");
        this.toProtect.add("text:creation-time");
        this.toProtect.add("text:description");
        this.toProtect.add("text:user-defined");
        this.toProtect.add("text:print-time");
        this.toProtect.add("text:print-date");
        this.toProtect.add("text:printed-by");
        this.toProtect.add("text:editing-cycles");
        this.toProtect.add("text:editing-duration");
        this.toProtect.add("text:modification-time");
        this.toProtect.add("text:modification-date");
        this.toProtect.add("text:creator");
        this.toProtect.add(PAGE_COUNT_TEXT);
        this.toProtect.add("text:paragraph-count");
        this.toProtect.add("text:word-count");
        this.toProtect.add("text:character-count");
        this.toProtect.add("text:table-count");
        this.toProtect.add("text:image-count");
        this.toProtect.add("text:object-count");
        this.toProtect.add("dc:date");
        this.toProtect.add("dc:creator");
        this.toProtect.add("text:note-citation");
        this.toProtect.add("text:tracked-changes");
        this.toProtect.add("text:title");
        this.toProtect.add("text:subject");
        this.toProtect.add("text:keywords");
        this.toProtect.add(TEXT_BOOKMARK_REF);
        this.toProtect.add(PAGE_NUMBER_TEXT);
        this.toProtect.add(PAGE_COUNT_TEXT);
        this.params = new Parameters();
        this.applyParameters();
    }

    @Override
    public void close() {
        if (this.input != null) {
            this.input.close();
        }
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            this.hasNext = false;
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.input = input;
        this.applyParameters();
        this.canceled = false;
        this.containerMimeType = "";
        XMLInputFactory fact = XMLInputFactory.newInstance();
        fact.setProperty("javax.xml.stream.isNamespaceAware", true);
        fact.setProperty("javax.xml.stream.isCoalescing", true);
        fact.setProperty("javax.xml.stream.supportDTD", false);
        try {
            input.setEncoding("UTF-8");
            this.reader = fact.createXMLStreamReader(input.getStream());
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException("Cannot create the XML stream.", e);
        }
        if (input.getInputURI() != null) {
            this.docName = input.getInputURI().getPath();
        }
        this.context = new Stack();
        this.context.push(new Context("", false));
        this.otherId = 0;
        this.tuId = 0;
        this.annotations = new Stack();
        this.annotatorsRef = new ITSAnnotatorsRefContext(this.reader);
        this.queue = new LinkedList();
        StartDocument startDoc = new StartDocument(String.valueOf(++this.otherId));
        startDoc.setLocale(input.getSourceLocale());
        startDoc.setName(this.docName);
        startDoc.setMimeType("text/x-odf");
        startDoc.setType(startDoc.getMimeType());
        startDoc.setEncoding("UTF-8", false);
        startDoc.setLineBreak(this.lineBreak);
        startDoc.setFilterId(this.getName());
        startDoc.setFilterParameters(this.params);
        startDoc.setFilterWriter(this.createFilterWriter());
        this.queue.add(new Event(EventType.START_DOCUMENT, startDoc));
        if (!Util.isEmpty(this.getParameters().getSimplifierRules())) {
            Event cs = FilterUtil.createCodeSimplifierEvent(this.getParameters().getSimplifierRules());
            this.queue.add(cs);
        }
        this.hasNext = true;
    }

    public void setContainerMimeType(String mimeType) {
        this.containerMimeType = mimeType;
    }

    @Override
    public String getName() {
        return "okf_odf";
    }

    @Override
    public String getDisplayName() {
        return "ODF-Content Filter (BETA)";
    }

    @Override
    public String getMimeType() {
        return "text/x-odf";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "text/x-odf", this.getClass().getName(), "OpenDocument", "XML OpenDocument files (e.g. use inside OpenOffice.org documents)."));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("text/x-odf", DEFAULT_ENCODER_CLASS_NAME);
        }
        return this.encoderManager;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public Event next() {
        if (this.canceled) {
            this.queue.clear();
            this.queue.add(new Event(EventType.CANCELED));
            this.hasNext = false;
        }
        if (this.queue.isEmpty()) {
            this.read();
        }
        if (this.queue.peek().getEventType() == EventType.END_DOCUMENT) {
            this.hasNext = false;
        }
        return this.queue.poll();
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters newParams) {
        this.params = (Parameters)newParams;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    private void read() {
        this.skel = new GenericSkeleton();
        this.tf = new TextFragment();
        try {
            while (this.reader.hasNext()) {
                switch (this.reader.next()) {
                    case 4: 
                    case 6: 
                    case 12: {
                        if (this.context.peek().extract) {
                            this.tf.append(this.reader.getText());
                            break;
                        }
                        this.skel.append(Util.escapeToXML(this.reader.getText(), 0, false, null));
                        break;
                    }
                    case 7: {
                        this.skel.append("<?xml version=\"1.0\" " + (this.reader.getEncoding() == null ? "" : "encoding=\"" + this.reader.getEncoding() + "\"") + "?>");
                        break;
                    }
                    case 8: {
                        Ending ending = new Ending(String.valueOf(++this.otherId));
                        ending.setSkeleton(this.skel);
                        this.queue.add(new Event(EventType.END_DOCUMENT, ending));
                        return;
                    }
                    case 1: {
                        this.processStartElement();
                        break;
                    }
                    case 2: {
                        if (!this.processEndElement()) break;
                        return;
                    }
                    case 5: {
                        if (this.context.peek().extract) {
                            this.tf.append(TextFragment.TagType.PLACEHOLDER, null, "<!--" + this.reader.getText() + "-->");
                            break;
                        }
                        this.skel.append("<!--" + this.reader.getText() + "-->");
                        break;
                    }
                    case 3: {
                        if (this.context.peek().extract) {
                            this.tf.append(TextFragment.TagType.PLACEHOLDER, null, "<?" + this.reader.getPITarget() + " " + this.reader.getPIData() + "?>");
                            break;
                        }
                        this.skel.append("<?" + this.reader.getPITarget() + " " + this.reader.getPIData() + "?>");
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    private void setTUInfo(String name) {
        this.tu.setType("x-" + name);
    }

    private String buildStartTag(String name, boolean inSkeleton) {
        int i;
        StringBuilder tmp = new StringBuilder();
        tmp.append("<" + name);
        int count = this.reader.getNamespaceCount();
        for (i = 0; i < count; ++i) {
            String prefix = this.reader.getNamespacePrefix(i);
            tmp.append(String.format(" xmlns%s=\"%s\"", prefix != null ? ":" + prefix : "", this.reader.getNamespaceURI(i)));
        }
        count = this.reader.getAttributeCount();
        for (i = 0; i < count; ++i) {
            if (!this.reader.isAttributeSpecified(i)) continue;
            String attributeName = this.getAttributeName(i);
            if (this.attrbutesToExtract.containsKey(attributeName)) {
                String text;
                AttributeRule rule = this.attrbutesToExtract.get(attributeName);
                if ((rule.mimeType == null || this.containerMimeType.indexOf(rule.mimeType) == 0) && this.hasTrueText(text = this.reader.getAttributeValue(i))) {
                    TextUnit tu = new TextUnit(String.valueOf(++this.tuId));
                    tu.setSourceContent(new TextFragment(text));
                    tu.setIsReferent(true);
                    tu.setMimeType("text/x-odf");
                    tu.setType("x-" + attributeName);
                    this.queue.add(new Event(EventType.TEXT_UNIT, tu));
                    tmp.append(String.format(" %s=\"", attributeName));
                    this.skel.append(tmp.toString());
                    this.skel.addReference(tu);
                    tmp.setLength(0);
                    tmp.append("\"");
                    continue;
                }
            }
            tmp.append(String.format(" %s=\"%s\"", attributeName, Util.escapeToXML(this.reader.getAttributeValue(i), 3, false, null)));
        }
        tmp.append(">");
        if (inSkeleton) {
            this.skel.append(tmp.toString());
        }
        return tmp.toString();
    }

    private boolean hasTrueText(String text) {
        if (Util.isEmpty(text)) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (!Character.isLetter(text.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private String buildEndTag(String name) {
        return "</" + name + ">";
    }

    private String makePrintName() {
        String prefix = this.reader.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            return this.reader.getLocalName();
        }
        return prefix + ":" + this.reader.getLocalName();
    }

    private void processStartElement() throws XMLStreamException {
        String name = this.makePrintName();
        if (this.toExtract.containsKey(name) && !this.isDynamicContent()) {
            if (this.context.size() > 1 || this.subFlow.contains(name)) {
                String id = String.valueOf(++this.tuId);
                if (this.context.peek().extract) {
                    Code code = this.tf.append(TextFragment.TagType.PLACEHOLDER, name, TextFragment.makeRefMarker(id));
                    code.setReferenceFlag(true);
                } else {
                    this.skel.addReference(this.tu);
                }
                this.tu = new TextUnit(id);
                this.tu.setIsReferent(true);
                this.setTUInfo(name);
                this.tf = new TextFragment();
                this.skel = new GenericSkeleton();
                this.buildStartTag(name, true);
                this.context.push(new Context(name, true));
                this.context.peek().setVariables(this.tf, this.skel, this.tu);
            } else {
                if (!this.skel.isEmpty(true)) {
                    DocumentPart dp = new DocumentPart(String.valueOf(++this.otherId), false);
                    dp.setSkeleton(this.skel);
                    this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
                    this.skel = new GenericSkeleton();
                }
                this.buildStartTag(name, true);
                this.tu = new TextUnit(null);
                this.setTUInfo(name);
                this.context.push(new Context(name, true));
                this.context.peek().setVariables(this.tf, this.skel, this.tu);
            }
        } else if (this.subFlow.contains(name)) {
            String id = String.valueOf(++this.tuId);
            if (this.context.peek().extract) {
                Code code = this.tf.append(TextFragment.TagType.PLACEHOLDER, name, TextFragment.makeRefMarker(id));
                code.setReferenceFlag(true);
                this.tu = new TextUnit(id);
                this.tu.setIsReferent(true);
                this.setTUInfo(name);
                this.tf = new TextFragment();
                this.skel = new GenericSkeleton();
                this.buildStartTag(name, true);
                this.context.push(new Context(name, true));
                this.context.peek().setVariables(this.tf, this.skel, this.tu);
            } else {
                if (!this.skel.isEmpty(true)) {
                    DocumentPart dp = new DocumentPart(String.valueOf(++this.otherId), false);
                    dp.setSkeleton(this.skel);
                    this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
                    this.skel = new GenericSkeleton();
                }
                this.tu = new TextUnit(id);
                this.setTUInfo(name);
                this.tf = new TextFragment();
                this.skel = new GenericSkeleton();
                this.buildStartTag(name, true);
                this.context.push(new Context(name, true));
                this.context.peek().setVariables(this.tf, this.skel, this.tu);
            }
        } else if (this.context.peek().extract && name.equals("text:s")) {
            String tmp = this.reader.getAttributeValue(NSURI_TEXT, "c");
            if (tmp != null) {
                int count = Integer.valueOf(tmp);
                for (int i = 0; i < count; ++i) {
                    this.tf.append(" ");
                }
            } else {
                this.tf.append(" ");
            }
            this.reader.nextTag();
        } else if (this.context.peek().extract && name.equals("text:tab")) {
            this.tf.append("\t");
            this.reader.nextTag();
        } else if (this.context.peek().extract && name.equals("text:line-break")) {
            this.tf.append(new Code(TextFragment.TagType.PLACEHOLDER, "lb", "<text:line-break/>"));
            this.reader.nextTag();
        } else if (ElementWithAttributesIndicatingDynamicContent.isSupported(name) && (this.hasAttributesIndicatingDynamicContent() || this.isDynamicContent())) {
            ++this.dynamicContentDepth;
            this.buildStartTag(name, true);
        } else if (this.context.peek().extract) {
            if (name.equals("text:a")) {
                this.processStartALink(name);
            } else if (this.toProtect.contains(name)) {
                this.processReadOnlyInlineElement(name);
            } else {
                this.annotatorsRef.readAndPush();
                GenericAnnotations ga = this.readITSAnnotations();
                Code code = this.tf.append(TextFragment.TagType.OPENING, name, this.buildStartTag(name, false));
                if (ga != null) {
                    GenericAnnotations.addAnnotations(code, ga);
                }
                this.annotations.push(ga);
            }
        } else {
            this.buildStartTag(name, true);
        }
    }

    private boolean hasAttributesIndicatingDynamicContent() {
        int attributeCount = this.reader.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            String attributeName = this.getAttributeName(i);
            if (!AttributeIndicatingDynamicContent.isSupported(attributeName)) continue;
            return true;
        }
        return false;
    }

    private String getAttributeName(int i) {
        String prefix = this.reader.getAttributePrefix(i);
        String attributeName = null == prefix ? this.reader.getAttributeLocalName(i) : prefix + ":" + this.reader.getAttributeLocalName(i);
        return attributeName;
    }

    private GenericAnnotations readITSAnnotations() {
        String val2;
        String val1;
        GenericAnnotations anns = null;
        GenericAnnotation ga = this.annotatorsRef.getAnnotation();
        if (ga != null) {
            anns = new GenericAnnotations(ga);
        }
        if ((val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "translate")) != null) {
            if (anns == null) {
                anns = new GenericAnnotations();
            }
            anns.add(new GenericAnnotation("its-translate", "translateValue", val1.equals("yes")));
        }
        if ((val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "localeFilterList")) != null) {
            val2 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "localeFilterType");
            if (val2 != null && val2.equals("exclude")) {
                val1 = "!" + val1;
            }
            if (anns == null) {
                anns = new GenericAnnotations();
            }
            anns.add(new GenericAnnotation("its-locfilter", "its-locfilterValue", val1));
        }
        if ((val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "term")) != null) {
            val2 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "termInfoRef");
            if (val2 != null) {
                val2 = "REF:" + val2;
            }
            String val3 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "termConfidence");
            if (anns == null) {
                anns = new GenericAnnotations();
            }
            anns.add(new GenericAnnotation("its-term", "termInfo", val2, "termConfidence", val3 == null ? null : Double.valueOf(Double.parseDouble(val3)), "annotatorRef", this.annotatorsRef.getAnnotatorRef("terminology")));
        }
        if ((val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locNote")) == null && (val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locNoteRef")) != null) {
            val1 = "REF:" + val1;
        }
        if (val1 != null) {
            val2 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locNoteType");
            if (val2 == null) {
                val2 = "description";
            }
            if (anns == null) {
                anns = new GenericAnnotations();
            }
            anns.add(new GenericAnnotation("its-ln", "lnValue", val1, "lnType", val2));
        }
        return anns;
    }

    private void processStartALink(String name) {
        String data = this.buildStartTag(name, false);
        String href = this.reader.getAttributeValue(NSURI_XLINK, "href");
        if (href != null) {
            // empty if block
        }
        this.annotatorsRef.readAndPush();
        GenericAnnotations ga = this.readITSAnnotations();
        Code code = this.tf.append(TextFragment.TagType.OPENING, name, data);
        if (ga != null) {
            GenericAnnotations.addAnnotations(code, ga);
        }
        this.annotations.push(ga);
    }

    private void processReadOnlyInlineElement(String name) throws XMLStreamException {
        StringBuilder tmp = new StringBuilder(this.buildStartTag(name, false));
        int stack = 1;
        while (true) {
            switch (this.reader.next()) {
                case 4: {
                    String text = this.reader.getText();
                    if (this.params.getEncodeCharacterEntityReferenceGlyphs() && ElementWithEncodableCharacters.isSupported(name)) {
                        tmp.append(this.getDefaultEncoder().encode(text, EncoderContext.TEXT));
                        break;
                    }
                    tmp.append(text);
                    break;
                }
                case 1: {
                    String tmpName = this.makePrintName();
                    tmp.append(this.buildStartTag(tmpName, false));
                    if (!tmpName.equals(name)) break;
                    ++stack;
                    break;
                }
                case 2: {
                    String tmpName = this.makePrintName();
                    tmp.append(this.buildEndTag(tmpName));
                    if (!tmpName.equals(name)) break;
                    this.tf.append(new Code(TextFragment.TagType.PLACEHOLDER, name, tmp.toString()));
                    if (--stack != 0) break;
                    return;
                }
                case 5: {
                    tmp.append("<!--" + this.reader.getText() + "-->");
                    break;
                }
                case 3: {
                    tmp.append("<?" + this.reader.getPITarget() + " " + this.reader.getPIData() + "?>");
                    break;
                }
                case 7: 
                case 8: {
                    throw new OkapiIllegalFilterOperationException("Invalid start or end document detected while processing inline element.");
                }
            }
        }
    }

    private IEncoder getDefaultEncoder() {
        if (null != this.elementEncoder) {
            return this.elementEncoder;
        }
        try {
            this.elementEncoder = (IEncoder)Class.forName(DEFAULT_ENCODER_CLASS_NAME).newInstance();
            this.elementEncoder.setOptions(new DefaultEncoderParameters(true, true, true), this.reader.getEncoding(), null);
            return this.elementEncoder;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NullPointerException ex) {
            throw new OkapiException(ex);
        }
    }

    private void addTU(String name) {
        if (this.tf.isEmpty() && this.context.size() < 3) {
            DocumentPart dp = new DocumentPart(String.valueOf(++this.otherId), false);
            this.skel.append(this.buildEndTag(name) + this.lineBreak);
            dp.setSkeleton(this.skel);
            this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
        } else {
            this.skel.addContentPlaceholder(this.tu);
            if (this.tu.getId() == null) {
                this.tu.setId(String.valueOf(++this.tuId));
            }
            this.tu.setSourceContent(this.tf);
            this.tu.setSkeleton(this.skel);
            this.tu.setMimeType("text/x-odf");
            if (this.tu.isReferent()) {
                this.skel.append(this.buildEndTag(name));
            } else {
                this.skel.append(this.buildEndTag(name) + this.lineBreak);
            }
            this.queue.add(new Event(EventType.TEXT_UNIT, this.tu));
        }
    }

    private boolean processEndElement() {
        String name = this.makePrintName();
        if (this.context.peek().extract && name.equals(this.context.peek().name)) {
            if (this.context.size() > 2) {
                this.addTU(name);
                this.context.pop();
                this.tf = this.context.peek().tf;
                this.tu = this.context.peek().tu;
                this.skel = this.context.peek().skel;
                return false;
            }
            this.context.pop();
            this.addTU(name);
            return true;
        }
        if (this.isDynamicContent() && ElementWithAttributesIndicatingDynamicContent.isSupported(name)) {
            --this.dynamicContentDepth;
            this.skel.append(this.buildEndTag(name));
        } else if (this.context.peek().extract) {
            Code code = new Code(TextFragment.TagType.CLOSING, name, this.buildEndTag(name));
            this.tf.append(code);
            GenericAnnotations.addAnnotations(code, this.annotations.pop());
            this.annotatorsRef.pop();
        } else {
            this.skel.append(this.buildEndTag(name));
            if (name.equals("style:style") || name.equals("text:list-style") || name.equals("draw:frame") || name.equals("text:list") || name.equals("text:list-item")) {
                this.skel.append(this.lineBreak);
            }
        }
        return false;
    }

    private boolean isDynamicContent() {
        return this.dynamicContentDepth > 0;
    }

    private void applyParameters() {
        this.refineProtectionList(TEXT_BOOKMARK_REF, this.params.getExtractReferences());
        this.refineProtectionList(OFFICE_ANNOTATION, this.params.getExtractReferences());
        this.refineExtractionMap(DOCUMENT_TITLE, new ElementRule(DOCUMENT_TITLE, null), this.params.getExtractMetadata());
        this.refineExtractionMap(DOCUMENT_DESCRIPTION, new ElementRule(DOCUMENT_DESCRIPTION, null), this.params.getExtractMetadata());
        this.refineExtractionMap(DOCUMENT_SUBJECT, new ElementRule(DOCUMENT_SUBJECT, null), this.params.getExtractMetadata());
        this.refineExtractionMap(META_KEYWORD, new ElementRule(META_KEYWORD, null), this.params.getExtractMetadata());
        this.refineExtractionMap(META_USER_DEFINED, new ElementRule(META_USER_DEFINED, META_NAME), this.params.getExtractMetadata());
    }

    private void refineProtectionList(String element, boolean condition) {
        if (this.toProtect.contains(element)) {
            if (condition) {
                this.toProtect.remove(element);
            }
        } else if (!condition) {
            this.toProtect.add(element);
        }
    }

    private void refineExtractionMap(String element, ElementRule rule, boolean condition) {
        if (this.toExtract.containsKey(element)) {
            if (!condition) {
                this.toExtract.remove(element);
            }
        } else if (condition) {
            this.toExtract.put(element, rule);
        }
    }

    private static class DefaultEncoderParameters
    implements IParameters {
        private static final String ESCAPE_GT = "escapeGT";
        private static final String ESCAPE_NBSP = "escapeNbsp";
        private static final String ESCAPE_LINE_BREAK = "escapeLineBreak";
        private boolean escapeGt;
        private boolean escapeNbsp;
        private boolean escapeLineBreak;

        DefaultEncoderParameters(boolean escapeGt, boolean escapeNbsp, boolean escapeLineBreak) {
            this.escapeGt = escapeGt;
            this.escapeNbsp = escapeNbsp;
            this.escapeLineBreak = escapeLineBreak;
        }

        @Override
        public boolean getBoolean(String name) {
            switch (name) {
                case "escapeGT": {
                    return this.escapeGt;
                }
                case "escapeNbsp": {
                    return this.escapeNbsp;
                }
                case "escapeLineBreak": {
                    return this.escapeLineBreak;
                }
            }
            return false;
        }

        @Override
        public void setBoolean(String name, boolean value) {
        }

        @Override
        public void reset() {
        }

        @Override
        public void fromString(String data) {
        }

        @Override
        public void load(URL inputURL, boolean ignoreErrors) {
        }

        @Override
        public void load(InputStream inStream, boolean ignoreErrors) {
        }

        @Override
        public void save(String filePath) {
        }

        @Override
        public String getPath() {
            return null;
        }

        @Override
        public void setPath(String filePath) {
        }

        @Override
        public String getString(String name) {
            return null;
        }

        @Override
        public void setString(String name, String value) {
        }

        @Override
        public int getInteger(String name) {
            return 0;
        }

        @Override
        public void setInteger(String name, int value) {
        }

        @Override
        public ParametersDescription getParametersDescription() {
            return null;
        }
    }

    private static enum ElementWithEncodableCharacters {
        PAGE_NUMBER_TEXT("text:page-number"),
        BOOKMARK_REFERENCE_TEXT("text:bookmark-ref"),
        UNSUPPORTED("");

        private final String value;

        private ElementWithEncodableCharacters(String value) {
            this.value = value;
        }

        static ElementWithEncodableCharacters fromValue(String value) {
            if (null == value) {
                return UNSUPPORTED;
            }
            for (ElementWithEncodableCharacters elementWithEncodableCharacters : ElementWithEncodableCharacters.values()) {
                if (!elementWithEncodableCharacters.getValue().equals(value)) continue;
                return elementWithEncodableCharacters;
            }
            return UNSUPPORTED;
        }

        static boolean isSupported(String value) {
            return ElementWithEncodableCharacters.fromValue(value) != UNSUPPORTED;
        }

        String getValue() {
            return this.value;
        }
    }

    private static enum ElementWithAttributesIndicatingDynamicContent {
        TABLE_TABLE_CELL("table:table-cell"),
        UNSUPPORTED("");

        private final String value;

        private ElementWithAttributesIndicatingDynamicContent(String value) {
            this.value = value;
        }

        static ElementWithAttributesIndicatingDynamicContent fromValue(String value) {
            if (null == value) {
                return UNSUPPORTED;
            }
            for (ElementWithAttributesIndicatingDynamicContent elementWithAttributesIndicatingDynamicContent : ElementWithAttributesIndicatingDynamicContent.values()) {
                if (!elementWithAttributesIndicatingDynamicContent.getValue().equals(value)) continue;
                return elementWithAttributesIndicatingDynamicContent;
            }
            return UNSUPPORTED;
        }

        static boolean isSupported(String value) {
            return ElementWithAttributesIndicatingDynamicContent.fromValue(value) != UNSUPPORTED;
        }

        String getValue() {
            return this.value;
        }
    }

    private static enum AttributeIndicatingDynamicContent {
        TABLE_FORMULA("table:formula"),
        UNSUPPORTED("");

        private final String value;

        private AttributeIndicatingDynamicContent(String value) {
            this.value = value;
        }

        static AttributeIndicatingDynamicContent fromValue(String value) {
            if (null == value) {
                return UNSUPPORTED;
            }
            for (AttributeIndicatingDynamicContent attributeIndicatingDynamicContent : AttributeIndicatingDynamicContent.values()) {
                if (!attributeIndicatingDynamicContent.getValue().equals(value)) continue;
                return attributeIndicatingDynamicContent;
            }
            return UNSUPPORTED;
        }

        static boolean isSupported(String value) {
            return AttributeIndicatingDynamicContent.fromValue(value) != UNSUPPORTED;
        }

        String getValue() {
            return this.value;
        }
    }
}

