/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.multiparsers;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.SpinInputPart;
import net.sf.okapi.common.uidescription.TextInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    public static final String CSV_NOEXTRACTCOLS = "csvNoExtractCols";
    public static final String CSV_FORMATCOLS = "csvFormatCols";
    public static final String CSV_STARTINGROW = "csvStartingRow";
    public static final String CSV_AUTODETECTCOLUMNTYPES = "csvAutoDetectColumnTypes";
    public static final String CSV_AUTODETECTCOLUMNTYPESROW = "csvAutoDetectColumnTypesRow";

    @Override
    public void reset() {
        super.reset();
        this.setCsvStartingRow(1);
        this.setCsvAutoDetectColumnTypes(false);
        this.setCsvAutoDetectColumnTypesRow(2);
    }

    public String getCsvNoExtractCols() {
        return this.getString(CSV_NOEXTRACTCOLS);
    }

    public void setCsvNoExtractCols(String csvNoExtractCols) {
        this.setString(CSV_NOEXTRACTCOLS, csvNoExtractCols);
    }

    public String getCsvFormatCols() {
        return this.getString(CSV_FORMATCOLS);
    }

    public void setCsvFormatCols(String csvFormatCols) {
        this.setString(CSV_FORMATCOLS, csvFormatCols);
    }

    public int getCsvStartingRow() {
        return this.getInteger(CSV_STARTINGROW);
    }

    public void setCsvStartingRow(int csvStartingRow) {
        this.setInteger(CSV_STARTINGROW, csvStartingRow);
    }

    public boolean getCsvAutoDetectColumnTypes() {
        return this.getBoolean(CSV_AUTODETECTCOLUMNTYPES);
    }

    public void setCsvAutoDetectColumnTypes(boolean csvAutoDetectColumnTypes) {
        this.setBoolean(CSV_AUTODETECTCOLUMNTYPES, csvAutoDetectColumnTypes);
    }

    public int getCsvAutoDetectColumnTypesRow() {
        return this.getInteger(CSV_AUTODETECTCOLUMNTYPESROW);
    }

    public void setCsvAutoDetectColumnTypesRow(int csvAutoDetectColumnTypesRow) {
        this.setInteger(CSV_AUTODETECTCOLUMNTYPESROW, csvAutoDetectColumnTypesRow);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(CSV_AUTODETECTCOLUMNTYPES, "Use auto-detection (a special row in each input file)", null);
        desc.add(CSV_AUTODETECTCOLUMNTYPESROW, "Row at which the special configuration information is (first=1)", null);
        desc.add(CSV_NOEXTRACTCOLS, "Comma-separated list of the colums not to extract (first=0)", null);
        desc.add(CSV_FORMATCOLS, "Comma-separated list of the colums with non-plain-text content (e.g. '3:okf_markdown', first=0)", null);
        desc.add(CSV_STARTINGROW, "Row at which the extraction starts (first=1)", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Multi-Parsers Filter Parameters", true, false);
        CheckboxPart cp = desc.addCheckboxPart(paramDesc.get(CSV_AUTODETECTCOLUMNTYPES));
        SpinInputPart sip = desc.addSpinInputPart(paramDesc.get(CSV_AUTODETECTCOLUMNTYPESROW));
        sip.setRange(1, 9999999);
        sip.setMasterPart(cp, true);
        TextInputPart tip = desc.addTextInputPart(paramDesc.get(CSV_NOEXTRACTCOLS));
        tip.setAllowEmpty(true);
        tip.setMasterPart(cp, false);
        tip = desc.addTextInputPart(paramDesc.get(CSV_FORMATCOLS));
        tip.setAllowEmpty(true);
        tip.setMasterPart(cp, false);
        sip = desc.addSpinInputPart(paramDesc.get(CSV_STARTINGROW));
        sip.setRange(1, 9999999);
        sip.setMasterPart(cp, false);
        return desc;
    }
}

