/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.tda;

import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiNotImplementedException;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.tda.Parameters;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.ITMQuery;
import net.sf.okapi.lib.translation.QueryUtil;
import net.sf.okapi.lib.translation.TextMatcher;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class TDASearchConnector
extends BaseConnector
implements ITMQuery {
    private static final String[][] LANGSMAP = new String[][]{{"ar", "ar-ar"}, {"cs", "cs-cz"}, {"cy", "cy-gb"}, {"da", "da-dk"}, {"el", "el-gr"}, {"en", "en-us"}, {"et", "et-ee"}, {"fa", "fa-ir"}, {"he", "he-il"}, {"ko", "ko-kr"}, {"nb", "nb-no"}, {"nn", "nn-no"}, {"sl", "sl-si"}, {"sv", "sv-se"}, {"uk", "uk-ua"}, {"vi", "vi-vn"}, {"zh", "zh-cn"}};
    private JSONParser parser;
    private Parameters params;
    private String baseURL;
    private String authKey;
    private int current = -1;
    private int maxHits = 20;
    private List<QueryResult> results;
    private TextMatcher matcher;
    private ScoreComparer scorComp = new ScoreComparer();
    private int threshold = 60;
    private QueryUtil qutil;

    public TDASearchConnector() {
        this.parser = new JSONParser();
        this.params = new Parameters();
        this.qutil = new QueryUtil();
    }

    @Override
    public void close() {
        this.authKey = null;
    }

    @Override
    public String getName() {
        return "TDA-Search";
    }

    @Override
    public String getSettingsDisplay() {
        String tmp = "Server: " + (Util.isEmpty(this.params.getServer()) ? "<To be specified>" : this.params.getServer());
        return tmp + "\nUser: " + (Util.isEmpty(this.params.getUsername()) ? "<To be specified>" : this.params.getUsername());
    }

    @Override
    public void open() {
        this.baseURL = this.params.getServer();
        if (!this.baseURL.endsWith("/")) {
            this.baseURL = this.baseURL + "/";
        }
        this.authKey = null;
    }

    @Override
    public int query(String plainText) {
        this.results = new ArrayList<QueryResult>();
        this.current = -1;
        if (Util.isEmpty(plainText)) {
            return 0;
        }
        return this.doTDAQuery(plainText, plainText);
    }

    @Override
    public int query(TextFragment frag) {
        this.results = new ArrayList<QueryResult>();
        this.current = -1;
        if (!frag.hasText(false)) {
            return 0;
        }
        return this.doTDAQuery(this.qutil.separateCodesFromText(frag), frag.toText());
    }

    @Override
    public List<List<QueryResult>> batchQuery(List<TextFragment> fragments) {
        throw new OkapiNotImplementedException();
    }

    private int doTDAQuery(String query, String original) {
        try {
            JSONObject object;
            this.loginIfNeeded();
            query = query.replaceAll("\\p{Po}", "");
            URL url = new URL(this.baseURL + String.format("segment.json?limit=%d&source_lang=%s&target_lang=%s", this.maxHits, this.srcCode, this.trgCode) + "&auth_auth_key=" + this.authKey + (this.params.getIndustry() > 0 ? "&industry=" + this.params.getIndustry() : "") + (this.params.getContentType() > 0 ? "&content_type=" + this.params.getContentType() : "") + "&q=" + URLEncoder.encode(query, "UTF-8"));
            URLConnection conn = url.openConnection();
            JSONObject map = object = (JSONObject)this.parser.parse((Reader)new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            JSONArray array = (JSONArray)map.get("segment");
            int count = array.size() > this.maxHits ? this.maxHits : array.size();
            for (int i = 0; i < count; ++i) {
                Map entry = (Map)array.get(i);
                QueryResult result = new QueryResult();
                result.weight = this.getWeight();
                result.source = new TextFragment((String)entry.get("source"));
                result.target = new TextFragment((String)entry.get("target"));
                result.origin = "TDA";
                String tmp = (String)((Map)entry.get("provider")).get("name");
                if (!Util.isEmpty(tmp)) {
                    result.origin = result.origin + "/" + tmp;
                }
                result.setFuzzyScore(90);
                this.results.add(result);
            }
            this.fixupResults(original);
            this.current = this.results.size() > 0 ? 0 : -1;
        }
        catch (Throwable e) {
            throw new OkapiException("Error querying the server." + e.getMessage(), e);
        }
        return this.current == 0 ? 1 : 0;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected String toInternalCode(LocaleId locale) {
        String code = locale.toBCP47();
        String lang = locale.getLanguage();
        if (locale.getRegion() == null) {
            boolean found = false;
            for (int i = 0; i < LANGSMAP.length; ++i) {
                if (!lang.equals(LANGSMAP[i][0])) continue;
                code = LANGSMAP[i][1];
                found = true;
                break;
            }
            if (!found) {
                code = lang + "-" + lang;
            }
        }
        return code;
    }

    private void loginIfNeeded() {
        if (this.authKey != null) {
            return;
        }
        try {
            JSONObject object;
            URL url = new URL(this.baseURL + "auth_key.json?action=login");
            URLConnection conn = url.openConnection();
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            String content = String.format("auth_username=%s&auth_password=%s&app_key=%s", URLEncoder.encode(this.params.getUsername(), "UTF-8"), URLEncoder.encode(this.params.getPassword(), "UTF-8"), this.params.getAppKey());
            out.writeBytes(content);
            out.flush();
            out.close();
            JSONObject map = object = (JSONObject)this.parser.parse((Reader)new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            Map data = (Map)map.get("auth_key");
            this.authKey = (String)data.get("id");
        }
        catch (Throwable e) {
            throw new OkapiException("Error while login to the server." + e.getMessage(), e);
        }
    }

    @Override
    public int getMaximumHits() {
        return this.maxHits;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public void setMaximumHits(int max) {
        this.maxHits = max;
    }

    @Override
    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public void clearAttributes() {
    }

    @Override
    public boolean hasNext() {
        if (this.results == null) {
            return false;
        }
        if (this.current >= this.results.size()) {
            this.current = -1;
        }
        return this.current > -1;
    }

    @Override
    public QueryResult next() {
        if (this.results == null) {
            return null;
        }
        if (this.current > -1 && this.current < this.results.size()) {
            ++this.current;
            return this.results.get(this.current - 1);
        }
        this.current = -1;
        return null;
    }

    @Override
    public void removeAttribute(String name) {
    }

    @Override
    public void setAttribute(String name, String value) {
    }

    @Override
    public void setLanguages(LocaleId sourceLocale, LocaleId targetLocale) {
        super.setLanguages(sourceLocale, targetLocale);
        this.matcher = new TextMatcher(sourceLocale, sourceLocale);
    }

    @Override
    public void setRootDirectory(String rootDir) {
    }

    private void fixupResults(String plainText) {
        if (this.results.size() == 0) {
            return;
        }
        List<String> tokens = this.matcher.prepareBaseTokens(plainText);
        Iterator<QueryResult> iter = this.results.iterator();
        while (iter.hasNext()) {
            QueryResult qr = iter.next();
            qr.setFuzzyScore(this.matcher.compareToBaseTokens(plainText, tokens, qr.source));
            if (qr.getFuzzyScore() < this.threshold) {
                iter.remove();
                continue;
            }
            if (qr.getFuzzyScore() >= 100) {
                qr.matchType = MatchType.EXACT;
                continue;
            }
            if (qr.getFuzzyScore() <= 0) continue;
            qr.matchType = MatchType.FUZZY;
        }
        this.results.sort(this.scorComp);
    }

    static class ScoreComparer
    implements Comparator<QueryResult> {
        ScoreComparer() {
        }

        @Override
        public int compare(QueryResult arg0, QueryResult arg1) {
            return Integer.compare(arg1.getFuzzyScore(), arg0.getFuzzyScore());
        }
    }
}

